/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.email;

import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache$;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.notifications.configuration.trigger.RecipientSettings;
import com.xebialabs.xlrelease.notifications.package$;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.PrincipalInfoResolver;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.service.UserProfileService;
import com.xebialabs.xlrelease.user.User;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001\u0002\t\u0012\u0001qA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tY\u0001\u0011\t\u0011)A\u0005[!A1\u0007\u0001B\u0001B\u0003%A\u0007\u0003\u00058\u0001\t\u0005\t\u0015!\u00039\u0011\u0015Y\u0004\u0001\"\u0001=\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u0015\t\u0007\u0001\"\u0001c\u0011%\t)\u0001AI\u0001\n\u0003\t9\u0001C\u0004\u0002\u001c\u0001!I!!\b\t\u000f\u0005\r\u0002\u0001\"\u0003\u0002&!9\u00111\n\u0001\u0005\n\u00055\u0003bBA0\u0001\u0011%\u0011\u0011\r\u0005\b\u0003g\u0002A\u0011BA;\u0011\u001d\t\u0019\t\u0001C\u0005\u0003\u000bCq!a#\u0001\t\u0013\tiI\u0001\fF[\u0006LGNU3dSBLWM\u001c;SKN|GN^3s\u0015\t\u00112#A\u0003f[\u0006LGN\u0003\u0002\u0015+\u0005ian\u001c;jM&\u001c\u0017\r^5p]NT!AF\f\u0002\u0013ad'/\u001a7fCN,'B\u0001\r\u001a\u0003%AXMY5bY\u0006\u00147OC\u0001\u001b\u0003\r\u0019w.\\\u0002\u0001'\t\u0001Q\u0004\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0004B]f\u0014VMZ\u0001\fe>dWmU3sm&\u001cW\r\u0005\u0002&U5\taE\u0003\u0002(Q\u0005A1/Z2ve&$\u0018P\u0003\u0002*/\u0005AA-\u001a9m_fLG/\u0003\u0002,M\tY!k\u001c7f'\u0016\u0014h/[2f\u0003-!X-Y7TKJ4\u0018nY3\u0011\u00059\nT\"A\u0018\u000b\u0005A*\u0012aB:feZL7-Z\u0005\u0003e=\u00121\u0002V3b[N+'O^5dK\u0006\u0011Ro]3s!J|g-\u001b7f'\u0016\u0014h/[2f!\tqS'\u0003\u00027_\t\u0011Rk]3s!J|g-\u001b7f'\u0016\u0014h/[2f\u0003U\u0001(/\u001b8dSB\fG.\u00138g_J+7o\u001c7wKJ\u0004\"AL\u001d\n\u0005iz#!\u0006)sS:\u001c\u0017\u000e]1m\u0013:4wNU3t_24XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000buz\u0004)\u0011\"\u0011\u0005y\u0002Q\"A\t\t\u000b\r*\u0001\u0019\u0001\u0013\t\u000b1*\u0001\u0019A\u0017\t\u000bM*\u0001\u0019\u0001\u001b\t\u000b]*\u0001\u0019\u0001\u001d)\u0005\u0015!\u0005CA#Q\u001b\u00051%BA$I\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u0013*\u000bqAZ1di>\u0014\u0018P\u0003\u0002L\u0019\u0006)!-Z1og*\u0011QJT\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tq*A\u0002pe\u001eL!!\u0015$\u0003\u0013\u0005+Ho\\<je\u0016$\u0017\u0001\u0005:fg>dg/\u001a*fG&\u0004\u0018.\u001a8u)\t!v\f\u0005\u0002V9:\u0011aK\u0017\t\u0003/~i\u0011\u0001\u0017\u0006\u00033n\ta\u0001\u0010:p_Rt\u0014BA. \u0003\u0019\u0001&/\u001a3fM&\u0011QL\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005m{\u0002\"\u00021\u0007\u0001\u0004!\u0016!\u00049sS:\u001c\u0017\u000e]1m\u001d\u0006lW-A\tsKN|GN^3SK\u000eL\u0007/[3oiN$ba\u00194rgVl\bcA+e)&\u0011QM\u0018\u0002\u0004'\u0016$\b\"B4\b\u0001\u0004A\u0017!\u0002:pY\u0016\u001c\bcA5o):\u0011!\u000e\u001c\b\u0003/.L\u0011\u0001I\u0005\u0003[~\tq\u0001]1dW\u0006<W-\u0003\u0002pa\n!A*[:u\u0015\tiw\u0004C\u0003s\u000f\u0001\u0007\u0001.A\u0006hY>\u0014\u0017\r\u001c*pY\u0016\u001c\b\"\u0002;\b\u0001\u0004A\u0017!B;tKJ\u001c\b\"\u0002<\b\u0001\u00049\u0018\u0001\u00039mC:LE/Z7\u0011\u0005a\\X\"A=\u000b\u0005i,\u0012A\u00023p[\u0006Lg.\u0003\u0002}s\nA\u0001\u000b\\1o\u0013R,W\u000eC\u0004\u007f\u000fA\u0005\t\u0019A@\u0002\u001b\u0015D8\r\\;eK\u0006+H\u000f[8s!\rq\u0012\u0011A\u0005\u0004\u0003\u0007y\"a\u0002\"p_2,\u0017M\\\u0001\u001ce\u0016\u001cx\u000e\u001c<f%\u0016\u001c\u0017\u000e]5f]R\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005%!fA@\u0002\f-\u0012\u0011Q\u0002\t\u0005\u0003\u001f\t9\"\u0004\u0002\u0002\u0012)!\u00111CA\u000b\u0003%)hn\u00195fG.,GM\u0003\u0002H?%!\u0011\u0011DA\t\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eSN,6/\u001a:F]\u0006\u0014G.\u001a3\u0015\u0007}\fy\u0002\u0003\u0004\u0002\"%\u0001\r\u0001V\u0001\tkN,'O\\1nK\u0006Q\u0001/\u0019:tKJ{G.Z:\u0015\u0013\r\f9#a\r\u00026\u0005]\u0002bBA\u0015\u0015\u0001\u0007\u00111F\u0001\fCN\u001c\u0018n\u001a8nK:$8\u000f\u0005\u0003j]\u00065\u0002cA\u0013\u00020%\u0019\u0011\u0011\u0007\u0014\u0003\tI{G.\u001a\u0005\u0006O*\u0001\r\u0001\u001b\u0005\u0006m*\u0001\ra\u001e\u0005\b\u0003sQ\u0001\u0019AA\u001e\u0003\u0015\u0019\u0017m\u00195f!\u0011\ti$a\u0012\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\n\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0004\u0003\u000b*\u0012aA1qS&!\u0011\u0011JA \u0005=!UmY8sCR|'o]\"bG\",\u0017A\u00049beN,G+Y:l%>dWm\u001d\u000b\nG\u0006=\u0013\u0011LA.\u0003;Bq!!\u0015\f\u0001\u0004\t\u0019&\u0001\u0003uCN\\\u0007c\u0001=\u0002V%\u0019\u0011qK=\u0003\tQ\u000b7o\u001b\u0005\u0006O.\u0001\r\u0001\u001b\u0005\b\u0003SY\u0001\u0019AA\u0016\u0011\u001d\tId\u0003a\u0001\u0003w\t\u0011\u0003]1sg\u0016\u0014V\r\\3bg\u0016\u0014v\u000e\\3t)%\u0019\u00171MA7\u0003_\n\t\bC\u0004\u0002f1\u0001\r!a\u001a\u0002\u000fI,G.Z1tKB\u0019\u00010!\u001b\n\u0007\u0005-\u0014PA\u0004SK2,\u0017m]3\t\u000b\u001dd\u0001\u0019\u00015\t\u000f\u0005%B\u00021\u0001\u0002,!9\u0011\u0011\b\u0007A\u0002\u0005m\u0012!E4fiJ+G.Z1tK6+WNY3sgRA\u0011qOA?\u0003\u007f\n\t\t\u0005\u0003\u001f\u0003s\u001a\u0017bAA>?\t1q\n\u001d;j_:Dq!!\u001a\u000e\u0001\u0004\t9\u0007C\u0004\u0002*5\u0001\r!a\u000b\t\u000f\u0005eR\u00021\u0001\u0002<\u0005\u0001\u0002/\u0019:tK\u001ecwNY1m%>dWm\u001d\u000b\u0006Q\u0006\u001d\u0015\u0011\u0012\u0005\b\u0003Sq\u0001\u0019AA\u0016\u0011\u0015\u0011h\u00021\u0001i\u000359W\r^!mY6+WNY3sgR)1-a$\u0002\u001a\"9\u0011\u0011S\bA\u0002\u0005M\u0015\u0001\u0002;fC6\u00042\u0001_AK\u0013\r\t9*\u001f\u0002\u0005)\u0016\fW\u000eC\u0004\u0002*=\u0001\r!a\u000b)\u0007\u0001\ti\n\u0005\u0003\u0002 \u0006\u0015VBAAQ\u0015\r\t\u0019\u000bT\u0001\u000bgR,'/Z8usB,\u0017\u0002BAT\u0003C\u0013qaU3sm&\u001cW\r")
public class EmailRecipientResolver {
    private final RoleService roleService;
    private final TeamService teamService;
    private final UserProfileService userProfileService;
    private final PrincipalInfoResolver principalInfoResolver;

    public String resolveRecipient(String principalName) {
        return this.principalInfoResolver.getNotificationEmailOf(principalName);
    }

    public Set<String> resolveRecipients(List<String> roles, List<String> globalRoles, List<String> users, PlanItem planItem, boolean excludeAuthor) {
        List assignments = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService.readRoleAssignments()).asScala()).toList();
        DecoratorsCache cache = new DecoratorsCache(DecoratorsCache$.MODULE$.$lessinit$greater$default$1());
        Set allPrincipals = (Set)this.parseRoles((List<Role>)assignments, roles, planItem, cache).$plus$plus(this.parseGlobalRoles((List<Role>)assignments, globalRoles)).$plus$plus(users).$minus$minus((GenTraversableOnce)(excludeAuthor ? Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{User.AUTHENTICATED_USER.getName()})) : Nil$.MODULE$));
        return (Set)((TraversableLike)((SetLike)allPrincipals.filter((Function1 & Serializable & scala.Serializable)username -> BoxesRunTime.boxToBoolean((boolean)this.isUserEnabled(username)))).map((Function1 & Serializable & scala.Serializable)x$1 -> $this.principalInfoResolver.getNotificationEmailOf(x$1), Set$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$resolveRecipients$3(x$1)));
    }

    public boolean resolveRecipients$default$5() {
        return false;
    }

    private boolean isUserEnabled(String username) {
        UserProfile profile = this.userProfileService.findByUsername(username);
        return profile != null ? profile.isLoginAllowed() : true;
    }

    private Set<String> parseRoles(List<Role> assignments, List<String> roles, PlanItem planItem, DecoratorsCache cache) {
        Set<String> set;
        PlanItem planItem2 = planItem;
        if (planItem2 instanceof Task) {
            Task task = (Task)planItem2;
            set = this.parseTaskRoles(task, roles, assignments, cache);
        } else if (planItem2 instanceof Release) {
            Release release = (Release)planItem2;
            set = this.parseReleaseRoles(release, roles, assignments, cache);
        } else {
            throw new MatchError((Object)planItem2);
        }
        return set;
    }

    private Set<String> parseTaskRoles(Task task, List<String> roles, List<Role> assignments, DecoratorsCache cache) {
        ObjectRef parsed;
        block3: {
            parsed = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
            boolean shouldSendToTaskOwner = roles.contains((Object)"Task Owner");
            Option taskOwner = Option$.MODULE$.apply((Object)task.getOwner());
            if (shouldSendToTaskOwner && taskOwner.isDefined()) {
                parsed.elem = (Set)((Set)parsed.elem).$plus(taskOwner.get());
            }
            if (roles.contains((Object)"Task Team") || shouldSendToTaskOwner && taskOwner.isEmpty()) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.teamService.findTeamByName(Ids.releaseIdFrom((String)task.getId()), task.getTeam()))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    parsed.elem = (Set)((Set)parsed.elem).$plus$plus(this.getAllMembers(x$3, (List<Role>)assignments));
                    return BoxedUnit.UNIT;
                });
            }
            if (roles.contains((Object)RecipientSettings.RELEASE_ADMIN_ROLE_NAME)) {
                parsed.elem = (Set)((Set)parsed.elem).$plus$plus((GenTraversableOnce)this.getReleaseMembers(task.getRelease(), assignments, cache).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
            }
            if (!roles.contains((Object)"Watcher")) break block3;
            Set<String> watchers = package$.MODULE$.TaskWithNotificationFields(task).getWatchers();
            watchers.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                parsed.elem = (Set)((Set)parsed.elem).$plus((Object)x$4);
                return BoxedUnit.UNIT;
            });
        }
        return (Set)parsed.elem;
    }

    private Set<String> parseReleaseRoles(Release release, List<String> roles, List<Role> assignments, DecoratorsCache cache) {
        Set parsed;
        block0: {
            parsed = Predef$.MODULE$.Set().empty();
            if (!roles.contains((Object)RecipientSettings.RELEASE_ADMIN_ROLE_NAME)) break block0;
            parsed = (Set)parsed.$plus$plus((GenTraversableOnce)this.getReleaseMembers(release, assignments, cache).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
        }
        return parsed;
    }

    private Option<Set<String>> getReleaseMembers(Release release, List<Role> assignments, DecoratorsCache cache) {
        Option effectiveTeams = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.teamService.getEffectiveTeams(release, cache)).asScala()).find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$getReleaseMembers$1(x$5)));
        return effectiveTeams.map((Function1 & Serializable & scala.Serializable)x$6 -> this.getAllMembers((Team)x$6, assignments));
    }

    private List<String> parseGlobalRoles(List<Role> assignments, List<String> globalRoles) {
        List<String> list = globalRoles;
        Object object = Nil$.MODULE$.equals(list) ? Nil$.MODULE$ : (List)((List)assignments.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)globalRoles.contains((Object)r.getName())))).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(x$7.getPrincipals()).asScala()).toList(), List$.MODULE$.canBuildFrom());
        return object;
    }

    private Set<String> getAllMembers(Team team, List<Role> assignments) {
        Set teamMembers = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(team.getMembers()).asScala()).toSet();
        List roleMembers = (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(team.getRoles()).asScala()).toList().flatMap((Function1 & Serializable & scala.Serializable)roleName -> (List)assignments.find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$getAllMembers$2(roleName, x$8))).toList().flatMap((Function1 & Serializable & scala.Serializable)role -> (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(role.getPrincipals()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)principal -> {
            $this.userProfileService.discover(principal);
            return principal;
        }, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
        return (Set)teamMembers.$plus$plus((GenTraversableOnce)roleMembers);
    }

    public static final /* synthetic */ boolean $anonfun$resolveRecipients$4(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2.trim())).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$resolveRecipients$3(String x$1) {
        return Option$.MODULE$.apply((Object)x$1).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$resolveRecipients$4(x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$getReleaseMembers$1(Team x$5) {
        String string = x$5.getTeamName();
        String string2 = "Release Admin";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getAllMembers$2(String roleName$1, Role x$8) {
        String string = x$8.getName();
        String string2 = roleName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Autowired
    public EmailRecipientResolver(RoleService roleService, TeamService teamService, UserProfileService userProfileService, PrincipalInfoResolver principalInfoResolver) {
        this.roleService = roleService;
        this.teamService = teamService;
        this.userProfileService = userProfileService;
        this.principalInfoResolver = principalInfoResolver;
    }
}

