/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.handlers;

import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.TaskDueSoonEvent;
import com.xebialabs.xlrelease.domain.events.TaskFailedEvent;
import com.xebialabs.xlrelease.domain.events.TaskOverdueEvent;
import com.xebialabs.xlrelease.domain.events.TaskRetriedEvent;
import com.xebialabs.xlrelease.domain.events.TaskStartedEvent;
import com.xebialabs.xlrelease.domain.events.TaskUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TaskWaitingForInputEvent;
import com.xebialabs.xlrelease.domain.status.FlagStatus;
import com.xebialabs.xlrelease.events.AsyncSubscribe;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.notifications.ActiveTaskAssigned;
import com.xebialabs.xlrelease.notifications.ActiveTaskUnassigned;
import com.xebialabs.xlrelease.notifications.ManualTaskStarted;
import com.xebialabs.xlrelease.notifications.ManualTaskStartedWithoutAssignee;
import com.xebialabs.xlrelease.notifications.NotificationService;
import com.xebialabs.xlrelease.notifications.TaskDueSoon;
import com.xebialabs.xlrelease.notifications.TaskFailed;
import com.xebialabs.xlrelease.notifications.TaskFlagged;
import com.xebialabs.xlrelease.notifications.TaskOverdue;
import com.xebialabs.xlrelease.notifications.TaskWaitingForInput;
import com.xebialabs.xlrelease.notifications.package$;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Component
@EventListener
@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001\u0002\u0007\u000e\u0001aA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\u0006I\u0001!\t!\n\u0005\u0006q\u0001!\t!\u000f\u0005\u0006\u001b\u0002!IA\u0014\u0005\u0006!\u0002!\t!\u0015\u0005\u0006/\u0002!\t\u0001\u0017\u0005\u0006=\u0002!\ta\u0018\u0005\u0006K\u0002!\tA\u001a\u0005\u0006Y\u0002!\t!\u001c\u0005\u0006g\u0002!\t\u0001\u001e\u0005\u0006u\u0002!Ia\u001f\u0002\u001d)\u0006\u001c8NT8uS\u001aL7-\u0019;j_:,e/\u001a8u\u0011\u0006tG\r\\3s\u0015\tqq\"\u0001\u0005iC:$G.\u001a:t\u0015\t\u0001\u0012#A\u0007o_RLg-[2bi&|gn\u001d\u0006\u0003%M\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005Q)\u0012!\u0003=fE&\fG.\u00192t\u0015\u00051\u0012aA2p[\u000e\u00011C\u0001\u0001\u001a!\tQR$D\u0001\u001c\u0015\u0005a\u0012!B:dC2\f\u0017B\u0001\u0010\u001c\u0005\u0019\te.\u001f*fM\u0006\u0019bn\u001c;jM&\u001c\u0017\r^5p]N+'O^5dKB\u0011\u0011EI\u0007\u0002\u001f%\u00111e\u0004\u0002\u0014\u001d>$\u0018NZ5dCRLwN\\*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0019B\u0003CA\u0014\u0001\u001b\u0005i\u0001\"B\u0010\u0003\u0001\u0004\u0001\u0003F\u0001\u0002+!\tYc'D\u0001-\u0015\tic&\u0001\u0006b]:|G/\u0019;j_:T!a\f\u0019\u0002\u000f\u0019\f7\r^8ss*\u0011\u0011GM\u0001\u0006E\u0016\fgn\u001d\u0006\u0003gQ\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002k\u0005\u0019qN]4\n\u0005]b#!C!vi><\u0018N]3e\u00035yg\u000eV1tWV\u0003H-\u0019;fIR\u0011!(\u0010\t\u00035mJ!\u0001P\u000e\u0003\tUs\u0017\u000e\u001e\u0005\u0006}\r\u0001\raP\u0001\u0006KZ,g\u000e\u001e\t\u0003\u0001\u0016k\u0011!\u0011\u0006\u0003\u0005\u000e\u000ba!\u001a<f]R\u001c(B\u0001#\u0012\u0003\u0019!w.\\1j]&\u0011a)\u0011\u0002\u0011)\u0006\u001c8.\u00169eCR,G-\u0012<f]RD#a\u0001%\u0011\u0005%[U\"\u0001&\u000b\u0005\t\u000b\u0012B\u0001'K\u00059\t5/\u001f8d'V\u00147o\u0019:jE\u0016\f!C\\8uS\u001aLxj\u001e8fe\u0006sG\rV3b[R\u0011!h\u0014\u0005\u0006}\u0011\u0001\raP\u0001\u000e_:$\u0016m]6Ti\u0006\u0014H/\u001a3\u0015\u0005i\u0012\u0006\"\u0002 \u0006\u0001\u0004\u0019\u0006C\u0001!U\u0013\t)\u0016I\u0001\tUCN\\7\u000b^1si\u0016$WI^3oi\"\u0012Q\u0001S\u0001\u000e_:$\u0016m]6SKR\u0014\u0018.\u001a3\u0015\u0005iJ\u0006\"\u0002 \u0007\u0001\u0004Q\u0006C\u0001!\\\u0013\ta\u0016I\u0001\tUCN\\'+\u001a;sS\u0016$WI^3oi\"\u0012a\u0001S\u0001\r_:$\u0016m]6GC&dW\r\u001a\u000b\u0003u\u0001DQAP\u0004A\u0002\u0005\u0004\"\u0001\u00112\n\u0005\r\f%a\u0004+bg.4\u0015-\u001b7fI\u00163XM\u001c;)\u0005\u001dA\u0015!F8o)\u0006\u001c8nV1ji&twMR8s\u0013:\u0004X\u000f\u001e\u000b\u0003u\u001dDQA\u0010\u0005A\u0002!\u0004\"\u0001Q5\n\u0005)\f%\u0001\u0007+bg.<\u0016-\u001b;j]\u001e4uN]%oaV$XI^3oi\"\u0012\u0001\u0002S\u0001\u000e_:$\u0016m]6Pm\u0016\u0014H-^3\u0015\u0005ir\u0007\"\u0002 \n\u0001\u0004y\u0007C\u0001!q\u0013\t\t\u0018I\u0001\tUCN\\wJ^3sIV,WI^3oi\"\u0012\u0011\u0002S\u0001\u000e_:$\u0016m]6Ek\u0016\u001cvn\u001c8\u0015\u0005i*\b\"\u0002 \u000b\u0001\u00041\bC\u0001!x\u0013\tA\u0018I\u0001\tUCN\\G)^3T_>tWI^3oi\"\u0012!\u0002S\u0001\u0018]>$\u0018NZ=NC:,\u0018\r\u001c+bg.\u001cF/\u0019:uK\u0012$\"A\u000f?\t\u000bu\\\u0001\u0019\u0001@\u0002\tQ\f7o\u001b\t\u0004\u007f\u0006\u0005Q\"A\"\n\u0007\u0005\r1I\u0001\u0003UCN\\\u0007f\u0001\u0001\u0002\bA\u0019\u0011*!\u0003\n\u0007\u0005-!JA\u0007Fm\u0016tG\u000fT5ti\u0016tWM\u001d\u0015\u0004\u0001\u0005=\u0001\u0003BA\t\u0003/i!!a\u0005\u000b\u0007\u0005U!'\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!!\u0007\u0002\u0014\tI1i\\7q_:,g\u000e\u001e")
public class TaskNotificationEventHandler {
    private final NotificationService notificationService;

    @AsyncSubscribe
    public void onTaskUpdated(TaskUpdatedEvent event) {
        block3: {
            Tuple2 tuple2 = new Tuple2((Object)event.original(), (Object)event.updated());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Task original = (Task)tuple2._1();
            Task updated = (Task)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)original, (Object)updated);
            Tuple2 tuple23 = tuple22;
            Task original2 = (Task)tuple23._1();
            Task updated2 = (Task)tuple23._2();
            if (!updated2.isActive()) break block3;
            this.notifyOwnerAndTeam(event);
            FlagStatus flagStatus = original2.getFlagStatus();
            FlagStatus flagStatus2 = updated2.getFlagStatus();
            if (flagStatus == null ? flagStatus2 != null : !flagStatus.equals(flagStatus2)) {
                FlagStatus flagStatus3 = updated2.getFlagStatus();
                FlagStatus flagStatus4 = FlagStatus.OK;
                if (flagStatus3 == null ? flagStatus4 != null : !flagStatus3.equals(flagStatus4)) {
                    this.notificationService.notify(new TaskFlagged((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)updated2))));
                }
            }
        }
    }

    private void notifyOwnerAndTeam(TaskUpdatedEvent event) {
        block4: {
            Option updatedTeam;
            Option originalTeam;
            Task updated;
            Task original;
            block5: {
                Option updatedOwner;
                Option originalOwner;
                block3: {
                    Tuple2 tuple2 = new Tuple2((Object)event.original(), (Object)event.updated());
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Task original2 = (Task)tuple2._1();
                    Task updated2 = (Task)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)original2, (Object)updated2);
                    Tuple2 tuple23 = tuple22;
                    original = (Task)tuple23._1();
                    updated = (Task)tuple23._2();
                    originalOwner = Option$.MODULE$.apply((Object)original.getOwner());
                    updatedOwner = Option$.MODULE$.apply((Object)updated.getOwner());
                    originalTeam = Option$.MODULE$.apply((Object)original.getTeam());
                    updatedTeam = Option$.MODULE$.apply((Object)updated.getTeam());
                    if (!TaskNotificationEventHandler.isOwnerOrTeamUnassigned$1(originalOwner, updatedOwner, originalTeam, updatedTeam)) break block3;
                    this.notificationService.notify(new ActiveTaskUnassigned((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)original))));
                    break block4;
                }
                if (!TaskNotificationEventHandler.isOwnerUpdated$1(originalOwner, updatedOwner)) break block5;
                if (originalOwner.isDefined()) {
                    this.notificationService.notify(new ActiveTaskUnassigned((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)original))));
                }
                this.notificationService.notify(new ActiveTaskAssigned((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)updated))));
                break block4;
            }
            if (!TaskNotificationEventHandler.isTeamUpdated$1(originalTeam, updatedTeam)) break block4;
            if (originalTeam.isDefined()) {
                this.notificationService.notify(new ActiveTaskUnassigned((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)original))));
            }
            this.notificationService.notify(new ActiveTaskAssigned((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)updated))));
        }
    }

    @AsyncSubscribe
    public void onTaskStarted(TaskStartedEvent event) {
        this.notifyManualTaskStarted(event.task());
    }

    @AsyncSubscribe
    public void onTaskRetried(TaskRetriedEvent event) {
        this.notifyManualTaskStarted(event.task());
    }

    @AsyncSubscribe
    public void onTaskFailed(TaskFailedEvent event) {
        block0: {
            if (event.task().isTaskGroup()) break block0;
            this.notificationService.notify(new TaskFailed((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)event.task()))));
        }
    }

    @AsyncSubscribe
    public void onTaskWaitingForInput(TaskWaitingForInputEvent event) {
        this.notificationService.notify(new TaskWaitingForInput((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)event.task()))));
    }

    @AsyncSubscribe
    public void onTaskOverdue(TaskOverdueEvent event) {
        block0: {
            Task task = event.task();
            Option dueDate = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(task.getOrCalculateDueDate()));
            if (!task.isInProgress() || !task.hasStartDate() || !dueDate.exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.after(task.getStartDate())))) break block0;
            this.notificationService.notify(new TaskOverdue((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)task))));
        }
    }

    @AsyncSubscribe
    public void onTaskDueSoon(TaskDueSoonEvent event) {
        this.notificationService.notify(new TaskDueSoon((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)event.task()))));
    }

    private void notifyManualTaskStarted(Task task) {
        block2: {
            if (task.isAutomated() || task.isTaskGroup()) break block2;
            if (Option$.MODULE$.apply((Object)task.getOwner()).isEmpty() && Option$.MODULE$.apply((Object)task.getTeam()).isEmpty() && package$.MODULE$.TaskWithNotificationFields(task).sendNotificationWhenStarted()) {
                this.notificationService.notify(new ManualTaskStartedWithoutAssignee((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)task))));
            } else {
                this.notificationService.notify(new ManualTaskStarted((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)task))));
            }
        }
    }

    private static final boolean isOwnerOrTeamUnassigned$1(Option originalOwner$1, Option updatedOwner$1, Option originalTeam$1, Option updatedTeam$1) {
        return originalOwner$1.isDefined() && updatedOwner$1.isEmpty() || originalTeam$1.isDefined() && updatedTeam$1.isEmpty();
    }

    private static final boolean isOwnerUpdated$1(Option originalOwner$1, Option updatedOwner$1) {
        Option option = originalOwner$1;
        Option option2 = updatedOwner$1;
        return option == null ? option2 != null : !option.equals(option2);
    }

    private static final boolean isTeamUpdated$1(Option originalTeam$1, Option updatedTeam$1) {
        Option option = originalTeam$1;
        Option option2 = updatedTeam$1;
        return option == null ? option2 != null : !option.equals(option2);
    }

    @Autowired
    public TaskNotificationEventHandler(NotificationService notificationService) {
        this.notificationService = notificationService;
    }
}

