/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.email;

import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.notifications.configuration.trigger.RecipientSettings;
import com.xebialabs.xlrelease.notifications.package$;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.PrincipalInfoResolver;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.service.UserProfileService;
import com.xebialabs.xlrelease.user.User;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001\u0002\b\u0010\u0001iA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tU\u0001\u0011\t\u0011)A\u0005W!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007\u0003\u00056\u0001\t\u0005\t\u0015!\u00037\u0011\u0015I\u0004\u0001\"\u0001;\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u001da\b!%A\u0005\u0002uDq!a\u0004\u0001\t\u0013\t\t\u0002C\u0004\u0002$\u0001!I!!\n\t\u000f\u0005U\u0002\u0001\"\u0003\u00028!9\u0011q\t\u0001\u0005\n\u0005%\u0003bBA+\u0001\u0011%\u0011q\u000b\u0005\b\u0003;\u0002A\u0011BA0\u0005Y)U.Y5m%\u0016\u001c\u0017\u000e]5f]R\u0014Vm]8mm\u0016\u0014(B\u0001\t\u0012\u0003\u0015)W.Y5m\u0015\t\u00112#A\u0007o_RLg-[2bi&|gn\u001d\u0006\u0003)U\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005Y9\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005A\u0012aA2p[\u000e\u00011C\u0001\u0001\u001c!\tar$D\u0001\u001e\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0005\u0019\te.\u001f*fM\u0006Y!o\u001c7f'\u0016\u0014h/[2f!\t\u0019\u0003&D\u0001%\u0015\t)c%\u0001\u0005tK\u000e,(/\u001b;z\u0015\t9S#\u0001\u0005eKBdw._5u\u0013\tICEA\u0006S_2,7+\u001a:wS\u000e,\u0017a\u0003;fC6\u001cVM\u001d<jG\u0016\u0004\"\u0001L\u0018\u000e\u00035R!AL\n\u0002\u000fM,'O^5dK&\u0011\u0001'\f\u0002\f)\u0016\fWnU3sm&\u001cW-\u0001\nvg\u0016\u0014\bK]8gS2,7+\u001a:wS\u000e,\u0007C\u0001\u00174\u0013\t!TF\u0001\nVg\u0016\u0014\bK]8gS2,7+\u001a:wS\u000e,\u0017!\u00069sS:\u001c\u0017\u000e]1m\u0013:4wNU3t_24XM\u001d\t\u0003Y]J!\u0001O\u0017\u0003+A\u0013\u0018N\\2ja\u0006d\u0017J\u001c4p%\u0016\u001cx\u000e\u001c<fe\u00061A(\u001b8jiz\"RaO\u001f?\u007f\u0001\u0003\"\u0001\u0010\u0001\u000e\u0003=AQ!I\u0003A\u0002\tBQAK\u0003A\u0002-BQ!M\u0003A\u0002IBQ!N\u0003A\u0002YB#!\u0002\"\u0011\u0005\rsU\"\u0001#\u000b\u0005\u00153\u0015AC1o]>$\u0018\r^5p]*\u0011q\tS\u0001\bM\u0006\u001cGo\u001c:z\u0015\tI%*A\u0003cK\u0006t7O\u0003\u0002L\u0019\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001N\u0003\ry'oZ\u0005\u0003\u001f\u0012\u0013\u0011\"Q;u_^L'/\u001a3\u0002#I,7o\u001c7wKJ+7-\u001b9jK:$8\u000f\u0006\u0004SA.lwn\u001e\t\u0004'jkfB\u0001+Y!\t)V$D\u0001W\u0015\t9\u0016$\u0001\u0004=e>|GOP\u0005\u00033v\ta\u0001\u0015:fI\u00164\u0017BA.]\u0005\r\u0019V\r\u001e\u0006\u00033v\u0001\"a\u00150\n\u0005}c&AB*ue&tw\rC\u0003b\r\u0001\u0007!-A\u0003s_2,7\u000fE\u0002dQvs!\u0001\u001a4\u000f\u0005U+\u0017\"\u0001\u0010\n\u0005\u001dl\u0012a\u00029bG.\fw-Z\u0005\u0003S*\u0014A\u0001T5ti*\u0011q-\b\u0005\u0006Y\u001a\u0001\rAY\u0001\fO2|'-\u00197S_2,7\u000fC\u0003o\r\u0001\u0007!-A\u0003vg\u0016\u00148\u000fC\u0003q\r\u0001\u0007\u0011/\u0001\u0005qY\u0006t\u0017\n^3n!\t\u0011X/D\u0001t\u0015\t!8#\u0001\u0004e_6\f\u0017N\\\u0005\u0003mN\u0014\u0001\u0002\u00157b]&#X-\u001c\u0005\bq\u001a\u0001\n\u00111\u0001z\u00035)\u0007p\u00197vI\u0016\fU\u000f\u001e5peB\u0011AD_\u0005\u0003wv\u0011qAQ8pY\u0016\fg.A\u000esKN|GN^3SK\u000eL\u0007/[3oiN$C-\u001a4bk2$H%N\u000b\u0002}*\u0012\u0011p`\u0016\u0003\u0003\u0003\u0001B!a\u0001\u0002\f5\u0011\u0011Q\u0001\u0006\u0005\u0003\u000f\tI!A\u0005v]\u000eDWmY6fI*\u0011Q)H\u0005\u0005\u0003\u001b\t)AA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!\u0002]1sg\u0016\u0014v\u000e\\3t)\u001d\u0011\u00161CA\u0010\u0003CAq!!\u0006\t\u0001\u0004\t9\"A\u0006bgNLwM\\7f]R\u001c\b\u0003B2i\u00033\u00012aIA\u000e\u0013\r\ti\u0002\n\u0002\u0005%>dW\rC\u0003b\u0011\u0001\u0007!\rC\u0003q\u0011\u0001\u0007\u0011/\u0001\bqCJ\u001cX\rV1tWJ{G.Z:\u0015\u000fI\u000b9#!\r\u00024!9\u0011\u0011F\u0005A\u0002\u0005-\u0012\u0001\u0002;bg.\u00042A]A\u0017\u0013\r\tyc\u001d\u0002\u0005)\u0006\u001c8\u000eC\u0003b\u0013\u0001\u0007!\rC\u0004\u0002\u0016%\u0001\r!a\u0006\u0002#A\f'o]3SK2,\u0017m]3S_2,7\u000fF\u0004S\u0003s\t\u0019%!\u0012\t\u000f\u0005m\"\u00021\u0001\u0002>\u00059!/\u001a7fCN,\u0007c\u0001:\u0002@%\u0019\u0011\u0011I:\u0003\u000fI+G.Z1tK\")\u0011M\u0003a\u0001E\"9\u0011Q\u0003\u0006A\u0002\u0005]\u0011!E4fiJ+G.Z1tK6+WNY3sgR1\u00111JA)\u0003'\u0002B\u0001HA'%&\u0019\u0011qJ\u000f\u0003\r=\u0003H/[8o\u0011\u001d\tYd\u0003a\u0001\u0003{Aq!!\u0006\f\u0001\u0004\t9\"\u0001\tqCJ\u001cXm\u00127pE\u0006d'k\u001c7fgR)!-!\u0017\u0002\\!9\u0011Q\u0003\u0007A\u0002\u0005]\u0001\"\u00027\r\u0001\u0004\u0011\u0017!D4fi\u0006cG.T3nE\u0016\u00148\u000fF\u0003S\u0003C\nY\u0007C\u0004\u0002d5\u0001\r!!\u001a\u0002\tQ,\u0017-\u001c\t\u0004e\u0006\u001d\u0014bAA5g\n!A+Z1n\u0011\u001d\t)\"\u0004a\u0001\u0003/A3\u0001AA8!\u0011\t\t(a\u001e\u000e\u0005\u0005M$bAA;\u0015\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005e\u00141\u000f\u0002\b'\u0016\u0014h/[2f\u0001")
public class EmailRecipientResolver {
    private final RoleService roleService;
    private final TeamService teamService;
    private final UserProfileService userProfileService;
    private final PrincipalInfoResolver principalInfoResolver;

    public Set<String> resolveRecipients(List<String> roles, List<String> globalRoles, List<String> users, PlanItem planItem, boolean excludeAuthor) {
        List assignments = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService.readRoleAssignments()).asScala()).toList();
        Set allPrincipals = (Set)this.parseRoles((List<Role>)assignments, roles, planItem).$plus$plus(this.parseGlobalRoles((List<Role>)assignments, globalRoles)).$plus$plus(users).$minus$minus((GenTraversableOnce)(excludeAuthor ? Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{User.AUTHENTICATED_USER.getName()})) : Nil$.MODULE$));
        return (Set)((TraversableLike)allPrincipals.map((Function1 & Serializable & scala.Serializable)x$1 -> $this.principalInfoResolver.getNotificationEmailOf(x$1), Set$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$resolveRecipients$2(x$1)));
    }

    public boolean resolveRecipients$default$5() {
        return false;
    }

    private Set<String> parseRoles(List<Role> assignments, List<String> roles, PlanItem planItem) {
        Set<String> set;
        PlanItem planItem2 = planItem;
        if (planItem2 instanceof Task) {
            Task task = (Task)planItem2;
            set = this.parseTaskRoles(task, roles, assignments);
        } else if (planItem2 instanceof Release) {
            Release release = (Release)planItem2;
            set = this.parseReleaseRoles(release, roles, assignments);
        } else {
            throw new MatchError((Object)planItem2);
        }
        return set;
    }

    private Set<String> parseTaskRoles(Task task, List<String> roles, List<Role> assignments) {
        ObjectRef parsed;
        block3: {
            parsed = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
            boolean shouldSendToTaskOwner = roles.contains((Object)"Task Owner");
            Option taskOwner = Option$.MODULE$.apply((Object)task.getOwner());
            if (shouldSendToTaskOwner && taskOwner.isDefined()) {
                parsed.elem = (Set)((Set)parsed.elem).$plus(taskOwner.get());
            }
            if (roles.contains((Object)"Task Team") || shouldSendToTaskOwner && taskOwner.isEmpty()) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.teamService.findTeamByName(Ids.releaseIdFrom((String)task.getId()), task.getTeam()))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    parsed.elem = (Set)((Set)parsed.elem).$plus$plus(this.getAllMembers(x$3, (List<Role>)assignments));
                    return BoxedUnit.UNIT;
                });
            }
            if (roles.contains((Object)RecipientSettings.RELEASE_ADMIN_ROLE_NAME)) {
                parsed.elem = (Set)((Set)parsed.elem).$plus$plus((GenTraversableOnce)this.getReleaseMembers(task.getRelease(), assignments).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
            }
            if (!roles.contains((Object)"Watcher")) break block3;
            Set<String> watchers = package$.MODULE$.TaskWithNotificationFields(task).getWatchers();
            watchers.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                parsed.elem = (Set)((Set)parsed.elem).$plus((Object)x$4);
                return BoxedUnit.UNIT;
            });
        }
        return (Set)parsed.elem;
    }

    private Set<String> parseReleaseRoles(Release release, List<String> roles, List<Role> assignments) {
        Set parsed;
        block0: {
            parsed = Predef$.MODULE$.Set().empty();
            if (!roles.contains((Object)RecipientSettings.RELEASE_ADMIN_ROLE_NAME)) break block0;
            parsed = (Set)parsed.$plus$plus((GenTraversableOnce)this.getReleaseMembers(release, assignments).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
        }
        return parsed;
    }

    private Option<Set<String>> getReleaseMembers(Release release, List<Role> assignments) {
        Option effectiveTeams = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.teamService.getEffectiveTeams(release)).asScala()).find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$getReleaseMembers$1(x$5)));
        return effectiveTeams.map((Function1 & Serializable & scala.Serializable)x$6 -> this.getAllMembers((Team)x$6, assignments));
    }

    private List<String> parseGlobalRoles(List<Role> assignments, List<String> globalRoles) {
        List<String> list = globalRoles;
        Object object = Nil$.MODULE$.equals(list) ? Nil$.MODULE$ : (List)((List)assignments.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)globalRoles.contains((Object)r.getName())))).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(x$7.getPrincipals()).asScala()).toList(), List$.MODULE$.canBuildFrom());
        return object;
    }

    private Set<String> getAllMembers(Team team, List<Role> assignments) {
        Set teamMembers = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(team.getMembers()).asScala()).toSet();
        List roleMembers = (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(team.getRoles()).asScala()).toList().flatMap((Function1 & Serializable & scala.Serializable)roleName -> (List)assignments.find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$getAllMembers$2(roleName, x$8))).toList().flatMap((Function1 & Serializable & scala.Serializable)role -> (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(role.getPrincipals()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)principal -> {
            $this.userProfileService.discover(principal);
            return principal;
        }, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
        return (Set)teamMembers.$plus$plus((GenTraversableOnce)roleMembers);
    }

    public static final /* synthetic */ boolean $anonfun$resolveRecipients$3(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2.trim())).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$resolveRecipients$2(String x$1) {
        return Option$.MODULE$.apply((Object)x$1).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$resolveRecipients$3(x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$getReleaseMembers$1(Team x$5) {
        String string = x$5.getTeamName();
        String string2 = "Release Admin";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getAllMembers$2(String roleName$1, Role x$8) {
        String string = x$8.getName();
        String string2 = roleName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Autowired
    public EmailRecipientResolver(RoleService roleService, TeamService teamService, UserProfileService userProfileService, PrincipalInfoResolver principalInfoResolver) {
        this.roleService = roleService;
        this.teamService = teamService;
        this.userProfileService = userProfileService;
        this.principalInfoResolver = principalInfoResolver;
    }
}

