/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.email;

import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.notifications.CommentAdded;
import com.xebialabs.xlrelease.notifications.NotificationStrategy;
import com.xebialabs.xlrelease.notifications.NotificationTrigger;
import com.xebialabs.xlrelease.notifications.ReleaseNotificationTrigger;
import com.xebialabs.xlrelease.notifications.TaskNotificationTrigger;
import com.xebialabs.xlrelease.notifications.TriggerType$;
import com.xebialabs.xlrelease.notifications.configuration.EmailNotificationSettings;
import com.xebialabs.xlrelease.notifications.configuration.trigger.NotificationTriggerSettings;
import com.xebialabs.xlrelease.notifications.configuration.trigger.RecipientSettings;
import com.xebialabs.xlrelease.notifications.email.ContextHelper;
import com.xebialabs.xlrelease.notifications.email.Email;
import com.xebialabs.xlrelease.notifications.email.EmailRecipientResolver;
import com.xebialabs.xlrelease.notifications.email.EmailSender;
import com.xebialabs.xlrelease.notifications.email.templates.Templater$;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001B\u0001\u0003\u00015\u0011!#R7bS2tu\u000e^5gS\u000e\fG/[8og*\u00111\u0001B\u0001\u0006K6\f\u0017\u000e\u001c\u0006\u0003\u000b\u0019\tQB\\8uS\u001aL7-\u0019;j_:\u001c(BA\u0004\t\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\n\u0015\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002\u0017\u0005\u00191m\\7\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0005\u0013\t9BA\u0001\u000bO_RLg-[2bi&|gn\u0015;sCR,w-\u001f\u0005\t3\u0001\u0011\t\u0011)A\u00055\u000592m\u001c8gS\u001e,(/\u0019;j_:\u0014V\r]8tSR|'/\u001f\t\u00037yi\u0011\u0001\b\u0006\u0003;\u0019\t!B]3q_NLGo\u001c:z\u0013\tyBDA\fD_:4\u0017nZ;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ss\"A\u0011\u0005\u0001B\u0001B\u0003%!%A\u0007d_:$X\r\u001f;IK2\u0004XM\u001d\t\u0003G\u0011j\u0011AA\u0005\u0003K\t\u0011QbQ8oi\u0016DH\u000fS3ma\u0016\u0014\b\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\u0002-\u0015l\u0017-\u001b7SK\u000eL\u0007/[3oiJ+7o\u001c7wKJ\u0004\"aI\u0015\n\u0005)\u0012!AF#nC&d'+Z2ja&,g\u000e\u001e*fg>dg/\u001a:\t\u00111\u0002!\u0011!Q\u0001\n5\n1\"Z7bS2\u001cVM\u001c3feB\u00111EL\u0005\u0003_\t\u00111\"R7bS2\u001cVM\u001c3fe\")\u0011\u0007\u0001C\u0001e\u00051A(\u001b8jiz\"Ra\r\u001b6m]\u0002\"a\t\u0001\t\u000be\u0001\u0004\u0019\u0001\u000e\t\u000b\u0005\u0002\u0004\u0019\u0001\u0012\t\u000b\u001d\u0002\u0004\u0019\u0001\u0015\t\u000b1\u0002\u0004\u0019A\u0017)\u0005AJ\u0004C\u0001\u001eF\u001b\u0005Y$B\u0001\u001f>\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003}}\nqAZ1di>\u0014\u0018P\u0003\u0002A\u0003\u0006)!-Z1og*\u0011!iQ\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tA)A\u0002pe\u001eL!AR\u001e\u0003\u0013\u0005+Ho\\<je\u0016$\u0007b\u0002%\u0001\u0005\u0004%\t!S\u0001\u0018\u000bb\u001bE*\u0016#F?\u0006+F\u000bS(S?R\u0013\u0016jR$F%N+\u0012A\u0013\t\u0004\u0017J+fB\u0001'Q!\ti\u0005#D\u0001O\u0015\tyE\"\u0001\u0004=e>|GOP\u0005\u0003#B\ta\u0001\u0015:fI\u00164\u0017BA*U\u0005\r\u0019V\r\u001e\u0006\u0003#B\u0001\"AV1\u000f\u0005]{fB\u0001-_\u001d\tIVL\u0004\u0002[9:\u0011QjW\u0005\u0002\u0017%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005\u0001$\u0011a\u0003+sS\u001e<WM\u001d+za\u0016L!AY2\u0003\u0017Q\u0013\u0018nZ4feRK\b/\u001a\u0006\u0003A\u0012Aa!\u001a\u0001!\u0002\u0013Q\u0015\u0001G#Y\u00072+F)R0B+RCuJU0U%&;u)\u0012*TA!)q\r\u0001C\u0001Q\u0006Yq-\u001a;TKR$\u0018N\\4t+\u0005I\u0007C\u00016n\u001b\u0005Y'B\u00017\u0005\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&\u0011an\u001b\u0002\u001a\u000b6\f\u0017\u000e\u001c(pi&4\u0017nY1uS>t7+\u001a;uS:<7\u000fC\u0003q\u0001\u0011\u0005\u0011/\u0001\bva\u0012\fG/Z*fiRLgnZ:\u0015\u0005%\u0014\b\"B:p\u0001\u0004I\u0017\u0001C:fiRLgnZ:\t\u000bU\u0004A\u0011\u0001<\u0002\r9|G/\u001b4z)\t9(\u0010\u0005\u0002\u0010q&\u0011\u0011\u0010\u0005\u0002\u0005+:LG\u000fC\u0003|i\u0002\u0007A0A\no_RLg-[2bi&|g\u000e\u0016:jO\u001e,'\u000f\u0005\u0002\u0016{&\u0011a\u0010\u0002\u0002\u0014\u001d>$\u0018NZ5dCRLwN\u001c+sS\u001e<WM\u001d\u0005\t\u0003\u0003\u0001A\u0011\u0001\u0002\u0002\u0004\u00059\"/\u001a<feN,\u0017\n^3n)>\u0014VmY5qS\u0016tGo]\u000b\u0005\u0003\u000b\ty\u0003\u0006\u0003\u0002\b\u0005\u0005\u0003cB&\u0002\n\u00055\u00111D\u0005\u0004\u0003\u0017!&aA'baB!\u0011qBA\u000b\u001d\r\u0019\u0013\u0011C\u0005\u0004\u0003'\u0011\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003/\tIB\u0001\u0006SK\u000eL\u0007/[3oiNT1!a\u0005\u0003!\u0019\ti\"!\n\u0002,9!\u0011qDA\u0012\u001d\ri\u0015\u0011E\u0005\u0002#%\u0019\u00111\u0003\t\n\t\u0005\u001d\u0012\u0011\u0006\u0002\u0005\u0019&\u001cHOC\u0002\u0002\u0014A\u0001B!!\f\u000201\u0001AaBA\u0019\u007f\n\u0007\u00111\u0007\u0002\u0002\u0003F!\u0011QGA\u001e!\ry\u0011qG\u0005\u0004\u0003s\u0001\"a\u0002(pi\"Lgn\u001a\t\u0004\u001f\u0005u\u0012bAA !\t\u0019\u0011I\\=\t\u000f\u0005\rs\u00101\u0001\u0002F\u0005\u0019\u0012\u000e^3n)>\u0014VmY5qS\u0016tGo]*fiB1\u0011QDA\u0013\u0003\u000f\u0002raDA%\u0003W\ti!C\u0002\u0002LA\u0011a\u0001V;qY\u0016\u0014\u0004bBA(\u0001\u0011%\u0011\u0011K\u0001\u0012e\u0016\u001cx\u000e\u001c<f%\u0016\u001c\u0017\u000e]5f]R\u001cHCBA*\u0003K\n)\b\u0006\u0003\u0002\u000e\u0005U\u0003\u0002CA,\u0003\u001b\u0002\r!!\u0017\u0002\u0011Ad\u0017M\\%uK6\u0004B!a\u0017\u0002b5\u0011\u0011Q\f\u0006\u0004\u0003?2\u0011A\u00023p[\u0006Lg.\u0003\u0003\u0002d\u0005u#\u0001\u0003)mC:LE/Z7\t\u0011\u0005\u001d\u0014Q\na\u0001\u0003S\n\u0011C]3dSBLWM\u001c;TKR$\u0018N\\4t!\u0011\tY'!\u001d\u000e\u0005\u00055$bAA8W\u00069AO]5hO\u0016\u0014\u0018\u0002BA:\u0003[\u0012\u0011CU3dSBLWM\u001c;TKR$\u0018N\\4t\u0011\u001d\t9(!\u0014A\u0002U\u000b1\u0002\u001e:jO\u001e,'\u000fV=qK\"\u001a\u0001!a\u001f\u0011\t\u0005u\u00141Q\u0007\u0003\u0003\u007fR1!!!B\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003\u000b\u000byHA\u0004TKJ4\u0018nY3")
public class EmailNotifications
implements NotificationStrategy {
    private final ConfigurationRepository configurationRepository;
    private final ContextHelper contextHelper;
    private final EmailRecipientResolver emailRecipientResolver;
    private final EmailSender emailSender;
    private final scala.collection.immutable.Set<Enumeration.Value> EXCLUDE_AUTHOR_TRIGGERS;

    public scala.collection.immutable.Set<Enumeration.Value> EXCLUDE_AUTHOR_TRIGGERS() {
        return this.EXCLUDE_AUTHOR_TRIGGERS;
    }

    public EmailNotificationSettings getSettings() {
        return (EmailNotificationSettings)this.configurationRepository.read("Configuration/mail/EmailNotificationSettings");
    }

    public EmailNotificationSettings updateSettings(EmailNotificationSettings settings) {
        this.configurationRepository.createOrUpdate((BaseConfiguration)settings);
        return (EmailNotificationSettings)this.configurationRepository.read(settings.getId());
    }

    @Override
    public void notify(NotificationTrigger notificationTrigger) {
        Enumeration.Value triggerType = notificationTrigger.name();
        NotificationTriggerSettings settings = this.getSettings().getNotificationTriggerSettings(triggerType.toString());
        RecipientSettings recipientSettings = settings.getRecipientSettings();
        Function1 & Serializable & scala.Serializable resolver = (Function1 & Serializable & scala.Serializable)planItem -> this.resolveRecipients(recipientSettings, triggerType, (PlanItem)planItem);
        NotificationTrigger notificationTrigger2 = notificationTrigger;
        if (notificationTrigger2 instanceof ReleaseNotificationTrigger) {
            ReleaseNotificationTrigger releaseNotificationTrigger = (ReleaseNotificationTrigger)notificationTrigger2;
            this.sendMail$1(this.getRecipientsToItems$1(releaseNotificationTrigger.releases(), resolver), (Function1 & Serializable & scala.Serializable)releases -> $this.contextHelper.releasesContext((List<Release>)releases), triggerType, settings);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (notificationTrigger2 instanceof TaskNotificationTrigger) {
            TaskNotificationTrigger taskNotificationTrigger = (TaskNotificationTrigger)notificationTrigger2;
            this.sendMail$1(this.getRecipientsToItems$1(taskNotificationTrigger.tasks(), resolver), (Function1 & Serializable & scala.Serializable)tasks -> $this.contextHelper.tasksContext((List<Task>)tasks), triggerType, settings);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (notificationTrigger2 instanceof CommentAdded) {
            CommentAdded commentAdded = (CommentAdded)notificationTrigger2;
            List<Task> tasks2 = commentAdded.tasks();
            Comment comment = commentAdded.comment();
            this.sendMail$1(this.getRecipientsToItems$1(tasks2, resolver), (Function1 & Serializable & scala.Serializable)tasks -> $this.contextHelper.commentsContext(comment, (List<Task>)tasks), triggerType, settings);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public <A> scala.collection.immutable.Map<scala.collection.immutable.Set<String>, List<A>> reverseItemToRecipients(List<Tuple2<A, scala.collection.immutable.Set<String>>> itemToRecipientsSet) {
        return (scala.collection.immutable.Map)((TraversableLike)itemToRecipientsSet.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object item = tuple2._1();
            scala.collection.immutable.Set recipients = (scala.collection.immutable.Set)tuple2._2();
            scala.collection.immutable.Set set = (scala.collection.immutable.Set)recipients.map((Function1 & Serializable & scala.Serializable)x$3 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$3), item), Set$.MODULE$.canBuildFrom());
            return set;
        }, List$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$4 -> (String)x$4._1()).mapValues((Function1 & Serializable & scala.Serializable)x$5 -> (List)x$5.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6._2(), List$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$7 -> (List)x$7._2()).mapValues((Function1 & Serializable & scala.Serializable)v -> v.keys().toSet()).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.swap(), Map$.MODULE$.canBuildFrom());
    }

    private scala.collection.immutable.Set<String> resolveRecipients(RecipientSettings recipientSettings, Enumeration.Value triggerType, PlanItem planItem) {
        Tuple3 tuple3 = new Tuple3((Object)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(recipientSettings.getRoles()).asScala()).toList(), (Object)List$.MODULE$.empty(), (Object)List$.MODULE$.empty());
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        List roles = (List)tuple3._1();
        List globalRoles = (List)tuple3._2();
        List users = (List)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)roles, (Object)globalRoles, (Object)users);
        Tuple3 tuple33 = tuple32;
        List roles2 = (List)tuple33._1();
        List globalRoles2 = (List)tuple33._2();
        List users2 = (List)tuple33._3();
        return this.emailRecipientResolver.resolveRecipients((List<String>)roles2, (List<String>)globalRoles2, (List<String>)users2, planItem, this.EXCLUDE_AUTHOR_TRIGGERS().contains((Object)triggerType));
    }

    public static final /* synthetic */ boolean $anonfun$notify$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    private final void sendMail$1(scala.collection.immutable.Map recipientsToItems, Function1 contextGetter, Enumeration.Value triggerType$1, NotificationTriggerSettings settings$1) {
        recipientsToItems.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)EmailNotifications.$anonfun$notify$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            Tuple2 tuple2;
            scala.collection.immutable.Set recipients;
            Tuple2 tuple22 = x$2;
            if (tuple22 != null) {
                .colon.colon colon2;
                List list;
                recipients = (scala.collection.immutable.Set)tuple22._1();
                List items = (List)tuple22._2();
                Map context = (Map)contextGetter.apply((Object)items);
                List list2 = items;
                Tuple2 tuple23 = list2 instanceof .colon.colon && Nil$.MODULE$.equals(list = (colon2 = (.colon.colon)list2).tl$access$1()) ? new Tuple2((Object)Templater$.MODULE$.processString(settings$1.getTemplateSettings().getSubject(), context), (Object)Templater$.MODULE$.processTemplateForTriggerType(triggerType$1, context, settings$1.getTemplateSettings().getBody())) : new Tuple2((Object)Templater$.MODULE$.processString(settings$1.getBulkTemplateSettings().getSubject(), context), (Object)Templater$.MODULE$.processBulkTemplateForTriggerType(triggerType$1, context, settings$1.getBulkTemplateSettings().getBody()));
                Tuple2 tuple24 = tuple23;
                if (tuple24 == null) {
                    throw new MatchError((Object)tuple24);
                }
                String subject = (String)tuple24._1();
                String body = (String)tuple24._2();
                tuple2 = new Tuple2((Object)subject, (Object)body);
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple25 = tuple2;
            String subject = (String)tuple25._1();
            String body = (String)tuple25._2();
            CompletableFuture<Void> completableFuture = $this.emailSender.scheduleEmail(new Email((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)recipients).asJava(), subject, body).withPriority(settings$1.getPriority()));
            return completableFuture;
        });
    }

    private final scala.collection.immutable.Map getRecipientsToItems$1(List items, Function1 resolver$1) {
        return this.reverseItemToRecipients((List)items.map((Function1 & Serializable & scala.Serializable)item -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(item), resolver$1.apply(item)), List$.MODULE$.canBuildFrom()));
    }

    @Autowired
    public EmailNotifications(ConfigurationRepository configurationRepository, ContextHelper contextHelper, EmailRecipientResolver emailRecipientResolver, EmailSender emailSender) {
        this.configurationRepository = configurationRepository;
        this.contextHelper = contextHelper;
        this.emailRecipientResolver = emailRecipientResolver;
        this.emailSender = emailSender;
        this.EXCLUDE_AUTHOR_TRIGGERS = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TriggerType$.MODULE$.COMMENT_ADDED(), TriggerType$.MODULE$.RELEASE_FLAGGED(), TriggerType$.MODULE$.TASK_FLAGGED()}));
    }
}

