/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.email;

import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.notifications.configuration.trigger.RecipientSettings;
import com.xebialabs.xlrelease.notifications.package$;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Teams;
import com.xebialabs.xlrelease.service.UserInfoResolver;
import com.xebialabs.xlrelease.service.UserProfilesService;
import com.xebialabs.xlrelease.user.User;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\u0001\u0003\u00015\u0011a#R7bS2\u0014VmY5qS\u0016tGOU3t_24XM\u001d\u0006\u0003\u0007\u0011\tQ!Z7bS2T!!\u0002\u0004\u0002\u001b9|G/\u001b4jG\u0006$\u0018n\u001c8t\u0015\t9\u0001\"A\u0005yYJ,G.Z1tK*\u0011\u0011BC\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aC\u0001\u0004G>l7\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\u0017I|G.Z*feZL7-\u001a\t\u0003/qi\u0011\u0001\u0007\u0006\u00033i\t\u0001b]3dkJLG/\u001f\u0006\u00037!\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003;a\u00111BU8mKN+'O^5dK\"Aq\u0004\u0001B\u0001B\u0003%\u0001%A\u0003uK\u0006l7\u000f\u0005\u0002\"I5\t!E\u0003\u0002$\r\u0005Q!/\u001a9pg&$xN]=\n\u0005\u0015\u0012#!\u0002+fC6\u001c\b\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\u0002'U\u001cXM\u001d)s_\u001aLG.Z:TKJ4\u0018nY3\u0011\u0005%bS\"\u0001\u0016\u000b\u0005-2\u0011aB:feZL7-Z\u0005\u0003[)\u00121#V:feB\u0013xNZ5mKN\u001cVM\u001d<jG\u0016D\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001M\u0001\u0011kN,'/\u00138g_J+7o\u001c7wKJ\u0004\"!K\u0019\n\u0005IR#\u0001E+tKJLeNZ8SKN|GN^3s\u0011\u0015!\u0004\u0001\"\u00016\u0003\u0019a\u0014N\\5u}Q)a\u0007O\u001d;wA\u0011q\u0007A\u0007\u0002\u0005!)Qc\ra\u0001-!)qd\ra\u0001A!)qe\ra\u0001Q!)qf\ra\u0001a!\u00121'\u0010\t\u0003}%k\u0011a\u0010\u0006\u0003\u0001\u0006\u000b!\"\u00198o_R\fG/[8o\u0015\t\u00115)A\u0004gC\u000e$xN]=\u000b\u0005\u0011+\u0015!\u00022fC:\u001c(B\u0001$H\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001%\u0002\u0007=\u0014x-\u0003\u0002K\u007f\tI\u0011)\u001e;po&\u0014X\r\u001a\u0005\u0006\u0019\u0002!\t!T\u0001\u0012e\u0016\u001cx\u000e\u001c<f%\u0016\u001c\u0017\u000e]5f]R\u001cHC\u0002(]O&\\7\u000fE\u0002P-fs!\u0001\u0015+\u0011\u0005E\u0003R\"\u0001*\u000b\u0005Mc\u0011A\u0002\u001fs_>$h(\u0003\u0002V!\u00051\u0001K]3eK\u001aL!a\u0016-\u0003\u0007M+GO\u0003\u0002V!A\u0011qJW\u0005\u00037b\u0013aa\u0015;sS:<\u0007\"B/L\u0001\u0004q\u0016!\u0002:pY\u0016\u001c\bcA0e3:\u0011\u0001M\u0019\b\u0003#\u0006L\u0011!E\u0005\u0003GB\tq\u0001]1dW\u0006<W-\u0003\u0002fM\n!A*[:u\u0015\t\u0019\u0007\u0003C\u0003i\u0017\u0002\u0007a,A\u0006hY>\u0014\u0017\r\u001c*pY\u0016\u001c\b\"\u00026L\u0001\u0004q\u0016!B;tKJ\u001c\b\"\u00027L\u0001\u0004i\u0017\u0001\u00039mC:LE/Z7\u0011\u00059\fX\"A8\u000b\u0005A4\u0011A\u00023p[\u0006Lg.\u0003\u0002s_\nA\u0001\u000b\\1o\u0013R,W\u000eC\u0004u\u0017B\u0005\t\u0019A;\u0002\u001b\u0015D8\r\\;eK\u0006+H\u000f[8s!\tya/\u0003\u0002x!\t9!i\\8mK\u0006t\u0007\"B=\u0001\t\u0013Q\u0018A\u00039beN,'k\u001c7fgR1aj_A\u0002\u0003\u000bAQ\u0001 =A\u0002u\f1\"Y:tS\u001etW.\u001a8ugB\u0019q\f\u001a@\u0011\u0005]y\u0018bAA\u00011\t!!k\u001c7f\u0011\u0015i\u0006\u00101\u0001_\u0011\u0015a\u0007\u00101\u0001n\u0011\u001d\tI\u0001\u0001C\u0005\u0003\u0017\ta\u0002]1sg\u0016$\u0016m]6S_2,7\u000fF\u0004O\u0003\u001b\t9\"!\u0007\t\u0011\u0005=\u0011q\u0001a\u0001\u0003#\tA\u0001^1tWB\u0019a.a\u0005\n\u0007\u0005UqN\u0001\u0003UCN\\\u0007BB/\u0002\b\u0001\u0007a\f\u0003\u0004}\u0003\u000f\u0001\r! \u0005\b\u0003;\u0001A\u0011BA\u0010\u0003E\u0001\u0018M]:f%\u0016dW-Y:f%>dWm\u001d\u000b\b\u001d\u0006\u0005\u00121FA\u0017\u0011!\t\u0019#a\u0007A\u0002\u0005\u0015\u0012a\u0002:fY\u0016\f7/\u001a\t\u0004]\u0006\u001d\u0012bAA\u0015_\n9!+\u001a7fCN,\u0007BB/\u0002\u001c\u0001\u0007a\f\u0003\u0004}\u00037\u0001\r! \u0005\b\u0003c\u0001A\u0011BA\u001a\u0003E9W\r\u001e*fY\u0016\f7/Z'f[\n,'o\u001d\u000b\u0007\u0003k\tY$!\u0010\u0011\t=\t9DT\u0005\u0004\u0003s\u0001\"AB(qi&|g\u000e\u0003\u0005\u0002$\u0005=\u0002\u0019AA\u0013\u0011\u0019a\u0018q\u0006a\u0001{\"9\u0011\u0011\t\u0001\u0005\n\u0005\r\u0013\u0001\u00059beN,w\t\\8cC2\u0014v\u000e\\3t)\u0015q\u0016QIA$\u0011\u0019a\u0018q\ba\u0001{\"1\u0001.a\u0010A\u0002yCq!a\u0013\u0001\t\u0013\ti%A\u0007hKR\fE\u000e\\'f[\n,'o\u001d\u000b\u0006\u001d\u0006=\u0013\u0011\f\u0005\t\u0003#\nI\u00051\u0001\u0002T\u0005!A/Z1n!\rq\u0017QK\u0005\u0004\u0003/z'\u0001\u0002+fC6Da\u0001`A%\u0001\u0004i\b\"CA/\u0001E\u0005I\u0011AA0\u0003m\u0011Xm]8mm\u0016\u0014VmY5qS\u0016tGo\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011\u0011\r\u0016\u0004k\u0006\r4FAA3!\u0011\t9'a\u001c\u000e\u0005\u0005%$\u0002BA6\u0003[\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005\u0001\u0003\u0012\u0002BA9\u0003S\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2fQ\r\u0001\u0011Q\u000f\t\u0005\u0003o\ni(\u0004\u0002\u0002z)\u0019\u00111P#\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002\u0000\u0005e$aB*feZL7-\u001a")
public class EmailRecipientResolver {
    private final RoleService roleService;
    private final Teams teams;
    private final UserProfilesService userProfilesService;
    private final UserInfoResolver userInfoResolver;

    public Set<String> resolveRecipients(List<String> roles, List<String> globalRoles, List<String> users, PlanItem planItem, boolean excludeAuthor) {
        List assignments = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService.readRoleAssignments()).asScala()).toList();
        Set allUsers = (Set)this.parseRoles((List<Role>)assignments, roles, planItem).$plus$plus(this.parseGlobalRoles((List<Role>)assignments, globalRoles)).$plus$plus(users).$minus$minus((GenTraversableOnce)(excludeAuthor ? Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{User.AUTHENTICATED_USER.getName()})) : Nil$.MODULE$));
        return (Set)((TraversableLike)allUsers.map((Function1 & Serializable & scala.Serializable)x$1 -> $this.userInfoResolver.getNotificationEmailOf(x$1), Set$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$resolveRecipients$2(x$1)));
    }

    public boolean resolveRecipients$default$5() {
        return false;
    }

    private Set<String> parseRoles(List<Role> assignments, List<String> roles, PlanItem planItem) {
        Set<String> set;
        PlanItem planItem2 = planItem;
        if (planItem2 instanceof Task) {
            Task task = (Task)planItem2;
            set = this.parseTaskRoles(task, roles, assignments);
        } else if (planItem2 instanceof Release) {
            Release release = (Release)planItem2;
            set = this.parseReleaseRoles(release, roles, assignments);
        } else {
            throw new MatchError((Object)planItem2);
        }
        return set;
    }

    private Set<String> parseTaskRoles(Task task, List<String> roles, List<Role> assignments) {
        ObjectRef parsed;
        block3: {
            parsed = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
            boolean shouldSendToTaskOwner = roles.contains((Object)"Task Owner");
            Option taskOwner = Option$.MODULE$.apply((Object)task.getOwner());
            if (shouldSendToTaskOwner && taskOwner.isDefined()) {
                parsed.elem = (Set)((Set)parsed.elem).$plus(taskOwner.get());
            }
            if (roles.contains((Object)"Task Team") || shouldSendToTaskOwner && taskOwner.isEmpty()) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.teams.findTeamByName(Ids.releaseIdFrom((String)task.getId()), task.getTeam()))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    parsed.elem = (Set)((Set)parsed.elem).$plus$plus(this.getAllMembers(x$3, (List<Role>)assignments));
                    return BoxedUnit.UNIT;
                });
            }
            if (roles.contains((Object)RecipientSettings.RELEASE_ADMIN_ROLE_NAME)) {
                parsed.elem = (Set)((Set)parsed.elem).$plus$plus((GenTraversableOnce)this.getReleaseMembers(task.getRelease(), assignments).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
            }
            if (!roles.contains((Object)"Watcher")) break block3;
            Set<String> watchers = package$.MODULE$.TaskWithNotificationFields(task).getWatchers();
            watchers.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                parsed.elem = (Set)((Set)parsed.elem).$plus((Object)x$4);
                return BoxedUnit.UNIT;
            });
        }
        return (Set)parsed.elem;
    }

    private Set<String> parseReleaseRoles(Release release, List<String> roles, List<Role> assignments) {
        Set parsed;
        block0: {
            parsed = Predef$.MODULE$.Set().empty();
            if (!roles.contains((Object)RecipientSettings.RELEASE_ADMIN_ROLE_NAME)) break block0;
            parsed = (Set)parsed.$plus$plus((GenTraversableOnce)this.getReleaseMembers(release, assignments).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
        }
        return parsed;
    }

    private Option<Set<String>> getReleaseMembers(Release release, List<Role> assignments) {
        Option maybeTeam = Ids.isInFolder((String)release.getId()) ? ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.teams.getEffectiveTeams(release)).asScala()).find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$getReleaseMembers$1(x$5))) : Option$.MODULE$.apply((Object)release.getAdminTeam());
        return maybeTeam.map((Function1 & Serializable & scala.Serializable)x$6 -> this.getAllMembers((Team)x$6, assignments));
    }

    private List<String> parseGlobalRoles(List<Role> assignments, List<String> globalRoles) {
        List<String> list = globalRoles;
        Object object = Nil$.MODULE$.equals(list) ? Nil$.MODULE$ : (List)((List)assignments.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)globalRoles.contains((Object)r.getName())))).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(x$7.getPrincipals()).asScala()).toList(), List$.MODULE$.canBuildFrom());
        return object;
    }

    private Set<String> getAllMembers(Team team, List<Role> assignments) {
        Set teamMembers = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(team.getMembers()).asScala()).toSet();
        List roleMembers = (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(team.getRoles()).asScala()).toList().flatMap((Function1 & Serializable & scala.Serializable)roleName -> (List)assignments.find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$getAllMembers$2(roleName, x$8))).toList().flatMap((Function1 & Serializable & scala.Serializable)role -> (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(role.getPrincipals()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)principal -> {
            $this.userProfilesService.ensureCreated(principal);
            return principal;
        }, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
        return (Set)teamMembers.$plus$plus((GenTraversableOnce)roleMembers);
    }

    public static final /* synthetic */ boolean $anonfun$resolveRecipients$3(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2.trim())).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$resolveRecipients$2(String x$1) {
        return Option$.MODULE$.apply((Object)x$1).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$resolveRecipients$3(x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$getReleaseMembers$1(Team x$5) {
        String string = x$5.getTeamName();
        String string2 = "Release Admin";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getAllMembers$2(String roleName$1, Role x$8) {
        String string = x$8.getName();
        String string2 = roleName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Autowired
    public EmailRecipientResolver(RoleService roleService, Teams teams, UserProfilesService userProfilesService, UserInfoResolver userInfoResolver) {
        this.roleService = roleService;
        this.teams = teams;
        this.userProfilesService = userProfilesService;
        this.userInfoResolver = userInfoResolver;
    }
}

