package com.xebialabs.xlrelease.notifications.initialize

import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.notifications.TriggerType.{AUDIT_REPORT_JOB_COMPLETED, AUDIT_REPORT_JOB_FAILED}
import com.xebialabs.xlrelease.notifications.configuration.EmailNotificationSettings
import com.xebialabs.xlrelease.notifications.configuration.EmailNotificationSettings.GLOBAL_EMAIL_NOTIFICATION_SETTINGS_ID
import com.xebialabs.xlrelease.notifications.initialize.EmailNotificationSettingsInitializer.notificationTriggerSettings
import com.xebialabs.xlrelease.notifications.initialize.XLRelease900ReportJobEmailNotificationsUpgrade.reportJobNotificationTriggerSettings
import com.xebialabs.xlrelease.service.ConfigurationService
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.common.BaseInitializingUpgrade
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
class XLRelease900ReportJobEmailNotificationsUpgrade @Autowired()(configurationService: ConfigurationService)
  extends BaseInitializingUpgrade with Logging {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "9.0.0#5")

  override def doUpgrade(): Boolean = {
    val emailSettings = configurationService.read(GLOBAL_EMAIL_NOTIFICATION_SETTINGS_ID).asInstanceOf[EmailNotificationSettings]

    reportJobNotificationTriggerSettings.foreach { (notificationTriggerSettings) =>
      emailSettings.setNotificationTriggerSettings(notificationTriggerSettings)
    }

    logger.info("Adding email notification settings for report jobs")

    configurationService.createOrUpdate(emailSettings)

    true
  }
}

object XLRelease900ReportJobEmailNotificationsUpgrade {

  private val reportJobNotificationTriggerSettings = {
    List(
      notificationTriggerSettings(
        AUDIT_REPORT_JOB_COMPLETED,
        subject = "[XL Release] Report '${report.reportName}' is ready",
        body =
          """
            | **Your audit report is complete!**
            |
            | '${report.reportName}' is ready for download.
          """.stripMargin.trim),
      notificationTriggerSettings(
        AUDIT_REPORT_JOB_FAILED,
        subject = "[XL Release] Audit report has failed",
        body =
          """
            | **Your audit report has failed!**
            |
            | Please try to generate it again or contact your XL Release administrator for assistance.
          """.stripMargin.trim)
    )
  }

}



