package com.xebialabs.xlrelease.notifications.initialize

import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.notifications.TriggerType.USER_MENTIONED
import com.xebialabs.xlrelease.notifications.configuration.EmailNotificationSettings
import com.xebialabs.xlrelease.notifications.configuration.EmailNotificationSettings.GLOBAL_EMAIL_NOTIFICATION_SETTINGS_ID
import com.xebialabs.xlrelease.notifications.initialize.EmailNotificationSettingsInitializer.{PRODUCT_TAG, notificationTriggerSettings}
import com.xebialabs.xlrelease.service.ConfigurationService
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.common.BaseInitializingUpgrade
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
class XLRelease100MentionEmailNotificationsUpgrade @Autowired()(configurationService: ConfigurationService)
  extends BaseInitializingUpgrade with Logging {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "10.0.0#1")

  override def doUpgrade(): Boolean = {
    val emailSettings = configurationService.read(GLOBAL_EMAIL_NOTIFICATION_SETTINGS_ID).asInstanceOf[EmailNotificationSettings]

    emailSettings.setNotificationTriggerSettings(mentionNotificationSettings())

    logger.info("Adding email notification settings for user mentions")

    configurationService.createOrUpdate(emailSettings)

    true
  }

  private def mentionNotificationSettings() = {
    notificationTriggerSettings(
      USER_MENTIONED,
      subject = s"$PRODUCT_TAG $${mentionedByFullName} mentioned you on $${release.title}: $${task.title}",
      body =
        """
          |**${mentionedByFullName}** mentioned you on the **${task.title}** task in the **${release.title}** release:
          """.stripMargin.trim)
  }
}


