package com.xebialabs.xlrelease.notifications.email;

import java.util.Collection;
import java.util.Optional;

import com.xebialabs.xlrelease.domain.notification.MailPriority;

public class Email {
    Collection<String> recipients;
    String subject;
    String body;

    Optional<MailPriority> priority = Optional.ofNullable(null);
    Optional<String> from = Optional.ofNullable(null);
    Optional<String> senderUsername = Optional.ofNullable(null);
    Optional<String> senderPassword = Optional.ofNullable(null);
    Optional<String> replyTo = Optional.ofNullable(null);
    Optional<Collection<String>> cc = Optional.ofNullable(null);
    Optional<Collection<String>> bcc = Optional.ofNullable(null);

    public Email(final Collection<String> recipients, final String subject, final String body) {
        this.recipients = recipients;
        this.subject = subject;
        this.body = body;
    }

    public Collection<String> getRecipients() {
        return recipients;
    }

    public String getSubject() {
        return subject;
    }

    public String getBody() {
        return body;
    }

    public Optional<MailPriority> getPriority() {
        return priority;
    }

    public Email withPriority(final MailPriority priority) {
        this.priority = Optional.ofNullable(priority);
        return this;
    }

    public Optional<String> getFrom() {
        return from;
    }

    public Email withFrom(final String from) {
        this.from = Optional.ofNullable(from);
        return this;
    }

    public Optional<String> getSenderUsername() {
        return senderUsername;
    }

    public Email withSenderUsername(final String username) {
        this.senderUsername = Optional.ofNullable(username);
        return this;
    }

    public Optional<String> getSenderPassword() {
        return senderPassword;
    }

    public Email withSenderPassword(final String password) {
        this.senderPassword = Optional.ofNullable("".equals(password) ? null : password);
        return this;
    }

    public Optional<String> getReplyTo() {
        return replyTo;
    }

    public Email withReplyTo(final String replyTo) {
        this.replyTo = Optional.ofNullable(replyTo);
        return this;
    }

    public Optional<Collection<String>> getCc() {
        return cc;
    }

    public Email withCc(final Collection<String> cc) {
        this.cc = Optional.ofNullable(cc);
        return this;
    }

    public Optional<Collection<String>> getBcc() {
        return bcc;
    }

    public Email withBcc(final Collection<String> bcc) {
        this.bcc = Optional.ofNullable(bcc);
        return this;
    }
}
