package com.xebialabs.xlrelease.notifications.initialize

import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.notifications.TriggerType._
import com.xebialabs.xlrelease.notifications.configuration.EmailNotificationSettings
import com.xebialabs.xlrelease.notifications.configuration.EmailNotificationSettings.GLOBAL_EMAIL_NOTIFICATION_SETTINGS_ID
import com.xebialabs.xlrelease.notifications.configuration.trigger.TemplateSettings
import com.xebialabs.xlrelease.notifications.initialize.XLRelease720BulkOperationsEmailNotificationsUpgrade.releaseNotificationTriggerSettings
import com.xebialabs.xlrelease.service.ConfigurationService
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.common.BaseInitializingUpgrade
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
class XLRelease720BulkOperationsEmailNotificationsUpgrade @Autowired()(configurationService: ConfigurationService)
  extends BaseInitializingUpgrade with Logging {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "7.2.0#1")

  override def doUpgrade(): Boolean = {
    val emailSettings = configurationService.read(GLOBAL_EMAIL_NOTIFICATION_SETTINGS_ID).asInstanceOf[EmailNotificationSettings]

    releaseNotificationTriggerSettings.foreach { case (trigger, settings) =>
      val notificationTriggerSettings = emailSettings.getNotificationTriggerSettings(trigger)
      // Add bulk settings
      notificationTriggerSettings.setBulkTemplateSettings(settings)
      // Update value of notification settings
      emailSettings.setNotificationTriggerSettings(notificationTriggerSettings)
    }

    logger.info("Adding email notification settings for release bulk operations")

    configurationService.createOrUpdate(emailSettings)

    true
  }
}

object XLRelease720BulkOperationsEmailNotificationsUpgrade {

  private val releaseNotificationTriggerSettings = {
    List(
      createBulkTemplateForTrigger(
        RELEASE_STARTED,
        subject = "[XL Release] Multiple releases started",
        body =
          """
            |The following releases have been started:
            |
            |${#releases}
            |* [${title}](${url})
            |${/releases}
          """.stripMargin.trim
      ),
      createBulkTemplateForTrigger(
        RELEASE_ABORTED,
        subject = "[XL Release] Multiple releases aborted",
        body =
          """
            |The following releases have been aborted:
            |
            |${#releases}
            |* [${title}](${url})
            |${/releases}
          """.stripMargin.trim
      )
    )
  }

  private def createBulkTemplateForTrigger(triggerName: String, subject: String, body: String): (String, TemplateSettings) = {
    val bulkTemplateSettings = new TemplateSettings
    bulkTemplateSettings.setSubject(subject)
    bulkTemplateSettings.setBody(body)

    (triggerName, bulkTemplateSettings)
  }
}

