package com.xebialabs.xlrelease.notifications

import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

import java.util.{List => JList}

@Service
class NotificationService @Autowired()(notificationStrategies: JList[NotificationStrategy]) {

  def notify(notification: NotificationTrigger): Unit = {
    notificationStrategies.forEach(_.notify(notification))
  }
}

trait NotificationStrategy {
  def notify(notification: NotificationTrigger): Unit
}
