package com.xebialabs.xlrelease.notifications.initialize

import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.notifications.TriggerType.AUDIT_REPORT_JOB_ABORTED
import com.xebialabs.xlrelease.notifications.configuration.EmailNotificationSettings
import com.xebialabs.xlrelease.notifications.configuration.EmailNotificationSettings.GLOBAL_EMAIL_NOTIFICATION_SETTINGS_ID
import com.xebialabs.xlrelease.notifications.initialize.EmailNotificationSettingsInitializer.notificationTriggerSettings
import com.xebialabs.xlrelease.notifications.initialize.XLRelease950ReportJobEmailNotificationsUpgrade._
import com.xebialabs.xlrelease.service.ConfigurationService
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.common.BaseInitializingUpgrade
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
class XLRelease950ReportJobEmailNotificationsUpgrade @Autowired()(configurationService: ConfigurationService)
  extends BaseInitializingUpgrade with Logging {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "9.5.0#5")

  override def doUpgrade(): Boolean = {
    val emailSettings = configurationService.read(GLOBAL_EMAIL_NOTIFICATION_SETTINGS_ID).asInstanceOf[EmailNotificationSettings]

    reportJobNotificationTriggerSettings.foreach(emailSettings.setNotificationTriggerSettings)

    logger.info("Adding email notification settings for aborted report jobs")

    configurationService.createOrUpdate(emailSettings)

    true
  }
}

object XLRelease950ReportJobEmailNotificationsUpgrade {

  private val reportJobNotificationTriggerSettings = {
    List(
      notificationTriggerSettings(
        AUDIT_REPORT_JOB_ABORTED,
        subject = "[XL Release] Audit report was aborted",
        body =
          """
            | **Your audit report was aborted!**
            |
            | Please try to generate it again or contact your XL Release administrator for assistance.
          """.stripMargin.trim)
    )
  }

}
