/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.configuration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.notification.MailPriority;
import com.xebialabs.xlrelease.notifications.configuration.trigger.NotificationTriggerSettings;
import com.xebialabs.xlrelease.notifications.configuration.trigger.RecipientSettings;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Metadata(root=Metadata.ConfigurationItemRoot.CONFIGURATION, versioned=false)
public class EmailNotificationSettings
extends BaseConfiguration {
    public static final String GLOBAL_EMAIL_NOTIFICATION_SETTINGS_ID = "Configuration/mail/EmailNotificationSettings";
    @Property(label="Cardinality", defaultValue="1", hidden=true)
    private Integer cardinality;
    @Property(description="Contains information about settings for the raised event")
    private Map<String, String> notificationTriggerSettings = new HashMap<String, String>();

    public Integer getCardinality() {
        return this.cardinality;
    }

    public boolean hasNotificationTriggerSettings(String notificationTriggerName) {
        return this.notificationTriggerSettings.containsKey(notificationTriggerName);
    }

    @VisibleForTesting
    public void removeNotificationTriggerSettings(String notificationTriggerName) {
        this.notificationTriggerSettings.remove(notificationTriggerName);
    }

    public NotificationTriggerSettings getNotificationTriggerSettings(String notificationTriggerName) {
        ObjectMapper objectMapper = EmailNotificationSettings.newObjectMapper();
        String settingsJson = this.notificationTriggerSettings.get(notificationTriggerName);
        return EmailNotificationSettings.readJsonToNotificationTriggerSettings(objectMapper, settingsJson);
    }

    public List<NotificationTriggerSettings> getNotificationTriggerSettings() {
        ObjectMapper objectMapper = EmailNotificationSettings.newObjectMapper();
        return this.notificationTriggerSettings.values().stream().map(settingsJson -> EmailNotificationSettings.readJsonToNotificationTriggerSettings(objectMapper, settingsJson)).collect(Collectors.toList());
    }

    public void setNotificationTriggerSettings(List<NotificationTriggerSettings> notificationTriggerSettings) {
        ObjectMapper objectMapper = EmailNotificationSettings.newObjectMapper();
        this.notificationTriggerSettings = (Map)notificationTriggerSettings.stream().collect(com.xebialabs.xlrelease.utils.Collectors.toMap(NotificationTriggerSettings::getNotificationTriggerName, settings -> {
            try {
                return objectMapper.writeValueAsString(settings);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Serialization failed for NotificationTriggerSettings with name " + settings.getNotificationTriggerName(), e);
            }
        }));
    }

    public void setNotificationTriggerSettings(NotificationTriggerSettings notificationTriggerSettings) {
        try {
            this.notificationTriggerSettings.put(notificationTriggerSettings.getNotificationTriggerName(), EmailNotificationSettings.newObjectMapper().writeValueAsString((Object)notificationTriggerSettings));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Serialization failed for NotificationTriggerSettings with name " + notificationTriggerSettings.getNotificationTriggerName(), e);
        }
    }

    private static ObjectMapper newObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
        return objectMapper;
    }

    private static NotificationTriggerSettings readJsonToNotificationTriggerSettings(ObjectMapper objectMapper, String settingsJson) {
        NotificationTriggerSettings settings;
        try {
            settings = (NotificationTriggerSettings)objectMapper.readValue(settingsJson, NotificationTriggerSettings.class);
        }
        catch (IOException | IllegalArgumentException | NullPointerException e) {
            throw new IllegalStateException("Deserialization failed for NotificationTriggerSettings with JSON: " + settingsJson, e);
        }
        if (settings != null) {
            if (settings.getPriority() == null) {
                settings.setPriority(MailPriority.Normal);
            }
            if (settings.getRecipientSettings() == null) {
                settings.setRecipientSettings(new RecipientSettings());
            }
        }
        return settings;
    }
}

