package com.xebialabs.xlrelease.notifications.handlers

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.BaseConfiguration
import com.xebialabs.xlrelease.domain.events.{ConfigurationCreatedEvent, ConfigurationDeletedEvent, ConfigurationUpdatedEvent}
import com.xebialabs.xlrelease.events.{EventListener, Subscribe, XLReleaseEventListener}
import com.xebialabs.xlrelease.notifications.configuration.EmailNotificationSettings
import com.xebialabs.xlrelease.service.CacheManagementService
import com.xebialabs.xlrelease.service.CacheManagementService.CACHE_GROUP_NOTIFICATION_SETTINGS
import org.springframework.stereotype.Service

@Service
@EventListener
class EmailNotificationSettingsEventHandler(cacheManagementService: CacheManagementService)
  extends XLReleaseEventListener {

  private def isEmailSettingsType(conf: BaseConfiguration): Boolean = conf.getType.instanceOf(Type.valueOf(classOf[EmailNotificationSettings]))

  @Subscribe
  def onConfigurationCreated(event: ConfigurationCreatedEvent): Unit = {
    cleanEmailSettingsCache(event.conf)
  }

  @Subscribe
  def onConfigurationUpdated(event: ConfigurationUpdatedEvent): Unit = {
    cleanEmailSettingsCache(event.updated)
  }

  @Subscribe
  def onConfigurationDeleted(event: ConfigurationDeletedEvent): Unit = {
    cleanEmailSettingsCache(event.conf)
  }

  private def cleanEmailSettingsCache(conf: BaseConfiguration): Unit = {
    if (isEmailSettingsType(conf)) {
      cacheManagementService.clearCacheGroup(cacheGroup = CACHE_GROUP_NOTIFICATION_SETTINGS, broadcast = true)
    }
  }
}
