package com.xebialabs.xlrelease.notifications.configuration

import com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION
import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.xlrelease.domain.BaseConfiguration
import com.xebialabs.xlrelease.notifications.validators.SmtpServerRule

import scala.beans.BeanProperty

object SmtpServer {
  val SMTP_SERVER_ID = "Configuration/mail/SmtpServer"
}

@SmtpServerRule
@Metadata(label = "Smtp Server", root = CONFIGURATION, versioned = false)
class SmtpServer extends BaseConfiguration {
  @BeanProperty
  @Property(description = "SMTP server host")
  var host: String = ""

  @BeanProperty
  @Property(description = "SMTP server port")
  var port: Int = 0

  @BeanProperty
  @Property(required = false, label = "Use TLS", description = "Use Transport Layer Security (TLS) protocol over SMTP")
  var tls: Boolean = false

  @BeanProperty
  @Property(description = "Default sender address used in emails, if no other sender address is defined")
  var fromAddress: String = ""

  @BeanProperty
  @Property(required = false, description = "The email address where the test notification is sent. You can add multiple email addresses separated by commas.")
  var testAddress: String = ""

  @BeanProperty
  @Property(label = "Authentication Method", description = "Select the authentication method to access the SMTP server", nested = true)
  var authentication: SmtpAuthentication = _

  override def setId(id: String): Unit = {
    super.setId(id)
    if (null != authentication) {
      authentication.setId(id + "/authentication")
    }
  }

}
