package com.xebialabs.xlrelease.notifications.mentions

import com.xebialabs.xlrelease.service.UserInfoResolver
import com.xebialabs.xlrelease.service.UserInfoResolver.getFullNameOrUsernameOf

object Mentions {
  private val MENTION_REGEX = """(?:^|\s)@([@.\w-]+\.?)\b""".r

  def collectMentions(value: String): Set[String] = Option(value) match {
    case None | Some("") => Set.empty
    case Some(text) => MENTION_REGEX.findAllIn(text).matchData.flatMap(_.subgroups).toSet
  }

  def resolveMentions(value: String)(implicit userInfoResolver: UserInfoResolver): String = Option(value) match {
    case None | Some("") => value
    case Some(text) =>
      MENTION_REGEX.replaceAllIn(text, found => {
        val matched = found.matched
        val username = found.subgroups.head

        val fullName = userInfoResolver.getFullNameOf(username)
        val prefix = matched.substring(0, matched.indexOf("@"))

        Option(fullName)
          .map(fullName => s"$prefix**${getFullNameOrUsernameOf(username, fullName)}**")
          .getOrElse(matched)
      })
  }
}
