package com.xebialabs.xlrelease.notifications.config

import com.xebialabs.xlrelease.config.CacheManagementConstants.EMAIL_NOTIFICATION_CACHE_MANAGER
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.support.cache.caffeine.spring.XlrCaffeineCacheManager
import org.springframework.context.annotation.{Bean, Configuration}

@Configuration
class EmailNotificationsCacheConfig(xlrConfig: XlrConfig) {

  @Bean(value = Array(EMAIL_NOTIFICATION_CACHE_MANAGER))
  def emailNotificationsCacheManager() = new XlrCaffeineCacheManager(EMAIL_NOTIFICATION_CACHE_MANAGER, xlrConfig.getCacheSettings())
}

object EmailNotificationsCacheConfig {
  final val EMAIL_NOTIFICATION_CACHE = "email-notifications"
}
