/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.handlers;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.events.ConfigurationCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationDeletedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationUpdatedEvent;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.events.XLReleaseEventListener;
import com.xebialabs.xlrelease.notifications.configuration.EmailNotificationSettings;
import com.xebialabs.xlrelease.service.CacheManagementService;
import org.springframework.stereotype.Service;
import scala.reflect.ScalaSignature;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005=4A\u0001C\u0005\u0001)!A1\u0005\u0001B\u0001B\u0003%A\u0005C\u0003+\u0001\u0011\u00051\u0006C\u00030\u0001\u0011%\u0001\u0007C\u0003@\u0001\u0011\u0005\u0001\tC\u0003P\u0001\u0011\u0005\u0001\u000bC\u0003W\u0001\u0011\u0005q\u000bC\u0003^\u0001\u0011%aLA\u0013F[\u0006LGNT8uS\u001aL7-\u0019;j_:\u001cV\r\u001e;j]\u001e\u001cXI^3oi\"\u000bg\u000e\u001a7fe*\u0011!bC\u0001\tQ\u0006tG\r\\3sg*\u0011A\"D\u0001\u000e]>$\u0018NZ5dCRLwN\\:\u000b\u00059y\u0011!\u0003=me\u0016dW-Y:f\u0015\t\u0001\u0012#A\u0005yK\nL\u0017\r\\1cg*\t!#A\u0002d_6\u001c\u0001aE\u0002\u0001+u\u0001\"AF\u000e\u000e\u0003]Q!\u0001G\r\u0002\t1\fgn\u001a\u0006\u00025\u0005!!.\u0019<b\u0013\tarC\u0001\u0004PE*,7\r\u001e\t\u0003=\u0005j\u0011a\b\u0006\u0003A5\ta!\u001a<f]R\u001c\u0018B\u0001\u0012 \u0005YAFJU3mK\u0006\u001cX-\u0012<f]Rd\u0015n\u001d;f]\u0016\u0014\u0018AF2bG\",W*\u00198bO\u0016lWM\u001c;TKJ4\u0018nY3\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001dj\u0011aB:feZL7-Z\u0005\u0003S\u0019\u0012acQ1dQ\u0016l\u0015M\\1hK6,g\u000e^*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00051r\u0003CA\u0017\u0001\u001b\u0005I\u0001\"B\u0012\u0003\u0001\u0004!\u0013aE5t\u000b6\f\u0017\u000e\\*fiRLgnZ:UsB,GCA\u00198!\t\u0011T'D\u00014\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c4\u0005\u001d\u0011un\u001c7fC:DQ\u0001O\u0002A\u0002e\nAaY8oMB\u0011!(P\u0007\u0002w)\u0011A(D\u0001\u0007I>l\u0017-\u001b8\n\u0005yZ$!\u0005\"bg\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u00061rN\\\"p]\u001aLw-\u001e:bi&|gn\u0011:fCR,G\r\u0006\u0002B\tB\u0011!GQ\u0005\u0003\u0007N\u0012A!\u00168ji\")Q\t\u0002a\u0001\r\u0006)QM^3oiB\u0011q)S\u0007\u0002\u0011*\u0011\u0001eO\u0005\u0003\u0015\"\u0013\u0011dQ8oM&<WO]1uS>t7I]3bi\u0016$WI^3oi\"\u0012A\u0001\u0014\t\u0003=5K!AT\u0010\u0003\u0013M+(m]2sS\n,\u0017AF8o\u0007>tg-[4ve\u0006$\u0018n\u001c8Va\u0012\fG/\u001a3\u0015\u0005\u0005\u000b\u0006\"B#\u0006\u0001\u0004\u0011\u0006CA$T\u0013\t!\u0006JA\rD_:4\u0017nZ;sCRLwN\\+qI\u0006$X\rZ#wK:$\bFA\u0003M\u0003YygnQ8oM&<WO]1uS>tG)\u001a7fi\u0016$GCA!Y\u0011\u0015)e\u00011\u0001Z!\t9%,\u0003\u0002\\\u0011\nI2i\u001c8gS\u001e,(/\u0019;j_:$U\r\\3uK\u0012,e/\u001a8uQ\t1A*A\fdY\u0016\fg.R7bS2\u001cV\r\u001e;j]\u001e\u001c8)Y2iKR\u0011\u0011i\u0018\u0005\u0006q\u001d\u0001\r!\u000f\u0015\u0003\u0001\u0005\u0004\"AY5\u000e\u0003\rT!\u0001Z3\u0002\u0015M$XM]3pif\u0004XM\u0003\u0002gO\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001i\u0003\ry'oZ\u0005\u0003U\u000e\u0014qaU3sm&\u001cW\r\u000b\u0002\u0001YB\u0011a$\\\u0005\u0003]~\u0011Q\"\u0012<f]Rd\u0015n\u001d;f]\u0016\u0014\b")
public class EmailNotificationSettingsEventHandler
implements XLReleaseEventListener {
    private final CacheManagementService cacheManagementService;

    private boolean isEmailSettingsType(BaseConfiguration conf) {
        return conf.getType().instanceOf(Type.valueOf(EmailNotificationSettings.class));
    }

    @Subscribe
    public void onConfigurationCreated(ConfigurationCreatedEvent event) {
        this.cleanEmailSettingsCache(event.conf());
    }

    @Subscribe
    public void onConfigurationUpdated(ConfigurationUpdatedEvent event) {
        this.cleanEmailSettingsCache(event.updated());
    }

    @Subscribe
    public void onConfigurationDeleted(ConfigurationDeletedEvent event) {
        this.cleanEmailSettingsCache(event.conf());
    }

    private void cleanEmailSettingsCache(BaseConfiguration conf) {
        if (this.isEmailSettingsType(conf)) {
            this.cacheManagementService.clearCacheGroup("notification-settings", true);
            return;
        }
    }

    public EmailNotificationSettingsEventHandler(CacheManagementService cacheManagementService) {
        this.cacheManagementService = cacheManagementService;
    }
}

