package com.xebialabs.xlrelease.notifications.initialize

import com.xebialabs.deployit.security.PermissionEditor
import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import com.xebialabs.xlrelease.domain.Team.FOLDER_OWNER_TEAMNAME
import com.xebialabs.xlrelease.repository.Ids.ROOT_FOLDER_ID
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence
import com.xebialabs.xlrelease.security.XLReleasePermissions
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
class XLRelease100FolderNotificationsPermissionUpgrader @Autowired()(folderPersistence: FolderPersistence, permissionEditor: PermissionEditor)
  extends Upgrade with Logging {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "10.0.0#2")

  override def doUpgrade(): Boolean = {
    logger.info("Adding default permission for folder notifications")

    upgradeFolderNotificationsPermission()

    logger.info("Finished adding default permission for folder notifications")
    true
  }

  private def upgradeFolderNotificationsPermission(): Unit = {
    val folderUids = folderPersistence.findDescendantsById(ROOT_FOLDER_ID, Int.MaxValue).map(_.uid).distinct

    folderUids.foreach(folderUid => {
      val permissions = permissionEditor.readPermissions(folderUid.toString)

      if (permissions != null && !permissions.isEmpty) {
        val folderOwner = permissions.asScala.find(_._1.getName == FOLDER_OWNER_TEAMNAME)
        if (folderOwner.isDefined) {
          val folderOwnerPermissions = folderOwner.get._2
          folderOwnerPermissions.add(XLReleasePermissions.EDIT_FOLDER_NOTIFICATIONS)
        }

        permissionEditor.editPermissions(folderUid.toString, permissions)
      }
    })
  }
}
