package com.xebialabs.xlrelease.notifications.handlers

import com.xebialabs.xlrelease.domain.events.UserTokenAboutToExpireEvent
import com.xebialabs.xlrelease.events.{AsyncSubscribe, EventListener}
import com.xebialabs.xlrelease.notifications.{NotificationService, UserTokenAboutToExpire}
import org.springframework.stereotype.Component

import java.time.{Duration, Instant}

@Component
@EventListener
class UserTokenNotificationEventHandler(notificationService: NotificationService) {

  @AsyncSubscribe
  def onUserTokenAboutToExpire(event: UserTokenAboutToExpireEvent): Unit = {
    val userToken = event.userToken
    val expirationDurationInHours = Duration.between(Instant.now(), userToken.expiryDate.toInstant).toHours
    notificationService.notify(UserTokenAboutToExpire(userToken.username, userToken.tokenNote, expirationDurationInHours))
  }

}
