package com.xebialabs.xlrelease.notifications.service

import com.xebialabs.xlrelease.domain.BaseConfiguration
import com.xebialabs.xlrelease.domain.notification.MailPriority.Normal
import com.xebialabs.xlrelease.notifications.configuration.SmtpServer
import com.xebialabs.xlrelease.notifications.email.templates.Templater
import com.xebialabs.xlrelease.notifications.email.{ContextHelper, Email, EmailSender}
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.repository.Ids.isNullId
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils.replacePasswordPropertiesInCiIfNeeded
import io.micrometer.core.annotation.Timed
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

import scala.jdk.CollectionConverters._

@Service
class SmtpConfigurationService @Autowired()(emailSender: EmailSender,
                                            contextHelper: ContextHelper,
                                            configurationRepository: ConfigurationRepository) {

  @Timed
  def notifyTestEmail(smtpServer: SmtpServer): Unit = {
    val subject = "Test Mail"
    val body = "Test message from Digital.ai Release."
    val emailPriority = Normal
    val context = (contextHelper.baseContext + ("body" -> body)).asJava
    val recipientsList = smtpServer.getTestAddress.split(",").toList.asJava
    val processedBody = Templater.processTemplate("notification-task-template.mustache", context)

    if (!isNullId(smtpServer.getId) && configurationRepository.exists(smtpServer.getId)) {
      val original: BaseConfiguration = configurationRepository.read(smtpServer.getId)
      replacePasswordPropertiesInCiIfNeeded(Some(original), smtpServer)
    }
    emailSender.sendHTML(smtpServer, new Email(recipientsList, subject, processedBody).withPriority(emailPriority))
  }

  def getSmtpServerSettings(): SmtpServer = {
    if (configurationRepository.exists(SmtpServer.SMTP_SERVER_ID)) {
      configurationRepository.read(SmtpServer.SMTP_SERVER_ID)
    } else {
      new SmtpServer
    }
  }

}
