package com.xebialabs.xlrelease.notifications.initialize

import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.notifications.TriggerType.{AUDIT_REPORT_JOB_ABORTED, AUDIT_REPORT_JOB_COMPLETED, AUDIT_REPORT_JOB_FAILED, TriggerType}
import com.xebialabs.xlrelease.notifications.configuration.EmailNotificationSettings
import com.xebialabs.xlrelease.notifications.configuration.EmailNotificationSettings.GLOBAL_EMAIL_NOTIFICATION_SETTINGS_ID
import com.xebialabs.xlrelease.notifications.configuration.trigger.NotificationTriggerSettings
import com.xebialabs.xlrelease.notifications.initialize.EmailNotificationSettingsInitializer.notificationTriggerSettings
import com.xebialabs.xlrelease.service.ConfigurationService
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.common.BaseInitializingUpgrade
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component


@Component
class XLRelease100ReportJobEmailNotificationsUpgrade @Autowired()(configurationService: ConfigurationService)
  extends BaseInitializingUpgrade with Logging {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "10.0.0#4")

  override def doUpgrade(): Boolean = {
    val emailSettings = configurationService.read(GLOBAL_EMAIL_NOTIFICATION_SETTINGS_ID).asInstanceOf[EmailNotificationSettings]

    if (!emailSettings.hasNotificationTriggerSettings(AUDIT_REPORT_JOB_COMPLETED)) {
      emailSettings.setNotificationTriggerSettings(reportJobNotificationSettings(AUDIT_REPORT_JOB_COMPLETED))
    }

    if (!emailSettings.hasNotificationTriggerSettings(AUDIT_REPORT_JOB_FAILED)) {
      emailSettings.setNotificationTriggerSettings(reportJobNotificationSettings(AUDIT_REPORT_JOB_FAILED))
    }

    if (!emailSettings.hasNotificationTriggerSettings(AUDIT_REPORT_JOB_ABORTED)) {
      emailSettings.setNotificationTriggerSettings(reportJobNotificationSettings(AUDIT_REPORT_JOB_ABORTED))
    }

    logger.info("Adding back notification settings for audit report")

    configurationService.createOrUpdate(emailSettings)

    true
  }

  private val reportJobNotificationSettings: Map[TriggerType, NotificationTriggerSettings] = Map(
    AUDIT_REPORT_JOB_COMPLETED -> notificationTriggerSettings(
      AUDIT_REPORT_JOB_COMPLETED,
      subject = "[Release] Report '${report.reportName}' is ready",
      body =
        """
          | **Your audit report is complete!**
          |
          | '${report.reportName}' is ready for download.
          """.stripMargin.trim),
    AUDIT_REPORT_JOB_FAILED -> notificationTriggerSettings(
      AUDIT_REPORT_JOB_FAILED,
      subject = "[Release] Audit report has failed",
      body =
        """
          | **Your audit report has failed!**
          |
          | Please try to generate it again or contact your Release administrator for assistance.
          """.stripMargin.trim),
    AUDIT_REPORT_JOB_ABORTED -> notificationTriggerSettings(
      AUDIT_REPORT_JOB_ABORTED,
      subject = "[Release] Audit report was aborted",
      body =
        """
          | **Your audit report was aborted!**
          |
          | Please try to generate it again or contact your Release administrator for assistance.
          """.stripMargin.trim)
  )
}


