package com.xebialabs.xlrelease.notifications.api.internal

import com.xebialabs.deployit.security.permission.PlatformPermissions.ADMIN
import com.xebialabs.xlrelease.notifications.configuration.SmtpServer
import com.xebialabs.xlrelease.notifications.service.SmtpConfigurationService
import com.xebialabs.xlrelease.security.PermissionChecker
import jakarta.mail.MessagingException
import jakarta.ws.rs.core.MediaType.APPLICATION_JSON
import jakarta.ws.rs.{POST, Path, Produces}
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Controller

@Path("/settings/smtp")
@Produces(Array(APPLICATION_JSON))
@Controller
class SmtpResource @Autowired()(smtpConfigurationService: SmtpConfigurationService,
                                permissions: PermissionChecker) {

  @POST
  @Path("checkConfig")
  def checkSmtpConfig(smtpServer: SmtpServer): Unit = {
    permissions.check(ADMIN)
    try {
      smtpConfigurationService.notifyTestEmail(smtpServer)
    } catch {
      case e: MessagingException =>
        val exceptionMessage = if (e.getCause != null) e.getCause.getMessage else e.getMessage
        throw InvalidSmtpConfigException(s"Could not send test e-mail due to exception: $exceptionMessage");
    }
  }

}
