package com.xebialabs.xlrelease.notifications.handlers

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.BaseConfiguration
import com.xebialabs.xlrelease.domain.events.{ConfigurationCreatedEvent, ConfigurationDeletedEvent, ConfigurationUpdatedEvent}
import com.xebialabs.xlrelease.events.{EventListener, Subscribe, XLReleaseEventListener}
import com.xebialabs.xlrelease.notifications.actor.NotificationServiceActor.ClearCache
import com.xebialabs.xlrelease.notifications.actor.NotificationServiceActorInitializer.NotificationServiceActorHolder
import com.xebialabs.xlrelease.notifications.configuration.EmailNotificationSettings
import org.springframework.stereotype.Service

@Service
@EventListener
class EmailNotificationSettingsEventHandler(notificationServiceActorHolder: NotificationServiceActorHolder)
  extends XLReleaseEventListener {

  private lazy val notificationServiceActor = notificationServiceActorHolder

  private def isEmailSettingsType(conf: BaseConfiguration): Boolean = conf.getType.instanceOf(Type.valueOf(classOf[EmailNotificationSettings]))

  @Subscribe
  def onConfigurationCreated(event: ConfigurationCreatedEvent): Unit = {
    cleanEmailSettingsCache(event.conf)
  }

  @Subscribe
  def onConfigurationUpdated(event: ConfigurationUpdatedEvent): Unit = {
    cleanEmailSettingsCache(event.updated)
  }

  @Subscribe
  def onConfigurationDeleted(event: ConfigurationDeletedEvent): Unit = {
    cleanEmailSettingsCache(event.conf)
  }

  private def cleanEmailSettingsCache(conf: BaseConfiguration): Unit = {
    if (isEmailSettingsType(conf)) {
      notificationServiceActor ! ClearCache()
    }
  }
}
