/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.email;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.configuration.CustomLogoSettings;
import com.xebialabs.xlrelease.domain.notification.MailPriority;
import com.xebialabs.xlrelease.notifications.configuration.SmtpServer;
import com.xebialabs.xlrelease.notifications.email.Email;
import com.xebialabs.xlrelease.notifications.email.EmailFactory;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.service.ConfigurationService;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Transport;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.ByteArrayDataSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class EmailSender {
    private static final Logger logger = LoggerFactory.getLogger(EmailSender.class);
    private static final String LOGO_PATH = "/email-logo-digital-ai-release.png";
    private final XlrConfig xlrConfig;
    private final ConfigurationRepository configurationRepository;
    private final EmailFactory emailFactory;
    private final ConfigurationService configurationService;
    private final ExecutorService auxiliaryExecutor;

    public EmailSender(ConfigurationRepository configurationRepository, EmailFactory emailFactory, XlrConfig xlrConfig, ConfigurationService configurationService, @Qualifier(value="auxiliary") ExecutorService auxiliaryExecutor) {
        this.configurationRepository = configurationRepository;
        this.emailFactory = emailFactory;
        this.xlrConfig = xlrConfig;
        this.configurationService = configurationService;
        this.auxiliaryExecutor = auxiliaryExecutor;
    }

    public CompletableFuture<Void> scheduleEmail(Email email) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.auxiliaryExecutor.submit(() -> {
            try {
                this.sendEmailSync(email);
                future.complete(null);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public void sendEmailSync(Email email) throws MessagingException, NotFoundException {
        if (this.xlrConfig.maintenanceModeEnabled()) {
            logger.warn("[MAINTENANCE MODE] Email notification '{}' - DROPPED", (Object)email.subject);
            return;
        }
        if (email.getRecipients() == null || email.getRecipients().isEmpty()) {
            String msg = String.format("Email with subject '%s' not sent, because the recipient is missing.", email.getSubject());
            logger.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        try {
            this.sendHTML(email);
        }
        catch (NotFoundException notFoundException) {
            logger.info("Could not send email: {}. Please configure the SMTP Server", (Object)notFoundException.toString());
            throw notFoundException;
        }
        catch (MessagingException e) {
            logger.error("Could not send email ", (Throwable)e);
            throw e;
        }
    }

    void sendHTML(Email email) throws MessagingException {
        SmtpServer smtpServer = (SmtpServer)this.configurationRepository.read(SmtpServer.SMTP_SERVER_ID());
        this.sendHTML(smtpServer, email);
    }

    public void sendHTML(SmtpServer smtpServer, Email email) throws MessagingException {
        MimeMessage mimeEmail = this.emailFactory.newMimeEmail(smtpServer, email.getSenderUsername(), email.getSenderPassword());
        this.setRecipients(mimeEmail, email.getRecipients());
        if (email.getFrom().isPresent() && !email.getFrom().get().isEmpty()) {
            this.setFrom(mimeEmail, email.getFrom().orElse(""));
        } else {
            this.setFrom(mimeEmail, smtpServer.getFromAddress());
        }
        this.setMailPriority(mimeEmail, email.getPriority().orElse(MailPriority.Normal));
        if (email.getBcc().isPresent() && !email.getBcc().get().isEmpty()) {
            mimeEmail.addRecipients(Message.RecipientType.BCC, (Address[])this.toInternetAddresses(email.getBcc().orElse(Collections.emptyList())));
        }
        if (email.getCc().isPresent() && !email.getCc().get().isEmpty()) {
            mimeEmail.addRecipients(Message.RecipientType.CC, (Address[])this.toInternetAddresses(email.getCc().orElse(Collections.emptyList())));
        }
        if (email.getReplyTo().isPresent() && !email.getReplyTo().get().isEmpty()) {
            InternetAddress[] parse = InternetAddress.parse((String)email.getReplyTo().orElse(""));
            mimeEmail.setReplyTo((Address[])parse);
        }
        mimeEmail.setSubject(email.getSubject());
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart emailBodyPart = new MimeBodyPart();
        emailBodyPart.setContent((Object)email.getBody(), "text/html");
        multipart.addBodyPart((BodyPart)emailBodyPart);
        MimeBodyPart logoPart = new MimeBodyPart();
        logoPart.setContentID("logo");
        logoPart.setDisposition("inline");
        logoPart.setDataHandler(new DataHandler(this.getClass().getResource(LOGO_PATH)));
        multipart.addBodyPart((BodyPart)logoPart);
        try {
            MimeBodyPart customLogo = new MimeBodyPart();
            CustomLogoSettings customLogoSettings = this.readCustomLogo();
            byte[] customLogoByteArray = Base64.getDecoder().decode(customLogoSettings.getContent());
            ByteArrayDataSource customLogoDataSource = new ByteArrayDataSource(customLogoByteArray, customLogoSettings.getContentType());
            customLogo.setContentID("customLogo");
            customLogo.setDisposition("inline");
            customLogo.setDataHandler(new DataHandler((DataSource)customLogoDataSource));
            multipart.addBodyPart((BodyPart)customLogo);
        }
        catch (NotFoundException e) {
            logger.debug("Custom logo is not found");
        }
        mimeEmail.setContent((Multipart)multipart);
        Transport.send((Message)mimeEmail);
    }

    private CustomLogoSettings readCustomLogo() {
        CustomLogoSettings customLogoSettings = (CustomLogoSettings)this.configurationService.read("Configuration/settings/CustomLogoSettings");
        if (customLogoSettings.getContent() == null) {
            throw new NotFoundException("Custom logo is not found", new Object[0]);
        }
        return customLogoSettings;
    }

    void setMailPriority(MimeMessage mimeEmail, MailPriority mailPriority) throws MessagingException {
        mimeEmail.addHeader("X-Priority", mailPriority.getPriority());
        mimeEmail.addHeader("Importance", mailPriority.getImportance());
    }

    @VisibleForTesting
    void setRecipients(MimeMessage mimeEmail, Collection<String> recipients) throws MessagingException {
        mimeEmail.setRecipients(Message.RecipientType.TO, (Address[])this.toInternetAddresses(recipients));
    }

    @VisibleForTesting
    InternetAddress[] toInternetAddresses(Collection<String> recipients) throws IllegalArgumentException {
        ArrayList<InternetAddress> addresses = new ArrayList<InternetAddress>();
        for (String recipient : recipients) {
            try {
                addresses.addAll(Arrays.asList(InternetAddress.parse((String)recipient)));
            }
            catch (AddressException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return addresses.toArray(new InternetAddress[0]);
    }

    @VisibleForTesting
    void setFrom(MimeMessage mimeEmail, String fromAddress) throws IllegalArgumentException {
        if (fromAddress == null) {
            return;
        }
        try {
            InternetAddress from = new InternetAddress(fromAddress);
            mimeEmail.setFrom((Address)from);
        }
        catch (MessagingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

