package com.xebialabs.xlrelease.notifications.actor

import com.xebialabs.xlrelease.actors.{ActorSystemHolder, ManagedActor}
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.notifications.actor.NotificationServiceActorInitializer.NotificationServiceActorHolder
import com.xebialabs.xlrelease.notifications.email.EmailNotificationsService
import grizzled.slf4j.Logging
import org.apache.pekko.actor.Props
import org.springframework.context.annotation.{Bean, Configuration}

object NotificationServiceActorInitializer {
  type NotificationServiceActorHolder = ManagedActor[NotificationServiceActor]
}

@Configuration
class NotificationServiceActorInitializer(xlrConfig: XlrConfig, systemHolder: ActorSystemHolder, emailNotificationsService: EmailNotificationsService)
  extends Logging {

  @Bean
  def notificationServiceActorHolder(): NotificationServiceActorHolder = {
    val props = if (xlrConfig.isClusterEnabled) {
      Props(new ClusteredNotificationServiceActor(emailNotificationsService))
    } else {
      Props(new NonClusteredNotificationServiceActor(emailNotificationsService))
    }
    systemHolder.actorOf(props, NotificationServiceActor.name)

  }
}
