package com.xebialabs.xlrelease.notifications.initialize

import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.notifications.configuration.EmailNotificationSettings
import com.xebialabs.xlrelease.notifications.configuration.EmailNotificationSettings.GLOBAL_EMAIL_NOTIFICATION_SETTINGS_ID
import com.xebialabs.xlrelease.notifications.configuration.trigger.TemplateSettings
import com.xebialabs.xlrelease.service.ConfigurationService
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.common.BaseInitializingUpgrade
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
class XLRelease970EmailNotificationsRebrandingUpgrade @Autowired()(configurationService: ConfigurationService)
  extends BaseInitializingUpgrade with Logging {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "9.7.0#6")

  override def doUpgrade(): Boolean = {
    val emailSettings = configurationService.read(GLOBAL_EMAIL_NOTIFICATION_SETTINGS_ID).asInstanceOf[EmailNotificationSettings]

    val updated = emailSettings.getNotificationTriggerSettings.asScala.map { notificationTriggerSettings =>
      val templateSettings: TemplateSettings = notificationTriggerSettings.getTemplateSettings
      if (templateSettings != null && templateSettings.getSubject != null) {
        templateSettings.setSubject(templateSettings.getSubject
          .replaceAll("\\[XL Release\\]", "[Release]"))
        notificationTriggerSettings.setTemplateSettings(templateSettings)
      }
      if (templateSettings != null && templateSettings.getBody != null) {
        templateSettings.setBody(templateSettings.getBody
          .replaceAll("XL Release", "Release"))
        notificationTriggerSettings.setTemplateSettings(templateSettings)
      }

      val bulkTemplateSettings = notificationTriggerSettings.getBulkTemplateSettings
      if (bulkTemplateSettings != null && bulkTemplateSettings.getSubject != null) {
        bulkTemplateSettings.setSubject(bulkTemplateSettings.getSubject
          .replaceAll("\\[XL Release\\]", "[Release]"))
        notificationTriggerSettings.setBulkTemplateSettings(bulkTemplateSettings)
      }
      if (bulkTemplateSettings != null && bulkTemplateSettings.getBody != null) {
        bulkTemplateSettings.setBody(bulkTemplateSettings.getBody
          .replaceAll("XL Release", "Release"))
        notificationTriggerSettings.setBulkTemplateSettings(bulkTemplateSettings)
      }

      notificationTriggerSettings
    }.asJava

    emailSettings.setNotificationTriggerSettings(updated)

    configurationService.createOrUpdate(emailSettings)

    true
  }
}
