package com.xebialabs.xlrelease.notifications.email

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.config.CacheManagementConstants.EMAIL_NOTIFICATION_CACHE_MANAGER
import com.xebialabs.xlrelease.notifications.config.EmailNotificationsCacheConfig.EMAIL_NOTIFICATION_CACHE
import com.xebialabs.xlrelease.notifications.configuration.EmailNotificationSettings
import com.xebialabs.xlrelease.notifications.configuration.EmailNotificationSettings.GLOBAL_EMAIL_NOTIFICATION_SETTINGS_ID
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.repository.Ids.{isFolderId, isRoot}
import com.xebialabs.xlrelease.service.ConfigurationService
import grizzled.slf4j.Logging
import org.springframework.cache.annotation.{CacheConfig, CacheEvict, Cacheable}
import org.springframework.stereotype.Service

import scala.jdk.CollectionConverters._

@Service
@CacheConfig(cacheManager = EMAIL_NOTIFICATION_CACHE_MANAGER)
class EmailNotificationCache(configurationRepository: ConfigurationRepository,
                             configurationService: ConfigurationService) extends Logging {
  @Cacheable(value = Array(EMAIL_NOTIFICATION_CACHE))
  def getSettings(containerId: String): EmailNotificationSettings = {
    containerId match {
      case id if isRoot(id) => configurationService.read(GLOBAL_EMAIL_NOTIFICATION_SETTINGS_ID).asInstanceOf[EmailNotificationSettings]
      case id if isFolderId(id) =>
        def directoryDepth(conf: EmailNotificationSettings): Int = {
          if (conf.getFolderId == null) 0 else conf.getFolderId.count(_ == '/')
        }

        val allSettings: Seq[EmailNotificationSettings] = configurationRepository
          .findAllByTypeAndTitle(Type.valueOf(classOf[EmailNotificationSettings]), null, id, folderOnly = false)
          .asScala
          .toSeq
        allSettings.sortBy(directoryDepth)(Ordering.Int.reverse)
          .headOption
          .getOrElse(throw new IllegalStateException(s"No email notification settings found for $id"))
      case id => configurationService.read(id).asInstanceOf[EmailNotificationSettings]
    }
  }

  @CacheEvict(value = Array(EMAIL_NOTIFICATION_CACHE), allEntries = true)
  def clearCache(): Unit = {
    logger.debug("Invalidating all cache entries for EmailNotificationSettings")
  }
}
