package com.xebialabs.xlrelease.notifications.email.templates

import com.samskivert.mustache.Mustache
import com.xebialabs.xlrelease.notifications.TriggerType._
import com.xebialabs.xlrelease.notifications.email.{JavaMustacheContext, ScalaMustacheContext}
import com.xebialabs.xlrelease.utils.MarkdownProcessor.process
import grizzled.slf4j.Logging

import java.io.{BufferedReader, InputStreamReader, Reader}
import java.lang.Thread.currentThread
import scala.jdk.CollectionConverters._

object Templater extends Logging {

  private val DELIMITERS = "${ }"

  def createPreviewForTriggerType(triggerType: TriggerType, baseContext: ScalaMustacheContext, body: String, serverUrl: String = "${url}"): String = {
    val template = getTemplate(triggerType)._1  // TODO implement bulk template preview
    val context = baseContext + (
      "body" -> process(body).orElse(""),
      "url" -> serverUrl,
      "task.description" -> "${task.description}"
    )
    processTemplate(template, context.asJava)
  }

  def processTemplateForTriggerType(triggerType: TriggerType, context: JavaMustacheContext): String = {
    processTemplate(getTemplate(triggerType)._1, context)
  }
  def processTemplateForTriggerType(triggerType: TriggerType, context: JavaMustacheContext, body: String): String = {
    val bodyWithResolvedVariables = processString(body, context)
    val bodyWithProcessedMarkdown = process(bodyWithResolvedVariables).orElse("")
    val template = getTemplate(triggerType)._1

    processTemplate(template, (context.asScala + ("body" -> bodyWithProcessedMarkdown)).asJava)
  }

  def processBulkTemplateForTriggerType(triggerType: TriggerType, context: JavaMustacheContext, body: String): String = {
    val bodyWithResolvedVariables = processString(body, context)
    val bodyWithProcessedMarkdown = process(bodyWithResolvedVariables).orElse("")
    val bulkTemplate = getTemplate(triggerType)._2

    processTemplate(bulkTemplate, (context.asScala + ("body" -> bodyWithProcessedMarkdown)).asJava)
  }

  def processTemplate(templateName: String, context: JavaMustacheContext): String = {
    mustacheCompiler
      .compile(getTemplateReader(templateName))
      .execute(context)
  }

  def processString(string: String, context: JavaMustacheContext): String = {
    mustacheCompiler
      .withDelims(DELIMITERS)
      .compile(string)
      .execute(context)
  }

  private def mustacheCompiler: Mustache.Compiler = {
    Mustache.compiler().defaultValue("")
  }

  private def getTemplate(triggerType: TriggerType): MustacheTemplates = {
    TRIGGER_TYPE_GROUPS(triggerType)
  }

  private def getTemplateReader(templateName: String): Reader = {
    val inputStream = currentThread().getContextClassLoader.getResourceAsStream(s"$TEMPLATE_LOCATION/$templateName")
    new BufferedReader(new InputStreamReader(inputStream))
  }
}
