package com.xebialabs.xlrelease.notifications

import com.xebialabs.xlrelease.domain.{CustomScriptTask, Release, ScriptTask, Task}
import com.xebialabs.xlrelease.service.PhaseRestart.RESTART_PHASE_ERROR

import scala.jdk.CollectionConverters._
import scala.util.{Failure, Success, Try}

package object handlers {
  implicit val wrapTask: Task => List[Task] = List(_)
  implicit val wrapRelease: Release => List[Release] = List(_)
}


package object utils {

  def failedDuringPhaseRestartFromScriptTask(task: Task): Boolean = Try(task.getComments.asScala.last.getText) match {
    case Success(lastCommentText) => lastCommentText.equals(RESTART_PHASE_ERROR) &&
      (task.isInstanceOf[ScriptTask] || task.isInstanceOf[CustomScriptTask])
    case Failure(_) => true
  }

}