/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.notifications.TriggerType$;
import com.xebialabs.xlrelease.notifications.configuration.EmailNotificationSettings;
import com.xebialabs.xlrelease.notifications.configuration.trigger.NotificationTriggerSettings;
import com.xebialabs.xlrelease.notifications.email.EmailNotificationsService;
import com.xebialabs.xlrelease.notifications.views.EmailNotificationSettingsView;
import com.xebialabs.xlrelease.notifications.views.EmailPreviewView;
import com.xebialabs.xlrelease.notifications.views.converters.EmailNotificationSettingsConverter;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import scala.reflect.ScalaSignature;

@Path(value="/settings/notifications")
@Produces(value={"application/json"})
@Controller
@ScalaSignature(bytes="\u0006\u0005\t\u001da\u0001B\t\u0013\u0001}A\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\t[\u0001\u0011\t\u0011)A\u0005]!AA\u0007\u0001B\u0001B\u0003%Q\u0007C\u0003<\u0001\u0011\u0005A\bC\u0004R\u0001\t\u0007I\u0011\u0002*\t\rm\u0003\u0001\u0015!\u0003T\u0011\u0015a\u0006\u0001\"\u0001^\u0011\u00151\b\u0001\"\u0001x\u0011\u0019y\b\u0001\"\u0001\u0002\u0002!9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\u0002B\u0002/\u0001\t\u0003\ti\u0006C\u0004\u0002\n\u0002!\t!a#\t\u000f\u0005m\u0005\u0001\"\u0001\u0002\u001e\"1a\u000f\u0001C\u0001\u0003WCaa \u0001\u0005\u0002\u0005}\u0006bBAi\u0001\u0011\u0005\u00111\u001b\u0002\u0016\u001d>$\u0018NZ5dCRLwN\\:SKN|WO]2f\u0015\t\u0019B#\u0001\u0005j]R,'O\\1m\u0015\t)b#A\u0002ba&T!a\u0006\r\u0002\u001b9|G/\u001b4jG\u0006$\u0018n\u001c8t\u0015\tI\"$A\u0005yYJ,G.Z1tK*\u00111\u0004H\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!H\u0001\u0004G>l7\u0001A\n\u0003\u0001\u0001\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0017!G3nC&dgj\u001c;jM&\u001c\u0017\r^5p]N\u001cVM\u001d<jG\u0016\u0004\"\u0001K\u0016\u000e\u0003%R!A\u000b\f\u0002\u000b\u0015l\u0017-\u001b7\n\u00051J#!G#nC&dgj\u001c;jM&\u001c\u0017\r^5p]N\u001cVM\u001d<jG\u0016\f1\u0002]3s[&\u001c8/[8ogB\u0011qFM\u0007\u0002a)\u0011\u0011\u0007G\u0001\tg\u0016\u001cWO]5us&\u00111\u0007\r\u0002\u0012!\u0016\u0014X.[:tS>t7\t[3dW\u0016\u0014\u0018aE:feZ,'oQ8oM&<WO]1uS>t\u0007C\u0001\u001c:\u001b\u00059$B\u0001\u001d\u001b\u0003!!W\r\u001d7ps&$\u0018B\u0001\u001e8\u0005M\u0019VM\u001d<fe\u000e{gNZ5hkJ\fG/[8o\u0003\u0019a\u0014N\\5u}Q!Qh\u0010!B!\tq\u0004!D\u0001\u0013\u0011\u00151C\u00011\u0001(\u0011\u0015iC\u00011\u0001/\u0011\u0015!D\u00011\u00016Q\t!1\t\u0005\u0002E\u001f6\tQI\u0003\u0002G\u000f\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005!K\u0015a\u00024bGR|'/\u001f\u0006\u0003\u0015.\u000bQAY3b]NT!\u0001T'\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011AT\u0001\u0004_J<\u0017B\u0001)F\u0005%\tU\u000f^8xSJ,G-A\u0005tKJ4XM]+sYV\t1\u000b\u0005\u0002U36\tQK\u0003\u0002W/\u0006!A.\u00198h\u0015\u0005A\u0016\u0001\u00026bm\u0006L!AW+\u0003\rM#(/\u001b8h\u0003)\u0019XM\u001d<feV\u0013H\u000eI\u0001\u001dO\u0016$X)\\1jY:{G/\u001b4jG\u0006$\u0018n\u001c8TKR$\u0018N\\4t+\u0005q\u0006CA0c\u001b\u0005\u0001'BA1\u0017\u0003\u00151\u0018.Z<t\u0013\t\u0019\u0007MA\u000fF[\u0006LGNT8uS\u001aL7-\u0019;j_:\u001cV\r\u001e;j]\u001e\u001ch+[3xQ\t9Q\r\u0005\u0002g[6\tqM\u0003\u0002iS\u0006\u0011!o\u001d\u0006\u0003U.\f!a^:\u000b\u00031\fqA[1lCJ$\u0018-\u0003\u0002oO\n\u0019q)\u0012+)\t\u001d\u00018\u000f\u001e\t\u0003MFL!A]4\u0003\tA\u000bG\u000f[\u0001\u0006m\u0006dW/Z\u0011\u0002k\u00061Q-\\1jYN\fq$\u001e9eCR,W)\\1jY:{G/\u001b4jG\u0006$\u0018n\u001c8TKR$\u0018N\\4t)\tq\u0006\u0010C\u0003z\u0011\u0001\u0007a,A\u000ff[\u0006LGNT8uS\u001aL7-\u0019;j_:\u001cV\r\u001e;j]\u001e\u001ch+[3xQ\tA1\u0010\u0005\u0002gy&\u0011Qp\u001a\u0002\u0005!>\u001bF\u000b\u000b\u0003\taN$\u0018aG;qI\u0006$X-R7bS2$V-\u001c9mCR,7+\u001a;uS:<7\u000f\u0006\u0003\u0002\u0004\u0005%\u0001cA\u0011\u0002\u0006%\u0019\u0011q\u0001\u0012\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u0017I\u0001\u0019AA\u0007\u0003mqw\u000e^5gS\u000e\fG/[8o)JLwmZ3s'\u0016$H/\u001b8hgB!\u0011qBA\r\u001b\t\t\tB\u0003\u0003\u0002\u0014\u0005U\u0011a\u0002;sS\u001e<WM\u001d\u0006\u0004\u0003/1\u0012!D2p]\u001aLw-\u001e:bi&|g.\u0003\u0003\u0002\u001c\u0005E!a\u0007(pi&4\u0017nY1uS>tGK]5hO\u0016\u00148+\u001a;uS:<7\u000f\u000b\u0002\nw\"*\u0011\u0002]:\u0002\"\u0005\u0012\u00111E\u0001\u0017K6\f\u0017\u000e\\:0iJLwmZ3s'\u0016$H/\u001b8hg\u00069\u0001O]3wS\u0016<HCBA\u0015\u0003{\tY\u0005\u0005\u0003\u0002,\u0005eb\u0002BA\u0017\u0003k\u00012!a\f#\u001b\t\t\tDC\u0002\u00024y\ta\u0001\u0010:p_Rt\u0014bAA\u001cE\u00051\u0001K]3eK\u001aL1AWA\u001e\u0015\r\t9D\t\u0005\b\u0003\u007fQ\u0001\u0019AA\u0015\u0003!1w\u000e\u001c3fe&#\u0007fBA\u001f\u0003\u0007\u001a\u0018\u0011\n\t\u0004M\u0006\u0015\u0013bAA$O\nQ\u0011+^3ssB\u000b'/Y7\"\u0005\u0005}\u0002bBA'\u0015\u0001\u0007\u0011qJ\u0001\u0005m&,w\u000fE\u0002`\u0003#J1!a\u0015a\u0005A)U.Y5m!J,g/[3x-&,w\u000f\u000b\u0002\u000bw\"*!\u0002]:\u0002Z\u0005\u0012\u00111L\u0001\u000fK6\f\u0017\u000e\\:0aJ,g/[3x)\rq\u0016q\f\u0005\b\u0003CZ\u0001\u0019AA\u0015\u0003)\u0019X\r\u001e;j]\u001e\u001c\u0018\n\u001a\u0015\b\u0003?\n)g]A6!\r1\u0017qM\u0005\u0004\u0003S:'!\u0003)bi\"\u0004\u0016M]1nC\t\t\t\u0007\u000b\u0002\fK\"\u001a1\"!\u001d\u0011\t\u0005M\u0014qP\u0007\u0003\u0003kR1ARA<\u0015\u0011\tI(a\u001f\u0002\u000f5,GO]5dg*\u0019\u0011Q\u0010\u000f\u0002\u0011\r|G-\u00195bY\u0016LA!!!\u0002v\t)A+[7fI\"*1\u0002]:\u0002\u0006\u0006\u0012\u0011qQ\u00016K6\f\u0017\u000e\\:0wN,G\u000f^5oONLEM\u000f\u0018+_\u0015k\u0017-\u001b7O_RLg-[2bi&|gnU3ui&twm].__uSS0A\u0013hKR,U.Y5m\u001d>$\u0018NZ5dCRLwN\\*fiRLgnZ:G_J4u\u000e\u001c3feR\u0019a,!$\t\u000f\u0005}B\u00021\u0001\u0002*!:\u0011QRA3g\u0006%\u0003F\u0001\u0007fQ\ra\u0011\u0011\u000f\u0015\u0006\u0019A\u001c\u0018qS\u0011\u0003\u00033\u000b\u0001%Z7bS2\u001cxf\u001f4pY\u0012,'/\u00133;])zci\u001c7eKJ\\flL/+{\u0006a\u0012\r\u001a3F[\u0006LGNT8uS\u001aL7-\u0019;j_:\u001cV\r\u001e;j]\u001e\u001cH#\u00020\u0002 \u0006\r\u0006bBA \u001b\u0001\u0007\u0011\u0011\u0006\u0015\b\u0003?\u000b)g]A%\u0011\u0015IX\u00021\u0001_Q\ti1\u0010K\u0002\u000e\u0003cBS!\u00049t\u0003/#RAXAW\u0003cCq!!\u0019\u000f\u0001\u0004\tI\u0003K\u0004\u0002.\u0006\u00154/a\u001b\t\u000bet\u0001\u0019\u00010)\u00079\t)\fE\u0002g\u0003oK1!!/h\u0005\r\u0001V\u000b\u0016\u0015\u0004\u001d\u0005E\u0004&\u0002\bqg\u0006\u0015ECBA\u0002\u0003\u0003\f)\rC\u0004\u0002b=\u0001\r!!\u000b)\u000f\u0005\u0005\u0017QM:\u0002l!9\u00111B\bA\u0002\u00055\u0001fA\b\u00026\"\u001aq\"!\u001d)\u000b=\u00018/!4\"\u0005\u0005=\u0017!R3nC&d7oL>tKR$\u0018N\\4t\u0013\u0012TdFK\u0018F[\u0006LGNT8uS\u001aL7-\u0019;j_:\u001cV\r\u001e;j]\u001e\u001c8LX\u0018^Uu|CO]5hO\u0016\u00148+\u001a;uS:<7/A\u0010eK2,G/Z#nC&dgj\u001c;jM&\u001c\u0017\r^5p]N+G\u000f^5oON$B!a\u0001\u0002V\"9\u0011\u0011\r\tA\u0002\u0005%\u0002fBAk\u0003K\u001a\u00181\u000e\u0015\u0004!\u0005m\u0007c\u00014\u0002^&\u0019\u0011q\\4\u0003\r\u0011+E*\u0012+FQ\r\u0001\u0012\u0011\u000f\u0015\u0006!A\u001c\u0018Q\u0011\u0015\u0006\u0001A\u001c\u0018q]\u0011\u0003\u0003S\fqcL:fiRLgnZ:0]>$\u0018NZ5dCRLwN\\:)\r\u0001\tio]Az!\r1\u0017q^\u0005\u0004\u0003c<'\u0001\u0003)s_\u0012,8-Z:-\u0005\u0005U\u0018EAA|\u0003A\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c80UN|g\u000eK\u0002\u0001\u0003w\u0004B!!@\u0003\u00045\u0011\u0011q \u0006\u0004\u0005\u0003Y\u0015AC:uKJ,w\u000e^=qK&!!QAA\u0000\u0005)\u0019uN\u001c;s_2dWM\u001d")
public class NotificationsResource {
    private final EmailNotificationsService emailNotificationsService;
    private final PermissionChecker permissions;
    private final String serverUrl;

    private String serverUrl() {
        return this.serverUrl;
    }

    @GET
    @Path(value="emails")
    public EmailNotificationSettingsView getEmailNotificationSettings() {
        this.permissions.check(PlatformPermissions.ADMIN);
        return EmailNotificationSettingsConverter.toView(this.emailNotificationsService.getSettings("Configuration/mail/EmailNotificationSettings"));
    }

    @POST
    @Path(value="emails")
    public EmailNotificationSettingsView updateEmailNotificationSettings(EmailNotificationSettingsView emailNotificationSettingsView) {
        this.permissions.check(PlatformPermissions.ADMIN);
        emailNotificationSettingsView.setId("Configuration/mail/EmailNotificationSettings");
        emailNotificationSettingsView.setFolderId(Ids.ROOT_FOLDER_ID);
        return EmailNotificationSettingsConverter.toView(this.emailNotificationsService.updateSettings(EmailNotificationSettingsConverter.fromView(emailNotificationSettingsView)));
    }

    @POST
    @Path(value="emails/triggerSettings")
    public void updateEmailTemplateSettings(NotificationTriggerSettings notificationTriggerSettings) {
        this.permissions.check(PlatformPermissions.ADMIN);
        EmailNotificationSettings settings = this.emailNotificationsService.getSettings("Configuration/mail/EmailNotificationSettings");
        settings.setNotificationTriggerSettings(notificationTriggerSettings);
        this.emailNotificationsService.updateSettings(settings);
    }

    @POST
    @Path(value="emails/preview")
    public String preview(@QueryParam(value="folderId") String folderId, EmailPreviewView view) {
        if (!StringUtils.isEmpty((Object)folderId) && !Ids.isRoot((String)folderId)) {
            this.permissions.checkEditNotification(folderId);
        } else {
            this.permissions.check(PlatformPermissions.ADMIN);
        }
        return this.emailNotificationsService.createPreview(TriggerType$.MODULE$.withName(view.triggerType()), view.body(), this.serverUrl());
    }

    @GET
    @Timed
    @Path(value="emails/{settingsId:.*/EmailNotificationSettings[^/]*}")
    public EmailNotificationSettingsView getEmailNotificationSettings(@PathParam(value="settingsId") String settingsId) {
        EmailNotificationSettings settings = this.emailNotificationsService.getSettings(settingsId);
        this.permissions.checkEditNotification(settings.getFolderId());
        return EmailNotificationSettingsConverter.toView(settings);
    }

    @GET
    @Timed
    @Path(value="emails/{folderId:.*/Folder[^/]*}")
    public EmailNotificationSettingsView getEmailNotificationSettingsForFolder(@PathParam(value="folderId") String folderId) {
        this.permissions.checkEditNotification(folderId);
        return EmailNotificationSettingsConverter.toView(this.emailNotificationsService.getSettings(folderId), this.emailNotificationsService.getInheritableFolderId(folderId));
    }

    @POST
    @Timed
    @Path(value="emails/{folderId:.*/Folder[^/]*}")
    public EmailNotificationSettingsView addEmailNotificationSettings(@PathParam(value="folderId") String folderId, EmailNotificationSettingsView emailNotificationSettingsView) {
        this.permissions.checkEditNotification(folderId);
        emailNotificationSettingsView.setFolderId(folderId);
        return EmailNotificationSettingsConverter.toView(this.emailNotificationsService.create(EmailNotificationSettingsConverter.fromView(emailNotificationSettingsView)));
    }

    @PUT
    @Timed
    @Path(value="emails/{settingsId:.*/EmailNotificationSettings[^/]*}")
    public EmailNotificationSettingsView updateEmailNotificationSettings(@PathParam(value="settingsId") String settingsId, EmailNotificationSettingsView emailNotificationSettingsView) {
        EmailNotificationSettings settings = this.emailNotificationsService.getSettings(settingsId);
        this.permissions.checkEditNotification(settings.getFolderId());
        emailNotificationSettingsView.setId(settingsId);
        return EmailNotificationSettingsConverter.toView(this.emailNotificationsService.updateSettings(EmailNotificationSettingsConverter.fromView(emailNotificationSettingsView)));
    }

    @PUT
    @Timed
    @Path(value="emails/{settingsId:.*/EmailNotificationSettings[^/]*}/triggerSettings")
    public void updateEmailTemplateSettings(@PathParam(value="settingsId") String settingsId, NotificationTriggerSettings notificationTriggerSettings) {
        EmailNotificationSettings settings = this.emailNotificationsService.getSettings(settingsId);
        this.permissions.checkEditNotification(settings.getFolderId());
        settings.setNotificationTriggerSettings(notificationTriggerSettings);
        this.emailNotificationsService.updateSettings(settings);
    }

    @DELETE
    @Timed
    @Path(value="emails/{settingsId:.*/EmailNotificationSettings[^/]*}")
    public void deleteEmailNotificationSettings(@PathParam(value="settingsId") String settingsId) {
        EmailNotificationSettings settings = this.emailNotificationsService.getSettings(settingsId);
        String string = settings.getId();
        String string2 = "Configuration/mail/EmailNotificationSettings";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new IllegalArgumentException("Can't delete the global email notification settings");
        }
        this.permissions.checkEditNotification(settings.getFolderId());
        this.emailNotificationsService.deleteSettings(settings);
    }

    @Autowired
    public NotificationsResource(EmailNotificationsService emailNotificationsService, PermissionChecker permissions, ServerConfiguration serverConfiguration) {
        this.emailNotificationsService = emailNotificationsService;
        this.permissions = permissions;
        this.serverUrl = serverConfiguration.getServerUrl();
    }
}

