package com.xebialabs.xlrelease.notifications.initialize

import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.notifications.TriggerType.GENERIC_SYSTEM_NOTIFICATION
import com.xebialabs.xlrelease.notifications.configuration.EmailNotificationSettings
import com.xebialabs.xlrelease.notifications.configuration.EmailNotificationSettings.GLOBAL_EMAIL_NOTIFICATION_SETTINGS_ID
import com.xebialabs.xlrelease.notifications.configuration.trigger.NotificationTriggerSettings
import com.xebialabs.xlrelease.notifications.initialize.EmailNotificationSettingsInitializer.notificationTriggerSettings
import com.xebialabs.xlrelease.service.ConfigurationService
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.common.BaseInitializingUpgrade
import grizzled.slf4j.Logging
import org.springframework.stereotype.Component

@Component
class XLRelease231GenericEmailNotificationsUpgrade(configurationService: ConfigurationService)
  extends BaseInitializingUpgrade with Logging {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "23.1.0#4")

  override def doUpgrade(): Boolean = {
    val emailSettings = configurationService.read(GLOBAL_EMAIL_NOTIFICATION_SETTINGS_ID).asInstanceOf[EmailNotificationSettings]

    genericSystemNotificationSettings.foreach { settings =>
      emailSettings.setNotificationTriggerSettings(settings)
    }

    logger.info("Adding notification settings for generic notification")

    configurationService.createOrUpdate(emailSettings)
    true
  }

  private val genericSystemNotificationSettings: List[NotificationTriggerSettings] = List(
    notificationTriggerSettings(
      GENERIC_SYSTEM_NOTIFICATION,
      subject = "${notification.subject}",
      body =
        """
          | ${notification.body}
          """.stripMargin.trim),
  )
}


