package com.xebialabs.xlrelease.notifications.actor

import akka.actor.{Actor, ActorLogging, ActorRef}
import akka.cluster.pubsub.DistributedPubSub
import akka.cluster.pubsub.DistributedPubSubMediator.{Publish, Subscribe, SubscribeAck}
import com.xebialabs.xlrelease.notifications.actor.NotificationServiceActor.{ClearCache, ClearCacheRequested}
import com.xebialabs.xlrelease.notifications.email.EmailNotificationsService

object NotificationServiceActor {

  val name = "notificationServiceActor"

  sealed trait EmailSettingsCacheCommand

  case class ClearCache() extends EmailSettingsCacheCommand

  case class ClearCacheRequested() extends EmailSettingsCacheCommand

}

trait NotificationServiceActor extends Actor with ActorLogging

class NonClusteredNotificationServiceActor(emailNotificationsService: EmailNotificationsService)
  extends NotificationServiceActor {
  override def receive: Receive = {
    case ClearCache() =>
      log.debug("Requesting to clean cache entries for EmailNotificationSettings")
      emailNotificationsService.clearCache()
  }
}

class ClusteredNotificationServiceActor(emailNotificationsService: EmailNotificationsService)
  extends NotificationServiceActor {
  val topicName = "notifications"
  val mediator: ActorRef = DistributedPubSub(context.system).mediator
  mediator ! Subscribe(topicName, self)

  override def receive: Receive = {
    case ClearCache() =>
      mediator ! Publish(topicName, ClearCacheRequested())
    case ClearCacheRequested() =>
      log.debug("Requesting to clean cache entries for EmailNotificationSettings")
      emailNotificationsService.clearCache()
    case SubscribeAck(Subscribe(topicName, None, _)) =>
      log.info(s"subscribing to topic '$topicName'")
  }
}
