/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.api.internal;

import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.notifications.api.internal.InvalidSmtpConfigException;
import com.xebialabs.xlrelease.notifications.configuration.SmtpServer;
import com.xebialabs.xlrelease.notifications.service.SmtpConfigurationService;
import com.xebialabs.xlrelease.security.PermissionChecker;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.commons.mail.EmailException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.reflect.ScalaSignature;

@Path(value="/settings/smtp")
@Produces(value={"application/json"})
@Controller
@ScalaSignature(bytes="\u0006\u000554A!\u0002\u0004\u0001'!A!\u0004\u0001B\u0001B\u0003%1\u0004\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003#\u0011\u0015A\u0003\u0001\"\u0001*\u0011\u0015i\u0004\u0001\"\u0001?\u00051\u0019V\u000e\u001e9SKN|WO]2f\u0015\t9\u0001\"\u0001\u0005j]R,'O\\1m\u0015\tI!\"A\u0002ba&T!a\u0003\u0007\u0002\u001b9|G/\u001b4jG\u0006$\u0018n\u001c8t\u0015\tia\"A\u0005yYJ,G.Z1tK*\u0011q\u0002E\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!E\u0001\u0004G>l7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011a!\u00118z%\u00164\u0017\u0001G:niB\u001cuN\u001c4jOV\u0014\u0018\r^5p]N+'O^5dKB\u0011AdH\u0007\u0002;)\u0011aDC\u0001\bg\u0016\u0014h/[2f\u0013\t\u0001SD\u0001\rT[R\u00048i\u001c8gS\u001e,(/\u0019;j_:\u001cVM\u001d<jG\u0016\f1\u0002]3s[&\u001c8/[8ogB\u00111EJ\u0007\u0002I)\u0011Q\u0005D\u0001\tg\u0016\u001cWO]5us&\u0011q\u0005\n\u0002\u0012!\u0016\u0014X.[:tS>t7\t[3dW\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0002+Y5\u0002\"a\u000b\u0001\u000e\u0003\u0019AQAG\u0002A\u0002mAQ!I\u0002A\u0002\tB#aA\u0018\u0011\u0005AZT\"A\u0019\u000b\u0005I\u001a\u0014AC1o]>$\u0018\r^5p]*\u0011A'N\u0001\bM\u0006\u001cGo\u001c:z\u0015\t1t'A\u0003cK\u0006t7O\u0003\u00029s\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001;\u0003\ry'oZ\u0005\u0003yE\u0012\u0011\"Q;u_^L'/\u001a3\u0002\u001f\rDWmY6T[R\u00048i\u001c8gS\u001e$\"a\u0010\"\u0011\u0005U\u0001\u0015BA!\u0017\u0005\u0011)f.\u001b;\t\u000b\r#\u0001\u0019\u0001#\u0002\u0015MlG\u000f]*feZ,'\u000f\u0005\u0002F\u00116\taI\u0003\u0002H\u0015\u0005i1m\u001c8gS\u001e,(/\u0019;j_:L!!\u0013$\u0003\u0015MkG\u000f]*feZ,'\u000f\u000b\u0002\u0005\u0017B\u0011AjU\u0007\u0002\u001b*\u0011ajT\u0001\u0003eNT!\u0001U)\u0002\u0005]\u001c(\"\u0001*\u0002\u000b)\fg/\u0019=\n\u0005Qk%\u0001\u0002)P'RCC\u0001\u0002,Z5B\u0011AjV\u0005\u000316\u0013A\u0001U1uQ\u0006)a/\u00197vK\u0006\n1,A\u0006dQ\u0016\u001c7nQ8oM&<\u0007\u0006\u0002\u0001W3v\u000b\u0013AX\u0001\u000f_M,G\u000f^5oON|3/\u001c;qQ\u0011\u0001\u0001-W2\u0011\u00051\u000b\u0017B\u00012N\u0005!\u0001&o\u001c3vG\u0016\u001cH&\u00013\"\u0003\u0015\f\u0001#\u00199qY&\u001c\u0017\r^5p]>R7o\u001c8)\u0005\u00019\u0007C\u00015l\u001b\u0005I'B\u000168\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0003Y&\u0014!bQ8oiJ|G\u000e\\3s\u0001")
public class SmtpResource {
    private final SmtpConfigurationService smtpConfigurationService;
    private final PermissionChecker permissions;

    @POST
    @Path(value="checkConfig")
    public void checkSmtpConfig(SmtpServer smtpServer) {
        this.permissions.check(PlatformPermissions.ADMIN);
        try {
            this.smtpConfigurationService.notifyTestEmail(smtpServer);
        }
        catch (EmailException e) {
            String exceptionMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new InvalidSmtpConfigException("Could not send test e-mail due to exception: " + exceptionMessage);
        }
    }

    @Autowired
    public SmtpResource(SmtpConfigurationService smtpConfigurationService, PermissionChecker permissions) {
        this.smtpConfigurationService = smtpConfigurationService;
        this.permissions = permissions;
    }
}

