/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.email;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache$;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.notifications.configuration.trigger.RecipientSettings;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.PrincipalInfoResolver;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.service.UserProfileService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.SetOps;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005]h\u0001B\u000b\u0017\u0001\u0005B\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\tc\u0001\u0011\t\u0011)A\u0005e!A\u0001\b\u0001B\u0001B\u0003%\u0011\b\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003>\u0011!\u0001\u0005A!A!\u0002\u0013\t\u0005\"B$\u0001\t\u0003A\u0005\"B0\u0001\t\u0003\u0001\u0007\"\u00028\u0001\t\u0003y\u0007\"B:\u0001\t\u0003!\b\"CA\u0012\u0001E\u0005I\u0011AA\u0013\u0011\u001d\tI\u0004\u0001C\u0005\u0003wAq!!\u0011\u0001\t\u0013\t\u0019\u0005C\u0004\u0002J\u0001!I!a\u0013\t\u000f\u0005E\u0004\u0001\"\u0003\u0002t!9\u0011Q\u0012\u0001\u0005\n\u0005=\u0005bBAQ\u0001\u0011%\u00111\u0015\u0005\b\u0003k\u0003A\u0011BA\\\u0011\u001d\t)\r\u0001C\u0005\u0003\u000fDq!!4\u0001\t\u0013\ty\rC\u0004\u0002Z\u0002!I!a7\u0003-\u0015k\u0017-\u001b7SK\u000eL\u0007/[3oiJ+7o\u001c7wKJT!a\u0006\r\u0002\u000b\u0015l\u0017-\u001b7\u000b\u0005eQ\u0012!\u00048pi&4\u0017nY1uS>t7O\u0003\u0002\u001c9\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003;y\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003}\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\u0012\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\r\u0005s\u0017PU3g\u0003-\u0011x\u000e\\3TKJ4\u0018nY3\u0011\u0005)zS\"A\u0016\u000b\u00051j\u0013\u0001C:fGV\u0014\u0018\u000e^=\u000b\u00059b\u0012\u0001\u00033fa2|\u00170\u001b;\n\u0005AZ#a\u0003*pY\u0016\u001cVM\u001d<jG\u0016\f1\u0002^3b[N+'O^5dKB\u00111GN\u0007\u0002i)\u0011QGG\u0001\bg\u0016\u0014h/[2f\u0013\t9DGA\u0006UK\u0006l7+\u001a:wS\u000e,\u0017AE;tKJ\u0004&o\u001c4jY\u0016\u001cVM\u001d<jG\u0016\u0004\"a\r\u001e\n\u0005m\"$AE+tKJ\u0004&o\u001c4jY\u0016\u001cVM\u001d<jG\u0016\fQ\u0003\u001d:j]\u000eL\u0007/\u00197J]\u001a|'+Z:pYZ,'\u000f\u0005\u00024}%\u0011q\b\u000e\u0002\u0016!JLgnY5qC2LeNZ8SKN|GN^3s\u0003%AHN]\"p]\u001aLw\r\u0005\u0002C\u000b6\t1I\u0003\u0002E5\u000511m\u001c8gS\u001eL!AR\"\u0003\u0013ac'oQ8oM&<\u0017A\u0002\u001fj]&$h\b\u0006\u0004J\u00172kej\u0014\t\u0003\u0015\u0002i\u0011A\u0006\u0005\u0006Q\u0019\u0001\r!\u000b\u0005\u0006c\u0019\u0001\rA\r\u0005\u0006q\u0019\u0001\r!\u000f\u0005\u0006y\u0019\u0001\r!\u0010\u0005\u0006\u0001\u001a\u0001\r!\u0011\u0015\u0003\rE\u0003\"AU/\u000e\u0003MS!\u0001V+\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002W/\u00069a-Y2u_JL(B\u0001-Z\u0003\u0015\u0011W-\u00198t\u0015\tQ6,A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005a\u0016aA8sO&\u0011al\u0015\u0002\n\u0003V$xn^5sK\u0012\f\u0001C]3t_24XMU3dSBLWM\u001c;\u0015\u0005\u0005d\u0007C\u00012j\u001d\t\u0019w\r\u0005\u0002eI5\tQM\u0003\u0002gA\u00051AH]8pizJ!\u0001\u001b\u0013\u0002\rA\u0013X\rZ3g\u0013\tQ7N\u0001\u0004TiJLgn\u001a\u0006\u0003Q\u0012BQ!\\\u0004A\u0002\u0005\fQ\u0002\u001d:j]\u000eL\u0007/\u00197OC6,\u0017\u0001\b:fg>dg/Z*zgR,W.\u00113nS:\u0014VmY5qS\u0016tGo\u001d\u000b\u0002aB\u0019!-]1\n\u0005I\\'aA*fi\u0006\t\"/Z:pYZ,'+Z2ja&,g\u000e^:\u0015\u0015A,\u0018\u0011AA\u0003\u0003\u0013\tI\u0002C\u0003w\u0013\u0001\u0007q/A\u0003s_2,7\u000fE\u0002y{\u0006t!!_>\u000f\u0005\u0011T\u0018\"A\u0013\n\u0005q$\u0013a\u00029bG.\fw-Z\u0005\u0003}~\u0014A\u0001T5ti*\u0011A\u0010\n\u0005\u0007\u0003\u0007I\u0001\u0019A<\u0002\u0017\u001ddwNY1m%>dWm\u001d\u0005\u0007\u0003\u000fI\u0001\u0019A<\u0002\u000bU\u001cXM]:\t\u000f\u0005-\u0011\u00021\u0001\u0002\u000e\u0005A\u0001\u000f\\1o\u0013R,W\u000e\u0005\u0003\u0002\u0010\u0005UQBAA\t\u0015\r\t\u0019BG\u0001\u0007I>l\u0017-\u001b8\n\t\u0005]\u0011\u0011\u0003\u0002\t!2\fg.\u0013;f[\"I\u00111D\u0005\u0011\u0002\u0003\u0007\u0011QD\u0001\u000eKb\u001cG.\u001e3f\u0003V$\bn\u001c:\u0011\u0007\r\ny\"C\u0002\u0002\"\u0011\u0012qAQ8pY\u0016\fg.A\u000esKN|GN^3SK\u000eL\u0007/[3oiN$C-\u001a4bk2$H%N\u000b\u0003\u0003OQC!!\b\u0002*-\u0012\u00111\u0006\t\u0005\u0003[\t)$\u0004\u0002\u00020)!\u0011\u0011GA\u001a\u0003%)hn\u00195fG.,GM\u0003\u0002UI%!\u0011qGA\u0018\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0016M&dG/\u001a:O_RLg-[1cY\u0016,6/\u001a:t)\r\u0001\u0018Q\b\u0005\u0007\u0003\u007fY\u0001\u0019\u00019\u0002\u0015A\u0014\u0018N\\2ja\u0006d7/\u0001\u0006o_RLg-_+tKJ$B!!\b\u0002F!1\u0011q\t\u0007A\u0002\u0005\f\u0001\"^:fe:\fW.Z\u0001\u000ba\u0006\u00148/\u001a*pY\u0016\u001cH#\u00039\u0002N\u0005e\u00131LA/\u0011\u001d\ty%\u0004a\u0001\u0003#\n1\"Y:tS\u001etW.\u001a8ugB!\u00010`A*!\rQ\u0013QK\u0005\u0004\u0003/Z#\u0001\u0002*pY\u0016DQA^\u0007A\u0002]Dq!a\u0003\u000e\u0001\u0004\ti\u0001C\u0004\u0002`5\u0001\r!!\u0019\u0002\u000b\r\f7\r[3\u0011\t\u0005\r\u0014QN\u0007\u0003\u0003KRA!a\u001a\u0002j\u0005A\u0011N\u001c;fe:\fGNC\u0002\u0002li\t1!\u00199j\u0013\u0011\ty'!\u001a\u0003\u001f\u0011+7m\u001c:bi>\u00148oQ1dQ\u0016\fqB]3qY\u0006\u001cWMV1sS\u0006\u0014G.\u001a\u000b\u0006C\u0006U\u0014\u0011\u0010\u0005\u0007\u0003or\u0001\u0019A1\u0002\u000bY\fG.^3\t\u000f\u0005md\u00021\u0001\u0002~\u0005Ia/\u0019:jC\ndWm\u001d\t\u0007\u0003\u007f\nI)Y1\u000e\u0005\u0005\u0005%\u0002BAB\u0003\u000b\u000bA!\u001e;jY*\u0011\u0011qQ\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\f\u0006\u0005%aA'ba\u0006q\u0001/\u0019:tKR\u000b7o\u001b*pY\u0016\u001cH#\u00039\u0002\u0012\u0006m\u0015QTAP\u0011\u001d\t\u0019j\u0004a\u0001\u0003+\u000bA\u0001^1tWB!\u0011qBAL\u0013\u0011\tI*!\u0005\u0003\tQ\u000b7o\u001b\u0005\u0006m>\u0001\ra\u001e\u0005\b\u0003\u001fz\u0001\u0019AA)\u0011\u001d\tyf\u0004a\u0001\u0003C\n\u0011\u0003]1sg\u0016\u0014V\r\\3bg\u0016\u0014v\u000e\\3t)%\u0001\u0018QUAX\u0003c\u000b\u0019\fC\u0004\u0002(B\u0001\r!!+\u0002\u000fI,G.Z1tKB!\u0011qBAV\u0013\u0011\ti+!\u0005\u0003\u000fI+G.Z1tK\")a\u000f\u0005a\u0001o\"9\u0011q\n\tA\u0002\u0005E\u0003bBA0!\u0001\u0007\u0011\u0011M\u0001\u0012O\u0016$(+\u001a7fCN,W*Z7cKJ\u001cH\u0003CA]\u0003\u007f\u000b\t-a1\u0011\t\r\nY\f]\u0005\u0004\u0003{##AB(qi&|g\u000eC\u0004\u0002(F\u0001\r!!+\t\u000f\u0005=\u0013\u00031\u0001\u0002R!9\u0011qL\tA\u0002\u0005\u0005\u0014\u0001\u00059beN,w\t\\8cC2\u0014v\u000e\\3t)\u00159\u0018\u0011ZAf\u0011\u001d\tyE\u0005a\u0001\u0003#Ba!a\u0001\u0013\u0001\u00049\u0018\u0001\u00059beN,gi\u001c7eKJ$V-Y7t)%\u0001\u0018\u0011[Aj\u0003+\f9\u000eC\u0004\u0002PM\u0001\r!!\u0015\t\u000bY\u001c\u0002\u0019A<\t\u000f\u0005-1\u00031\u0001\u0002\u000e!9\u0011qL\nA\u0002\u0005\u0005\u0014!D4fi\u0006cG.T3nE\u0016\u00148\u000fF\u0003q\u0003;\f9\u000fC\u0004\u0002`R\u0001\r!!9\u0002\tQ,\u0017-\u001c\t\u0005\u0003\u001f\t\u0019/\u0003\u0003\u0002f\u0006E!\u0001\u0002+fC6Dq!a\u0014\u0015\u0001\u0004\t\t\u0006K\u0002\u0001\u0003W\u0004B!!<\u0002t6\u0011\u0011q\u001e\u0006\u0004\u0003cL\u0016AC:uKJ,w\u000e^=qK&!\u0011Q_Ax\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class EmailRecipientResolver {
    private final RoleService roleService;
    private final TeamService teamService;
    private final UserProfileService userProfileService;
    private final PrincipalInfoResolver principalInfoResolver;
    private final XlrConfig xlrConfig;

    public String resolveRecipient(String principalName) {
        return this.principalInfoResolver.getNotificationEmailOf(principalName);
    }

    public Set<String> resolveSystemAdminRecipients() {
        List adminRoles = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.roleService.getRolesForPermission(PlatformPermissions.ADMIN.getPermissionName())).asScala().map((Function1 & Serializable)x$1 -> x$1.getName())).toList();
        List assignments = CollectionConverters$.MODULE$.ListHasAsScala(this.roleService.readRoleAssignments()).asScala().toList();
        Set allPrincipals = (Set)this.parseGlobalRoles((List<Role>)assignments, (List<String>)adminRoles).toSet().$plus((Object)"admin");
        return this.filterNotifiableUsers((Set<String>)allPrincipals);
    }

    public Set<String> resolveRecipients(List<String> roles, List<String> globalRoles, List<String> users, PlanItem planItem, boolean excludeAuthor) {
        List assignments = CollectionConverters$.MODULE$.ListHasAsScala(this.roleService.readRoleAssignments()).asScala().toList();
        DecoratorsCache cache = new DecoratorsCache(DecoratorsCache$.MODULE$.$lessinit$greater$default$1());
        Set allPrincipals = (Set)((SetOps)this.parseRoles((List<Role>)assignments, roles, planItem, cache).$plus$plus(this.parseGlobalRoles((List<Role>)assignments, globalRoles)).$plus$plus(this.parseFolderTeams((List<Role>)assignments, roles, planItem, cache)).$plus$plus(users)).$minus$minus((IterableOnce)(excludeAuthor ? (IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{User.AUTHENTICATED_USER.getName()})) : Nil$.MODULE$));
        return this.filterNotifiableUsers((Set<String>)allPrincipals);
    }

    public boolean resolveRecipients$default$5() {
        return false;
    }

    private Set<String> filterNotifiableUsers(Set<String> principals) {
        return (Set)((IterableOps)((IterableOps)principals.filter((Function1 & Serializable)username -> BoxesRunTime.boxToBoolean((boolean)this.notifyUser(username)))).map((Function1 & Serializable)x$1 -> $this.principalInfoResolver.getNotificationEmailOf(x$1))).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$filterNotifiableUsers$3(x$2)));
    }

    private boolean notifyUser(String username) {
        UserProfile profile = this.userProfileService.findByUsername(username);
        if (profile != null) {
            return profile.isLoginAllowed() || this.xlrConfig.isNotifyInactiveUsers();
        }
        return true;
    }

    private Set<String> parseRoles(List<Role> assignments, List<String> roles, PlanItem planItem, DecoratorsCache cache) {
        PlanItem planItem2 = planItem;
        if (planItem2 instanceof Task) {
            Task task = (Task)planItem2;
            return this.parseTaskRoles(task, roles, assignments, cache);
        }
        if (planItem2 instanceof Release) {
            Release release = (Release)planItem2;
            return this.parseReleaseRoles(release, roles, assignments, cache);
        }
        throw new MatchError((Object)planItem2);
    }

    private String replaceVariable(String value, Map<String, String> variables) {
        if (VariableHelper$.MODULE$.containsVariables(value)) {
            return VariableHelper$.MODULE$.replaceAll(value, variables);
        }
        return value;
    }

    private Set<String> parseTaskRoles(Task task, List<String> roles, List<Role> assignments, DecoratorsCache cache) {
        ObjectRef parsed;
        block3: {
            parsed = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
            boolean shouldSendToTaskOwner = roles.contains((Object)"Task Owner");
            Option taskOwner = Option$.MODULE$.apply((Object)task.getOwner());
            if (shouldSendToTaskOwner && taskOwner.isDefined()) {
                parsed.elem = (Set)((Set)parsed.elem).$plus((Object)this.replaceVariable((String)taskOwner.get(), task.getRelease().getAllStringVariableValues()));
            }
            if (roles.contains((Object)"Task Team") || shouldSendToTaskOwner && taskOwner.isEmpty()) {
                OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(this.teamService.findTeamByName(Ids.releaseIdFrom((String)task.getId()), task.getTeam()))).foreach((Function1 & Serializable)x$4 -> {
                    parsed.elem = (Set)((Set)parsed.elem).$plus$plus(this.getAllMembers(x$4, (List<Role>)assignments));
                    return BoxedUnit.UNIT;
                });
            }
            if (roles.contains((Object)RecipientSettings.RELEASE_ADMIN_ROLE_NAME)) {
                parsed.elem = (Set)((Set)parsed.elem).$plus$plus((IterableOnce)this.getReleaseMembers(task.getRelease(), assignments, cache).getOrElse((Function0 & Serializable)() -> Nil$.MODULE$));
            }
            if (!roles.contains((Object)"Watcher")) break block3;
            Set watchers = CollectionConverters$.MODULE$.SetHasAsScala(task.getWatchers()).asScala().toSet();
            watchers.foreach((Function1 & Serializable)x$5 -> {
                parsed.elem = (Set)((Set)parsed.elem).$plus((Object)this.replaceVariable(x$5, task.getRelease().getAllStringVariableValues()));
                return BoxedUnit.UNIT;
            });
        }
        return (Set)parsed.elem;
    }

    private Set<String> parseReleaseRoles(Release release, List<String> roles, List<Role> assignments, DecoratorsCache cache) {
        Set parsed;
        block0: {
            parsed = Predef$.MODULE$.Set().empty();
            if (!roles.contains((Object)RecipientSettings.RELEASE_ADMIN_ROLE_NAME)) break block0;
            parsed = (Set)parsed.$plus$plus((IterableOnce)this.getReleaseMembers(release, assignments, cache).getOrElse((Function0 & Serializable)() -> Nil$.MODULE$));
        }
        return parsed;
    }

    private Option<Set<String>> getReleaseMembers(Release release, List<Role> assignments, DecoratorsCache cache) {
        Option effectiveTeams = CollectionConverters$.MODULE$.ListHasAsScala(this.teamService.getEffectiveTeams(release, cache)).asScala().find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$getReleaseMembers$1(x$6)));
        return effectiveTeams.map((Function1 & Serializable)x$7 -> this.getAllMembers((Team)x$7, assignments));
    }

    private List<String> parseGlobalRoles(List<Role> assignments, List<String> globalRoles) {
        List<String> list = globalRoles;
        if (Nil$.MODULE$.equals(list)) {
            return Nil$.MODULE$;
        }
        return assignments.filter((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)globalRoles.contains((Object)r.getName()))).flatMap((Function1 & Serializable)x$8 -> CollectionConverters$.MODULE$.ListHasAsScala(x$8.getPrincipals()).asScala().toList());
    }

    private Set<String> parseFolderTeams(List<Role> assignments, List<String> roles, PlanItem planItem, DecoratorsCache cache) {
        ObjectRef parsed;
        block0: {
            parsed = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
            List folderTeams = (List)roles.diff((Seq)new .colon.colon((Object)RecipientSettings.RELEASE_ADMIN_ROLE_NAME, (List)new .colon.colon((Object)"Task Owner", (List)new .colon.colon((Object)"Task Team", (List)new .colon.colon((Object)"Watcher", (List)Nil$.MODULE$)))));
            String folderId = Ids.findFolderId((String)planItem.getId());
            if (!Strings.isNotEmpty((String)folderId) || Ids.isRoot((String)folderId)) break block0;
            this.teamService.findTeamsByNames(folderId, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)folderTeams).asJava(), cache).forEach(x$9 -> {
                parsed$2.elem = (Set)((Set)parsed$2.elem).$plus$plus(this.getAllMembers((Team)x$9, assignments));
            });
        }
        return (Set)parsed.elem;
    }

    private Set<String> getAllMembers(Team team, List<Role> assignments) {
        Set teamMembers = CollectionConverters$.MODULE$.ListHasAsScala(team.getMembers()).asScala().toSet();
        List roleMembers = CollectionConverters$.MODULE$.ListHasAsScala(team.getRoles()).asScala().toList().flatMap((Function1 & Serializable)roleName -> assignments.find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$getAllMembers$2(roleName, x$10))).toList().flatMap((Function1 & Serializable)role -> CollectionConverters$.MODULE$.ListHasAsScala(role.getPrincipals()).asScala().toList().map((Function1 & Serializable)principal -> {
            $this.userProfileService.discover(principal);
            return principal;
        })));
        return (Set)teamMembers.$plus$plus((IterableOnce)roleMembers);
    }

    public static final /* synthetic */ boolean $anonfun$filterNotifiableUsers$3(String x$2) {
        return Option$.MODULE$.apply((Object)x$2).exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$3.trim()))));
    }

    public static final /* synthetic */ boolean $anonfun$getReleaseMembers$1(Team x$6) {
        String string = x$6.getTeamName();
        String string2 = "Release Admin";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getAllMembers$2(String roleName$1, Role x$10) {
        String string = x$10.getName();
        String string2 = roleName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Autowired
    public EmailRecipientResolver(RoleService roleService, TeamService teamService, UserProfileService userProfileService, PrincipalInfoResolver principalInfoResolver, XlrConfig xlrConfig) {
        this.roleService = roleService;
        this.teamService = teamService;
        this.userProfileService = userProfileService;
        this.principalInfoResolver = principalInfoResolver;
        this.xlrConfig = xlrConfig;
    }
}

