package com.xebialabs.xlrelease.notifications.handlers

import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.domain.status.FlagStatus
import com.xebialabs.xlrelease.events.{AsyncSubscribe, EventListener}
import com.xebialabs.xlrelease.notifications._
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._


@Component
@EventListener
class ReleaseNotificationEventHandler @Autowired()(notificationService: NotificationService) {

  @AsyncSubscribe
  def onReleaseUpdated(event: ReleaseUpdatedEvent): Unit = {
    val (original, updated) = (event.original, event.updated)

    if (original.getFlagStatus != updated.getFlagStatus && updated.getFlagStatus != FlagStatus.OK) {
      notificationService.notify(ReleaseFlagged(updated))
    }
  }

  @AsyncSubscribe
  def onReleaseStarted(event: ReleaseStartedEvent): Unit = {
    if (!event.isPartOfBulkOperation) {
      notificationService.notify(ReleaseStarted(event.release))
    }
  }

  @AsyncSubscribe
  def onReleaseBulkStarted(event: ReleaseBulkStartedEvent): Unit = {
    notificationService.notify(ReleaseStarted(event.releases.asScala.toList))
  }

  @AsyncSubscribe
  def onReleaseAborted(event: ReleaseAbortedEvent): Unit = {
    if (!event.isPartOfBulkOperation) {
      notificationService.notify(ReleaseAborted(event.release))
    }
  }

  @AsyncSubscribe
  def onReleaseBulkAborted(event: ReleaseBulkAbortedEvent): Unit = {
    notificationService.notify(ReleaseAborted(event.releases.asScala.toList))
  }

  @AsyncSubscribe
  def onReleaseCompleted(event: ReleaseCompletedEvent): Unit = {
    notificationService.notify(ReleaseCompleted(event.release))
  }

  @AsyncSubscribe
  def onReleaseFailed(event: ReleaseFailedEvent): Unit = {
    notificationService.notify(ReleaseFailed(event.release))
  }

  @AsyncSubscribe
  def onReleaseFailing(event: ReleaseStartedFailingEvent): Unit = {
    notificationService.notify(ReleaseFailing(event.release))
  }
}
