package com.xebialabs.xlrelease.notifications.initialize

import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.repository.Ids.ROOT_FOLDER_ID
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow.Root
import com.xebialabs.xlrelease.repository.sql.persistence.{FolderPersistence, ReleasePersistence}
import com.xebialabs.xlrelease.security.sql.snapshots.service.PermissionsSnapshotService
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.common.BaseInitializingUpgrade
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired

class XLRelease100PermissionSnapshotUpgrader @Autowired()(
                                                           permissionsSnapshotService: PermissionsSnapshotService,
                                                           folderPersistence: FolderPersistence,
                                                           releasePersistence: ReleasePersistence)
  extends BaseInitializingUpgrade with Logging {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "10.0.0#3")

  def createInitialGlobalPermissionSnapshot(): Unit = {
    logger.info("Creating global permissions snapshot")
    try {
      permissionsSnapshotService.makeSnapshot()
      logger.info("Global permissions snapshot created")
    } catch {
      case e: Exception => logger.error("Unable to create global permissions snapshot", e)
    }
  }

  def createInitialFolderPermissionSnapshots(): Unit = {
    val folderIds = folderPersistence.findDescendantsById(ROOT_FOLDER_ID, Int.MaxValue)
      .map(_.folderId)
      .filter(!_.isEmpty)
      .map(_.path)

    folderIds.foreach(folderId => {
      logger.info(s"Creating permissions snapshot for folder [${folderId}]")
      try {
        permissionsSnapshotService.makeSnapshot(Some(folderId))
        logger.info(s"Permissions snapshot for folder [${folderId}] created")
      } catch {
        case e: Exception => logger.error(s"Unable to create permissions snapshot for folder [${folderId}]", e)
      }
    })
  }

  def createInitialFolderlessReleasesPermissionSnapshots(): Unit = {
    val releaseIds = releasePersistence.findReleaseIdsByFolderCiUid(Root.uid)
    releaseIds.foreach(releaseId => {
      logger.info(s"Creating permissions snapshot for root release [${releaseId}]")
      try {
        permissionsSnapshotService.makeSnapshot(Some(releaseId))
        logger.info(s"Permissions snapshot for root release [${releaseId}] created")
      } catch {
        case e: Exception => logger.error(s"Unable to create permissions snapshot for root release [${releaseId}]", e)
      }
    })
  }

  override def doUpgrade(): Boolean = {
    createInitialGlobalPermissionSnapshot()
    createInitialFolderPermissionSnapshots()
    createInitialFolderlessReleasesPermissionSnapshots()
    true
  }
}
