package com.xebialabs.xlrelease.notifications.configuration

import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}

import java.util.Date
import scala.beans.BeanProperty

@Metadata(label = "Authentication Method", virtual = true)
abstract class SmtpAuthentication extends BaseConfigurationItem

@Metadata(label = "No authentication")
class NoSmtpAuthentication extends SmtpAuthentication

@Metadata(label = "Username and password")
class BasicSmtpAuthentication extends SmtpAuthentication {
  @BeanProperty
  @Property(description = "The SMTP server login username")
  var username: String = _

  @BeanProperty
  @Property(description = "The SMTP server login password", password = true)
  var password: String = _
}

@Metadata(label = "OAuth 2.0")
class OAuth2SmtpAuthentication extends SmtpAuthentication {
  @BeanProperty
  @Property(description = "The endpoint of the authentication server", label = "Access Token URL")
  var accessTokenUrl: String = _

  @BeanProperty
  @Property(description = "The client identifier issued to the client during the Application registration process", label = "Client ID")
  var clientId: String = _

  @BeanProperty
  @Property(description = "The client secret issued to the client during the Application registration process", password = true)
  var clientSecret: String = _

  @BeanProperty
  @Property(description = "The access token issued by the authorization server", password = true, required = false, category = "INTERNAL")
  var accessToken: String = _

  @BeanProperty
  @Property(description = "The refresh token, which can be used to obtain new access tokens", password = true)
  var refreshToken: String = _

  @BeanProperty
  @Property(description = "The lifetime in seconds of the access token", required = false, category = "INTERNAL")
  var expiresAt: Date = _

  @BeanProperty
  @Property(defaultValue = "Bearer", description = "The type of the token issued", hidden = true, required = false)
  var tokenType: String = _
}
