package com.xebialabs.xlrelease.notifications.initialize

import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.notifications.TriggerType.USER_TOKEN_ABOUT_TO_EXPIRE
import com.xebialabs.xlrelease.notifications.configuration.EmailNotificationSettings
import com.xebialabs.xlrelease.notifications.configuration.EmailNotificationSettings.GLOBAL_EMAIL_NOTIFICATION_SETTINGS_ID
import com.xebialabs.xlrelease.notifications.configuration.trigger.NotificationTriggerSettings
import com.xebialabs.xlrelease.notifications.initialize.EmailNotificationSettingsInitializer.notificationTriggerSettings
import com.xebialabs.xlrelease.service.ConfigurationService
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.common.BaseInitializingUpgrade
import grizzled.slf4j.Logging

class XLRelease230UserTokenEmailNotificationsUpgrade(configurationService: ConfigurationService)
  extends BaseInitializingUpgrade with Logging {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "23.1.0#2")

  override def doUpgrade(): Boolean = {
    val emailSettings = configurationService.read(GLOBAL_EMAIL_NOTIFICATION_SETTINGS_ID).asInstanceOf[EmailNotificationSettings]

    userTokenNotificationSettings.foreach { settings =>
      emailSettings.setNotificationTriggerSettings(settings)
    }

    logger.info("Adding notification settings for user token")

    configurationService.createOrUpdate(emailSettings)
    true
  }

  private val userTokenNotificationSettings: List[NotificationTriggerSettings] = List(
    notificationTriggerSettings(
      USER_TOKEN_ABOUT_TO_EXPIRE,
      subject = "[Release] Your personal access token is about to expire",
      body =
        """
          | Your personal access token "'${token.tokenNote}'" will expire in about ${token.expirationDurationInHours} hours.
          |
          | If this token is still needed, visit [Access tokens](${url}#/personal-access-token) to generate an equivalent.
          """.stripMargin.trim)
  )
}


