package com.xebialabs.xlrelease.notifications.api.internal

import com.xebialabs.deployit.engine.spi.exception.{DeployitException, HttpResponseCodeResult}
import com.xebialabs.deployit.security.permission.PlatformPermissions.ADMIN
import com.xebialabs.xlrelease.notifications.configuration.SmtpServer
import com.xebialabs.xlrelease.notifications.service.SmtpConfigurationService
import com.xebialabs.xlrelease.security.PermissionChecker
import org.apache.commons.mail.EmailException
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Controller

import javax.ws.rs.core.MediaType.APPLICATION_JSON
import javax.ws.rs.{POST, Path, Produces}

@Path("/settings/smtp")
@Produces(Array(APPLICATION_JSON))
@Controller
class SmtpResource @Autowired()(smtpConfigurationService: SmtpConfigurationService,
                                permissions: PermissionChecker) {

  @POST
  @Path("checkConfig")
  def checkSmtpConfig(smtpServer: SmtpServer): Unit = {
    permissions.check(ADMIN)
    try {
      smtpConfigurationService.notifyTestEmail(smtpServer)
    } catch {
      case e: EmailException => {
        val exceptionMessage = if (e.getCause != null) e.getCause.getMessage else e.getMessage
        throw new InvalidSmtpConfigException(s"Could not send test e-mail due to exception: $exceptionMessage");
      }
    }
  }

  @HttpResponseCodeResult(statusCode = 400)
  case class InvalidSmtpConfigException(message: String) extends DeployitException(message) {
  }

}
