package com.xebialabs.xlrelease.notifications.email

import com.xebialabs.xlrelease.notifications.TriggerType._

package object templates {
  type SingleActionTemplate = String
  type BulkActionTemplate = String
  type MustacheTemplates = (SingleActionTemplate, BulkActionTemplate)
  type TemplatesForTriggerType = Map[TriggerType, MustacheTemplates]

  val TEMPLATE_LOCATION = "emails"
  val RELEASE_TEMPLATE = "release-template.mustache"
  val BULK_RELEASES_TEMPLATE = "bulk-releases-template.mustache"
  val TASK_TEMPLATE = "task-template.mustache"
  val MENTION_TEMPLATE = "mention-template.mustache"

  val AUDIT_REPORT_TEMPLATE = "audit-report-template.mustache"
  val AUDIT_REPORT_FAILED_TEMPLATE = "audit-report-failed-template.mustache"

  val TRIGGER_TYPE_GROUPS: TemplatesForTriggerType = Map(
    RELEASE_COMPLETED -> (RELEASE_TEMPLATE, null),
    RELEASE_FLAGGED -> (RELEASE_TEMPLATE, null),
    RELEASE_FAILING -> (RELEASE_TEMPLATE, null),
    RELEASE_FAILED -> (RELEASE_TEMPLATE, null),

    RELEASE_STARTED -> (RELEASE_TEMPLATE, BULK_RELEASES_TEMPLATE),
    RELEASE_ABORTED -> (RELEASE_TEMPLATE, BULK_RELEASES_TEMPLATE),

    COMMENT_ADDED -> (TASK_TEMPLATE, null),
    USER_MENTIONED -> (MENTION_TEMPLATE, null),
    ACTIVE_TASK_ASSIGNED -> (TASK_TEMPLATE, null),
    ACTIVE_TASK_UNASSIGNED -> (TASK_TEMPLATE, null),
    MANUAL_TASK_STARTED -> (TASK_TEMPLATE, null),
    TASK_FAILED -> (TASK_TEMPLATE, null),
    TASK_OVERDUE -> (TASK_TEMPLATE, null),
    TASK_WAITING_FOR_INPUT -> (TASK_TEMPLATE, null),
    MANUAL_TASK_STARTED_WITHOUT_OWNER -> (TASK_TEMPLATE, null),
    TASK_FLAGGED -> (TASK_TEMPLATE, null),
    TASK_DUE_SOON -> (TASK_TEMPLATE, null),

    AUDIT_REPORT_JOB_COMPLETED -> (AUDIT_REPORT_TEMPLATE, null),
    AUDIT_REPORT_JOB_FAILED -> (AUDIT_REPORT_FAILED_TEMPLATE, null),
    AUDIT_REPORT_JOB_ABORTED -> (AUDIT_REPORT_FAILED_TEMPLATE, null)
  )
}
