/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.workers;

import com.google.common.base.Strings;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.FailureReasons;
import com.xebialabs.xlrelease.domain.NotificationTask;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.notifications.email.ContextHelper;
import com.xebialabs.xlrelease.notifications.email.Email;
import com.xebialabs.xlrelease.notifications.email.EmailSender;
import com.xebialabs.xlrelease.notifications.email.templates.Templater$;
import com.xebialabs.xlrelease.scheduler.Job;
import com.xebialabs.xlrelease.scheduler.NotificationTaskJob;
import com.xebialabs.xlrelease.scheduler.workers.Worker;
import com.xebialabs.xlrelease.script.TaskSoftReference;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.utils.MarkdownProcessor;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@ScalaSignature(bytes="\u0006\u0005U4Aa\u0002\u0005\u0001'!A1\u0006\u0001B\u0001B\u0003%A\u0006\u0003\u00053\u0001\t\u0005\t\u0015!\u00034\u0011!I\u0004A!A!\u0002\u0013Q\u0004\"B\u001f\u0001\t\u0003q\u0004\"\u0002#\u0001\t\u0003*\u0005\"\u0002.\u0001\t\u0013Y&A\u0006(pi&4\u0017nY1uS>tG+Y:l/>\u00148.\u001a:\u000b\u0005%Q\u0011aB<pe.,'o\u001d\u0006\u0003\u00171\tQB\\8uS\u001aL7-\u0019;j_:\u001c(BA\u0007\u000f\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u0010!\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002#\u0005\u00191m\\7\u0004\u0001M!\u0001\u0001\u0006\u000f$!\t)\"$D\u0001\u0017\u0015\t9\u0002$\u0001\u0003mC:<'\"A\r\u0002\t)\fg/Y\u0005\u00037Y\u0011aa\u00142kK\u000e$\bCA\u000f\"\u001b\u0005q\"BA\u0005 \u0015\t\u0001C\"A\u0005tG\",G-\u001e7fe&\u0011!E\b\u0002\u0007/>\u00148.\u001a:\u0011\u0005\u0011JS\"A\u0013\u000b\u0005\u0019:\u0013!B:mMRR'\"\u0001\u0015\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!AK\u0013\u0003\u000f1{wmZ5oO\u0006\u0019\"/\u001a7fCN,\u0017i\u0019;peN+'O^5dKB\u0011Q\u0006M\u0007\u0002])\u0011q\u0006D\u0001\u0007C\u000e$xN]:\n\u0005Er#a\u0005*fY\u0016\f7/Z!di>\u00148+\u001a:wS\u000e,\u0017!D2p]R,\u0007\u0010\u001e%fYB,'\u000f\u0005\u00025o5\tQG\u0003\u00027\u0015\u0005)Q-\\1jY&\u0011\u0001(\u000e\u0002\u000e\u0007>tG/\u001a=u\u0011\u0016d\u0007/\u001a:\u0002\u0017\u0015l\u0017-\u001b7TK:$WM\u001d\t\u0003imJ!\u0001P\u001b\u0003\u0017\u0015k\u0017-\u001b7TK:$WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\t}\n%i\u0011\t\u0003\u0001\u0002i\u0011\u0001\u0003\u0005\u0006W\u0011\u0001\r\u0001\f\u0005\u0006e\u0011\u0001\ra\r\u0005\u0006s\u0011\u0001\rAO\u0001\bKb,7-\u001e;f+\u00051\u0005CA$X\u001d\tAUK\u0004\u0002J):\u0011!j\u0015\b\u0003\u0017Js!\u0001T)\u000f\u00055\u0003V\"\u0001(\u000b\u0005=\u0013\u0012A\u0002\u001fs_>$h(C\u0001\u0012\u0013\ty\u0001#\u0003\u0002\u000e\u001d%\u0011\u0001\u0005D\u0005\u0003\u0013}I!A\u0016\u0010\u0002\r]{'o[3s\u0013\tA\u0016L\u0001\u0006Fq\u0016\u001cW\u000f^3K_\nT!A\u0016\u0010\u0002!M,g\u000e\u001a(pi&4\u0017nY1uS>tGC\u0001/c!\ti\u0006-D\u0001_\u0015\u0005y\u0016!B:dC2\f\u0017BA1_\u0005\u0011)f.\u001b;\t\u000b\r4\u0001\u0019\u00013\u0002\tQ\f7o\u001b\t\u0003K\"l\u0011A\u001a\u0006\u0003O2\ta\u0001Z8nC&t\u0017BA5g\u0005Aqu\u000e^5gS\u000e\fG/[8o)\u0006\u001c8\u000e\u000b\u0002\u0001WB\u0011An]\u0007\u0002[*\u0011an\\\u0001\u000bgR,'/Z8usB,'B\u00019r\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001:\u0002\u0007=\u0014x-\u0003\u0002u[\nI1i\\7q_:,g\u000e\u001e")
public class NotificationTaskWorker
implements Worker {
    private final ReleaseActorService releaseActorService;
    private final ContextHelper contextHelper;
    private final EmailSender emailSender;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public int getOrder() {
        return Worker.getOrder$((Worker)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        NotificationTaskWorker notificationTaskWorker = this;
        synchronized (notificationTaskWorker) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public PartialFunction<Job, BoxedUnit> execute() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ NotificationTaskWorker $outer;

            public final <A1 extends Job, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof NotificationTaskJob) {
                    NotificationTaskJob notificationTaskJob = (NotificationTaskJob)A1;
                    TaskSoftReference taskRef = notificationTaskJob.taskRef();
                    NotificationTask task = (NotificationTask)taskRef.get();
                    this.$outer.com$xebialabs$xlrelease$notifications$workers$NotificationTaskWorker$$sendNotification(task);
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Job x1) {
                Job job = x1;
                return job instanceof NotificationTaskJob;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public void com$xebialabs$xlrelease$notifications$workers$NotificationTaskWorker$$sendNotification(NotificationTask task) {
        scala.collection.immutable.Map context = (scala.collection.immutable.Map)this.contextHelper.baseContext().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"body"), MarkdownProcessor.process((String)task.getBody()).orElse(null)));
        String body = Templater$.MODULE$.processTemplate("notification-task-template.mustache", CollectionConverters$.MODULE$.MapHasAsJava((Map)context).asJava());
        Email email = new Email(task.getAddresses(), task.getSubject(), body);
        email.withPriority(task.getPriority()).withReplyTo(task.getReplyTo()).withCc(task.getCc()).withBcc(task.getBcc()).withFrom(task.getFrom()).withSenderUsername(task.getSenderUsername()).withSenderPassword(task.getSenderPassword());
        List list = ((MapOps)((IterableOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"To"), (Object)BoxesRunTime.boxToBoolean((boolean)task.getAddresses().isEmpty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Subject"), (Object)BoxesRunTime.boxToBoolean((boolean)Strings.isNullOrEmpty((String)task.getSubject()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Body"), (Object)BoxesRunTime.boxToBoolean((boolean)Strings.isNullOrEmpty((String)task.getBody())))}))).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1._2$mcZ$sp()))).keys().toList();
        if (Nil$.MODULE$.equals(list)) {
            Failure failure;
            Throwable e;
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.emailSender.sendEmailSync(email));
            if (try_ instanceof Success) {
                this.releaseActorService.markTaskAsDone(TaskStatus.COMPLETED, task.getId(), null, User.SYSTEM);
            } else if (try_ instanceof Failure && (e = (failure = (Failure)try_).exception()) != null) {
                Throwable throwable = e;
                this.releaseActorService.failTaskAsync(task.getId(), FailureReasons.NOTIFICATION_TASK_FAILED.format(new Object[]{throwable.getMessage()}), User.SYSTEM, this.releaseActorService.failTaskAsync$default$4());
            } else {
                throw new MatchError((Object)try_);
            }
            return;
        }
        String errorMessage = "The required fields [" + list.mkString(", ") + "] are missed";
        this.logger().warn((Function0 & Serializable)() -> "Email not sent for notification task '" + task.getId() + "'. " + errorMessage);
        this.releaseActorService.failTaskAsync(task.getId(), FailureReasons.NOTIFICATION_TASK_FAILED.format(new Object[]{errorMessage}), User.SYSTEM, this.releaseActorService.failTaskAsync$default$4());
    }

    public NotificationTaskWorker(ReleaseActorService releaseActorService, ContextHelper contextHelper, EmailSender emailSender) {
        this.releaseActorService = releaseActorService;
        this.contextHelper = contextHelper;
        this.emailSender = emailSender;
        Logging.$init$((Logging)this);
        Worker.$init$((Worker)this);
    }
}

