package com.xebialabs.xlrelease.notifications.views.converters;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.notifications.configuration.EmailNotificationSettings;
import com.xebialabs.xlrelease.notifications.views.EmailNotificationSettingsView;

public class EmailNotificationSettingsConverter {

    public static EmailNotificationSettingsView toView(EmailNotificationSettings settings) {
        return new EmailNotificationSettingsView(settings.getId(), settings.getFolderId(), settings.getNotificationTriggerSettings());
    }

    public static EmailNotificationSettings fromView(EmailNotificationSettingsView view) {
        EmailNotificationSettings settings = Type.valueOf(EmailNotificationSettings.class).getDescriptor().newInstance(view.getId());
        settings.setFolderId(view.getFolderId());
        settings.setNotificationTriggerSettings(view.getEmailNotificationSettings());
        return settings;
    }
}
