/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.handlers;

import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.TaskDueSoonEvent;
import com.xebialabs.xlrelease.domain.events.TaskFailedEvent;
import com.xebialabs.xlrelease.domain.events.TaskOverdueEvent;
import com.xebialabs.xlrelease.domain.events.TaskRetriedEvent;
import com.xebialabs.xlrelease.domain.events.TaskStartedEvent;
import com.xebialabs.xlrelease.domain.events.TaskUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TaskWaitingForInputEvent;
import com.xebialabs.xlrelease.domain.status.FlagStatus;
import com.xebialabs.xlrelease.events.AsyncSubscribe;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.notifications.ActiveTaskAssigned;
import com.xebialabs.xlrelease.notifications.ActiveTaskUnassigned;
import com.xebialabs.xlrelease.notifications.ManualTaskStarted;
import com.xebialabs.xlrelease.notifications.ManualTaskStartedWithoutAssignee;
import com.xebialabs.xlrelease.notifications.NotificationService;
import com.xebialabs.xlrelease.notifications.TaskDueSoon;
import com.xebialabs.xlrelease.notifications.TaskFailed;
import com.xebialabs.xlrelease.notifications.TaskFlagged;
import com.xebialabs.xlrelease.notifications.TaskOverdue;
import com.xebialabs.xlrelease.notifications.TaskWaitingForInput;
import com.xebialabs.xlrelease.notifications.UserMentioned;
import com.xebialabs.xlrelease.notifications.mentions.Mentions$;
import com.xebialabs.xlrelease.notifications.package$;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Component
@EventListener
@ScalaSignature(bytes="\u0006\u0005\u0005\rb\u0001B\u0007\u000f\u0001eA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!\t\u0005\u0006K\u0001!\tA\n\u0005\u0006s\u0001!\tA\u000f\u0005\u0006\u001d\u0002!Ia\u0014\u0005\u0006#\u0002!IA\u0015\u0005\u0006)\u0002!\t!\u0016\u0005\u00067\u0002!\t\u0001\u0018\u0005\u0006E\u0002!\ta\u0019\u0005\u0006S\u0002!\tA\u001b\u0005\u0006a\u0002!\t!\u001d\u0005\u0006o\u0002!\t\u0001\u001f\u0005\u0006}\u0002!Ia \u0002\u001d)\u0006\u001c8NT8uS\u001aL7-\u0019;j_:,e/\u001a8u\u0011\u0006tG\r\\3s\u0015\ty\u0001#\u0001\u0005iC:$G.\u001a:t\u0015\t\t\"#A\u0007o_RLg-[2bi&|gn\u001d\u0006\u0003'Q\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005U1\u0012!\u0003=fE&\fG.\u00192t\u0015\u00059\u0012aA2p[\u000e\u00011C\u0001\u0001\u001b!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u0019\te.\u001f*fM\u0006\u0019bn\u001c;jM&\u001c\u0017\r^5p]N+'O^5dKB\u0011!eI\u0007\u0002!%\u0011A\u0005\u0005\u0002\u0014\u001d>$\u0018NZ5dCRLwN\\*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u001dJ\u0003C\u0001\u0015\u0001\u001b\u0005q\u0001\"\u0002\u0011\u0003\u0001\u0004\t\u0003F\u0001\u0002,!\tas'D\u0001.\u0015\tqs&\u0001\u0006b]:|G/\u0019;j_:T!\u0001M\u0019\u0002\u000f\u0019\f7\r^8ss*\u0011!gM\u0001\u0006E\u0016\fgn\u001d\u0006\u0003iU\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002m\u0005\u0019qN]4\n\u0005aj#!C!vi><\u0018N]3e\u00035yg\u000eV1tWV\u0003H-\u0019;fIR\u00111H\u0010\t\u00037qJ!!\u0010\u000f\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u007f\r\u0001\r\u0001Q\u0001\u0006KZ,g\u000e\u001e\t\u0003\u0003\u001ak\u0011A\u0011\u0006\u0003\u0007\u0012\u000ba!\u001a<f]R\u001c(BA#\u0013\u0003\u0019!w.\\1j]&\u0011qI\u0011\u0002\u0011)\u0006\u001c8.\u00169eCR,G-\u0012<f]RD#aA%\u0011\u0005)cU\"A&\u000b\u0005\r\u0013\u0012BA'L\u00059\t5/\u001f8d'V\u00147o\u0019:jE\u0016\f!C\\8uS\u001aLxj\u001e8fe\u0006sG\rV3b[R\u00111\b\u0015\u0005\u0006\u007f\u0011\u0001\r\u0001Q\u0001\u000f]>$\u0018NZ=NK:$\u0018n\u001c8t)\tY4\u000bC\u0003@\u000b\u0001\u0007\u0001)A\u0007p]R\u000b7o[*uCJ$X\r\u001a\u000b\u0003wYCQa\u0010\u0004A\u0002]\u0003\"!\u0011-\n\u0005e\u0013%\u0001\u0005+bg.\u001cF/\u0019:uK\u0012,e/\u001a8uQ\t1\u0011*A\u0007p]R\u000b7o\u001b*fiJLW\r\u001a\u000b\u0003wuCQaP\u0004A\u0002y\u0003\"!Q0\n\u0005\u0001\u0014%\u0001\u0005+bg.\u0014V\r\u001e:jK\u0012,e/\u001a8uQ\t9\u0011*\u0001\u0007p]R\u000b7o\u001b$bS2,G\r\u0006\u0002<I\")q\b\u0003a\u0001KB\u0011\u0011IZ\u0005\u0003O\n\u0013q\u0002V1tW\u001a\u000b\u0017\u000e\\3e\u000bZ,g\u000e\u001e\u0015\u0003\u0011%\u000bQc\u001c8UCN\\w+Y5uS:<gi\u001c:J]B,H\u000f\u0006\u0002<W\")q(\u0003a\u0001YB\u0011\u0011)\\\u0005\u0003]\n\u0013\u0001\u0004V1tW^\u000b\u0017\u000e^5oO\u001a{'/\u00138qkR,e/\u001a8uQ\tI\u0011*A\u0007p]R\u000b7o[(wKJ$W/\u001a\u000b\u0003wIDQa\u0010\u0006A\u0002M\u0004\"!\u0011;\n\u0005U\u0014%\u0001\u0005+bg.|e/\u001a:ek\u0016,e/\u001a8uQ\tQ\u0011*A\u0007p]R\u000b7o\u001b#vKN{wN\u001c\u000b\u0003weDQaP\u0006A\u0002i\u0004\"!Q>\n\u0005q\u0014%\u0001\u0005+bg.$U/Z*p_:,e/\u001a8uQ\tY\u0011*A\fo_RLg-_'b]V\fG\u000eV1tWN#\u0018M\u001d;fIR\u00191(!\u0001\t\u000f\u0005\rA\u00021\u0001\u0002\u0006\u0005!A/Y:l!\u0011\t9!!\u0003\u000e\u0003\u0011K1!a\u0003E\u0005\u0011!\u0016m]6)\u0007\u0001\ty\u0001E\u0002K\u0003#I1!a\u0005L\u00055)e/\u001a8u\u0019&\u001cH/\u001a8fe\"\u001a\u0001!a\u0006\u0011\t\u0005e\u0011qD\u0007\u0003\u00037Q1!!\b4\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003C\tYBA\u0005D_6\u0004xN\\3oi\u0002")
public class TaskNotificationEventHandler {
    private final NotificationService notificationService;

    @AsyncSubscribe
    public void onTaskUpdated(TaskUpdatedEvent event) {
        Tuple2 tuple2 = new Tuple2((Object)event.original(), (Object)event.updated());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Task original = (Task)tuple2._1();
        Task updated = (Task)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)original, (Object)updated);
        Task original2 = (Task)tuple22._1();
        Task updated2 = (Task)tuple22._2();
        if (updated2.isActive()) {
            this.notifyOwnerAndTeam(event);
            FlagStatus flagStatus = original2.getFlagStatus();
            FlagStatus flagStatus2 = updated2.getFlagStatus();
            if (flagStatus == null ? flagStatus2 != null : !flagStatus.equals(flagStatus2)) {
                FlagStatus flagStatus3 = updated2.getFlagStatus();
                FlagStatus flagStatus4 = FlagStatus.OK;
                if (flagStatus3 == null ? flagStatus4 != null : !flagStatus3.equals(flagStatus4)) {
                    this.notificationService.notify(new TaskFlagged((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)updated2))));
                }
            }
        }
        this.notifyMentions(event);
    }

    private void notifyOwnerAndTeam(TaskUpdatedEvent event) {
        Tuple2 tuple2 = new Tuple2((Object)event.original(), (Object)event.updated());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Task original = (Task)tuple2._1();
        Task updated = (Task)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)original, (Object)updated);
        Task original2 = (Task)tuple22._1();
        Task updated2 = (Task)tuple22._2();
        Option originalOwner = Option$.MODULE$.apply((Object)original2.getOwner());
        Option updatedOwner = Option$.MODULE$.apply((Object)updated2.getOwner());
        Option originalTeam = Option$.MODULE$.apply((Object)original2.getTeam());
        Option updatedTeam = Option$.MODULE$.apply((Object)updated2.getTeam());
        if (TaskNotificationEventHandler.isOwnerOrTeamUnassigned$1(originalOwner, updatedOwner, originalTeam, updatedTeam)) {
            this.notificationService.notify(new ActiveTaskUnassigned((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)original2))));
            return;
        }
        if (TaskNotificationEventHandler.isOwnerUpdated$1(originalOwner, updatedOwner)) {
            if (originalOwner.isDefined()) {
                this.notificationService.notify(new ActiveTaskUnassigned((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)original2))));
            }
            this.notificationService.notify(new ActiveTaskAssigned((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)updated2))));
            return;
        }
        if (TaskNotificationEventHandler.isTeamUpdated$1(originalTeam, updatedTeam)) {
            if (originalTeam.isDefined()) {
                this.notificationService.notify(new ActiveTaskUnassigned((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)original2))));
            }
            this.notificationService.notify(new ActiveTaskAssigned((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)updated2))));
            return;
        }
    }

    private void notifyMentions(TaskUpdatedEvent event) {
        Tuple2 tuple2 = new Tuple2((Object)event.original(), (Object)event.updated());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Task original = (Task)tuple2._1();
        Task updated = (Task)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)original, (Object)updated);
        Task original2 = (Task)tuple22._1();
        Task updated2 = (Task)tuple22._2();
        String string = original2.getDescription();
        String string2 = updated2.getDescription();
        if (string == null ? string2 != null : !string.equals(string2)) {
            Set<String> originalMentions = Mentions$.MODULE$.collectMentions(original2.getDescription());
            Set<String> updatedMentions = Mentions$.MODULE$.collectMentions(updated2.getDescription());
            Set newMentions = (Set)updatedMentions.$minus$minus(originalMentions);
            if (newMentions.nonEmpty()) {
                this.notificationService.notify(new UserMentioned((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)updated2)), (Set<String>)newMentions, event.username(), updated2.getDescription()));
                return;
            }
            return;
        }
    }

    @AsyncSubscribe
    public void onTaskStarted(TaskStartedEvent event) {
        this.notifyManualTaskStarted(event.task());
    }

    @AsyncSubscribe
    public void onTaskRetried(TaskRetriedEvent event) {
        this.notifyManualTaskStarted(event.task());
    }

    @AsyncSubscribe
    public void onTaskFailed(TaskFailedEvent event) {
        if (!event.task().isTaskGroup()) {
            this.notificationService.notify(new TaskFailed((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)event.task()))));
            return;
        }
    }

    @AsyncSubscribe
    public void onTaskWaitingForInput(TaskWaitingForInputEvent event) {
        this.notificationService.notify(new TaskWaitingForInput((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)event.task()))));
    }

    @AsyncSubscribe
    public void onTaskOverdue(TaskOverdueEvent event) {
        Task task = event.task();
        Option dueDate = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(task.getOrCalculateDueDate()));
        if (task.isInProgress() && task.hasStartDate() && dueDate.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.after(task.getStartDate())))) {
            this.notificationService.notify(new TaskOverdue((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)task))));
            return;
        }
    }

    @AsyncSubscribe
    public void onTaskDueSoon(TaskDueSoonEvent event) {
        this.notificationService.notify(new TaskDueSoon((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)event.task()))));
    }

    private void notifyManualTaskStarted(Task task) {
        if (!task.isAutomated() && !task.isTaskGroup()) {
            if (Option$.MODULE$.apply((Object)task.getOwner()).isEmpty() && Option$.MODULE$.apply((Object)task.getTeam()).isEmpty() && package$.MODULE$.TaskWithNotificationFields(task).sendNotificationWhenStarted()) {
                this.notificationService.notify(new ManualTaskStartedWithoutAssignee((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)task))));
                return;
            }
            this.notificationService.notify(new ManualTaskStarted((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)task))));
            return;
        }
    }

    private static final boolean isOwnerOrTeamUnassigned$1(Option originalOwner$1, Option updatedOwner$1, Option originalTeam$1, Option updatedTeam$1) {
        return originalOwner$1.isDefined() && updatedOwner$1.isEmpty() || originalTeam$1.isDefined() && updatedTeam$1.isEmpty();
    }

    private static final boolean isOwnerUpdated$1(Option originalOwner$1, Option updatedOwner$1) {
        Option option = originalOwner$1;
        Option option2 = updatedOwner$1;
        return option == null ? option2 != null : !option.equals(option2);
    }

    private static final boolean isTeamUpdated$1(Option originalTeam$1, Option updatedTeam$1) {
        Option option = originalTeam$1;
        Option option2 = updatedTeam$1;
        return option == null ? option2 != null : !option.equals(option2);
    }

    @Autowired
    public TaskNotificationEventHandler(NotificationService notificationService) {
        this.notificationService = notificationService;
    }
}

