package com.xebialabs.xlrelease.notifications.task


import com.xebialabs.xlrelease.domain.NotificationTask
import com.xebialabs.xlrelease.domain.tasks.TaskExecutor
import com.xebialabs.xlrelease.scheduler.{NotificationTaskJob, WorkManager}
import com.xebialabs.xlrelease.script.TaskSoftReference
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
class NotificationTaskExecutor @Autowired()(workManager: WorkManager) extends TaskExecutor[NotificationTask] with Logging {

  override def getTaskClass: Class[NotificationTask] = classOf[NotificationTask]

  override def execute(taskRef: TaskSoftReference[NotificationTask]): Unit = {
    workManager.submit(NotificationTaskJob(taskRef))
  }

}
