/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.email;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache$;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.notifications.configuration.trigger.RecipientSettings;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.PrincipalInfoResolver;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.service.UserProfileService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.SetOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005\u001dh\u0001B\n\u0015\u0001}A\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\t_\u0001\u0011\t\u0011)A\u0005a!Aa\u0007\u0001B\u0001B\u0003%q\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0011!q\u0004A!A!\u0002\u0013y\u0004\"B#\u0001\t\u00031\u0005\"B/\u0001\t\u0003q\u0006\"\u00027\u0001\t\u0003i\u0007\"CA\u000e\u0001E\u0005I\u0011AA\u000f\u0011\u001d\t\t\u0004\u0001C\u0005\u0003gAq!!\u000f\u0001\t\u0013\tY\u0004C\u0004\u0002b\u0001!I!a\u0019\t\u000f\u0005u\u0004\u0001\"\u0003\u0002\u0000!9\u0011\u0011\u0013\u0001\u0005\n\u0005M\u0005bBAS\u0001\u0011%\u0011q\u0015\u0005\b\u0003k\u0003A\u0011BA\\\u0011\u001d\ti\f\u0001C\u0005\u0003\u007fCq!!3\u0001\t\u0013\tYM\u0001\fF[\u0006LGNU3dSBLWM\u001c;SKN|GN^3s\u0015\t)b#A\u0003f[\u0006LGN\u0003\u0002\u00181\u0005ian\u001c;jM&\u001c\u0017\r^5p]NT!!\u0007\u000e\u0002\u0013ad'/\u001a7fCN,'BA\u000e\u001d\u0003%AXMY5bY\u0006\u00147OC\u0001\u001e\u0003\r\u0019w.\\\u0002\u0001'\t\u0001\u0001\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0004B]f\u0014VMZ\u0001\fe>dWmU3sm&\u001cW\r\u0005\u0002)[5\t\u0011F\u0003\u0002+W\u0005A1/Z2ve&$\u0018P\u0003\u0002-5\u0005AA-\u001a9m_fLG/\u0003\u0002/S\tY!k\u001c7f'\u0016\u0014h/[2f\u0003-!X-Y7TKJ4\u0018nY3\u0011\u0005E\"T\"\u0001\u001a\u000b\u0005MB\u0012aB:feZL7-Z\u0005\u0003kI\u00121\u0002V3b[N+'O^5dK\u0006\u0011Ro]3s!J|g-\u001b7f'\u0016\u0014h/[2f!\t\t\u0004(\u0003\u0002:e\t\u0011Rk]3s!J|g-\u001b7f'\u0016\u0014h/[2f\u0003U\u0001(/\u001b8dSB\fG.\u00138g_J+7o\u001c7wKJ\u0004\"!\r\u001f\n\u0005u\u0012$!\u0006)sS:\u001c\u0017\u000e]1m\u0013:4wNU3t_24XM]\u0001\nq2\u00148i\u001c8gS\u001e\u0004\"\u0001Q\"\u000e\u0003\u0005S!A\u0011\r\u0002\r\r|gNZ5h\u0013\t!\u0015IA\u0005YYJ\u001cuN\u001c4jO\u00061A(\u001b8jiz\"baR%K\u00172k\u0005C\u0001%\u0001\u001b\u0005!\u0002\"\u0002\u0014\u0007\u0001\u00049\u0003\"B\u0018\u0007\u0001\u0004\u0001\u0004\"\u0002\u001c\u0007\u0001\u00049\u0004\"\u0002\u001e\u0007\u0001\u0004Y\u0004\"\u0002 \u0007\u0001\u0004y\u0004F\u0001\u0004P!\t\u00016,D\u0001R\u0015\t\u00116+\u0001\u0006b]:|G/\u0019;j_:T!\u0001V+\u0002\u000f\u0019\f7\r^8ss*\u0011akV\u0001\u0006E\u0016\fgn\u001d\u0006\u00031f\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u00025\u0006\u0019qN]4\n\u0005q\u000b&!C!vi><\u0018N]3e\u0003A\u0011Xm]8mm\u0016\u0014VmY5qS\u0016tG\u000f\u0006\u0002`UB\u0011\u0001m\u001a\b\u0003C\u0016\u0004\"A\u0019\u0012\u000e\u0003\rT!\u0001\u001a\u0010\u0002\rq\u0012xn\u001c;?\u0013\t1'%\u0001\u0004Qe\u0016$WMZ\u0005\u0003Q&\u0014aa\u0015;sS:<'B\u00014#\u0011\u0015Yw\u00011\u0001`\u00035\u0001(/\u001b8dSB\fGNT1nK\u0006\t\"/Z:pYZ,'+Z2ja&,g\u000e^:\u0015\u00119\fHP`A\u0001\u0003#\u00012\u0001Y8`\u0013\t\u0001\u0018NA\u0002TKRDQA\u001d\u0005A\u0002M\fQA]8mKN\u00042\u0001^=`\u001d\t)xO\u0004\u0002cm&\t1%\u0003\u0002yE\u00059\u0001/Y2lC\u001e,\u0017B\u0001>|\u0005\u0011a\u0015n\u001d;\u000b\u0005a\u0014\u0003\"B?\t\u0001\u0004\u0019\u0018aC4m_\n\fGNU8mKNDQa \u0005A\u0002M\fQ!^:feNDq!a\u0001\t\u0001\u0004\t)!\u0001\u0005qY\u0006t\u0017\n^3n!\u0011\t9!!\u0004\u000e\u0005\u0005%!bAA\u00061\u00051Am\\7bS:LA!a\u0004\u0002\n\tA\u0001\u000b\\1o\u0013R,W\u000eC\u0005\u0002\u0014!\u0001\n\u00111\u0001\u0002\u0016\u0005iQ\r_2mk\u0012,\u0017)\u001e;i_J\u00042!IA\f\u0013\r\tIB\t\u0002\b\u0005>|G.Z1o\u0003m\u0011Xm]8mm\u0016\u0014VmY5qS\u0016tGo\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011q\u0004\u0016\u0005\u0003+\t\tc\u000b\u0002\u0002$A!\u0011QEA\u0017\u001b\t\t9C\u0003\u0003\u0002*\u0005-\u0012!C;oG\",7m[3e\u0015\t\u0011&%\u0003\u0003\u00020\u0005\u001d\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Qan\u001c;jMf,6/\u001a:\u0015\t\u0005U\u0011Q\u0007\u0005\u0007\u0003oQ\u0001\u0019A0\u0002\u0011U\u001cXM\u001d8b[\u0016\f!\u0002]1sg\u0016\u0014v\u000e\\3t)%q\u0017QHA%\u0003\u0017\ni\u0005C\u0004\u0002@-\u0001\r!!\u0011\u0002\u0017\u0005\u001c8/[4o[\u0016tGo\u001d\t\u0005if\f\u0019\u0005E\u0002)\u0003\u000bJ1!a\u0012*\u0005\u0011\u0011v\u000e\\3\t\u000bI\\\u0001\u0019A:\t\u000f\u0005\r1\u00021\u0001\u0002\u0006!9\u0011qJ\u0006A\u0002\u0005E\u0013!B2bG\",\u0007\u0003BA*\u0003;j!!!\u0016\u000b\t\u0005]\u0013\u0011L\u0001\tS:$XM\u001d8bY*\u0019\u00111\f\r\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002`\u0005U#a\u0004#fG>\u0014\u0018\r^8sg\u000e\u000b7\r[3\u0002\u001fI,\u0007\u000f\\1dKZ\u000b'/[1cY\u0016$RaXA3\u0003SBa!a\u001a\r\u0001\u0004y\u0016!\u0002<bYV,\u0007bBA6\u0019\u0001\u0007\u0011QN\u0001\nm\u0006\u0014\u0018.\u00192mKN\u0004b!a\u001c\u0002z}{VBAA9\u0015\u0011\t\u0019(!\u001e\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003o\nAA[1wC&!\u00111PA9\u0005\ri\u0015\r]\u0001\u000fa\u0006\u00148/\u001a+bg.\u0014v\u000e\\3t)%q\u0017\u0011QAF\u0003\u001b\u000by\tC\u0004\u0002\u00046\u0001\r!!\"\u0002\tQ\f7o\u001b\t\u0005\u0003\u000f\t9)\u0003\u0003\u0002\n\u0006%!\u0001\u0002+bg.DQA]\u0007A\u0002MDq!a\u0010\u000e\u0001\u0004\t\t\u0005C\u0004\u0002P5\u0001\r!!\u0015\u0002#A\f'o]3SK2,\u0017m]3S_2,7\u000fF\u0005o\u0003+\u000by*!)\u0002$\"9\u0011q\u0013\bA\u0002\u0005e\u0015a\u0002:fY\u0016\f7/\u001a\t\u0005\u0003\u000f\tY*\u0003\u0003\u0002\u001e\u0006%!a\u0002*fY\u0016\f7/\u001a\u0005\u0006e:\u0001\ra\u001d\u0005\b\u0003\u007fq\u0001\u0019AA!\u0011\u001d\tyE\u0004a\u0001\u0003#\n\u0011cZ3u%\u0016dW-Y:f\u001b\u0016l'-\u001a:t)!\tI+a,\u00022\u0006M\u0006\u0003B\u0011\u0002,:L1!!,#\u0005\u0019y\u0005\u000f^5p]\"9\u0011qS\bA\u0002\u0005e\u0005bBA \u001f\u0001\u0007\u0011\u0011\t\u0005\b\u0003\u001fz\u0001\u0019AA)\u0003A\u0001\u0018M]:f\u000f2|'-\u00197S_2,7\u000fF\u0003t\u0003s\u000bY\fC\u0004\u0002@A\u0001\r!!\u0011\t\u000bu\u0004\u0002\u0019A:\u0002!A\f'o]3G_2$WM\u001d+fC6\u001cH#\u00038\u0002B\u0006\r\u0017QYAd\u0011\u001d\ty$\u0005a\u0001\u0003\u0003BQA]\tA\u0002MDq!a\u0001\u0012\u0001\u0004\t)\u0001C\u0004\u0002PE\u0001\r!!\u0015\u0002\u001b\u001d,G/\u00117m\u001b\u0016l'-\u001a:t)\u0015q\u0017QZAl\u0011\u001d\tyM\u0005a\u0001\u0003#\fA\u0001^3b[B!\u0011qAAj\u0013\u0011\t).!\u0003\u0003\tQ+\u0017-\u001c\u0005\b\u0003\u007f\u0011\u0002\u0019AA!Q\r\u0001\u00111\u001c\t\u0005\u0003;\f\u0019/\u0004\u0002\u0002`*\u0019\u0011\u0011],\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002f\u0006}'aB*feZL7-\u001a")
public class EmailRecipientResolver {
    private final RoleService roleService;
    private final TeamService teamService;
    private final UserProfileService userProfileService;
    private final PrincipalInfoResolver principalInfoResolver;
    private final XlrConfig xlrConfig;

    public String resolveRecipient(String principalName) {
        return this.principalInfoResolver.getNotificationEmailOf(principalName);
    }

    public Set<String> resolveRecipients(List<String> roles, List<String> globalRoles, List<String> users, PlanItem planItem, boolean excludeAuthor) {
        List assignments = CollectionConverters$.MODULE$.ListHasAsScala(this.roleService.readRoleAssignments()).asScala().toList();
        DecoratorsCache cache = new DecoratorsCache(DecoratorsCache$.MODULE$.$lessinit$greater$default$1());
        Set allPrincipals = (Set)((SetOps)this.parseRoles((List<Role>)assignments, roles, planItem, cache).$plus$plus(this.parseGlobalRoles((List<Role>)assignments, globalRoles)).$plus$plus(this.parseFolderTeams((List<Role>)assignments, roles, planItem, cache)).$plus$plus(users)).$minus$minus((IterableOnce)(excludeAuthor ? (IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{User.AUTHENTICATED_USER.getName()})) : package$.MODULE$.Nil()));
        return (Set)((IterableOps)((IterableOps)allPrincipals.filter((Function1 & Serializable)username -> BoxesRunTime.boxToBoolean((boolean)this.notifyUser(username)))).map((Function1 & Serializable)x$1 -> $this.principalInfoResolver.getNotificationEmailOf(x$1))).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$resolveRecipients$3(x$1)));
    }

    public boolean resolveRecipients$default$5() {
        return false;
    }

    private boolean notifyUser(String username) {
        UserProfile profile = this.userProfileService.findByUsername(username);
        return profile != null ? profile.isLoginAllowed() || this.xlrConfig.isNotifyInactiveUsers() : true;
    }

    private Set<String> parseRoles(List<Role> assignments, List<String> roles, PlanItem planItem, DecoratorsCache cache) {
        Set<String> set;
        PlanItem planItem2 = planItem;
        if (planItem2 instanceof Task) {
            Task task = (Task)planItem2;
            set = this.parseTaskRoles(task, roles, assignments, cache);
        } else if (planItem2 instanceof Release) {
            Release release = (Release)planItem2;
            set = this.parseReleaseRoles(release, roles, assignments, cache);
        } else {
            throw new MatchError((Object)planItem2);
        }
        return set;
    }

    private String replaceVariable(String value, Map<String, String> variables) {
        return VariableHelper$.MODULE$.containsVariables(value) ? VariableHelper$.MODULE$.replaceAll(value, variables) : value;
    }

    private Set<String> parseTaskRoles(Task task, List<String> roles, List<Role> assignments, DecoratorsCache cache) {
        ObjectRef parsed;
        block3: {
            parsed = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
            boolean shouldSendToTaskOwner = roles.contains((Object)"Task Owner");
            Option taskOwner = Option$.MODULE$.apply((Object)task.getOwner());
            if (shouldSendToTaskOwner && taskOwner.isDefined()) {
                parsed.elem = (Set)((Set)parsed.elem).$plus((Object)this.replaceVariable((String)taskOwner.get(), task.getRelease().getAllStringVariableValues()));
            }
            if (roles.contains((Object)"Task Team") || shouldSendToTaskOwner && taskOwner.isEmpty()) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.teamService.findTeamByName(Ids.releaseIdFrom((String)task.getId()), task.getTeam()))).foreach((Function1 & Serializable)x$3 -> {
                    parsed.elem = (Set)((Set)parsed.elem).$plus$plus(this.getAllMembers(x$3, (List<Role>)assignments));
                    return BoxedUnit.UNIT;
                });
            }
            if (roles.contains((Object)RecipientSettings.RELEASE_ADMIN_ROLE_NAME)) {
                parsed.elem = (Set)((Set)parsed.elem).$plus$plus((IterableOnce)this.getReleaseMembers(task.getRelease(), assignments, cache).getOrElse((Function0 & Serializable)() -> package$.MODULE$.Nil()));
            }
            if (!roles.contains((Object)"Watcher")) break block3;
            Set watchers = CollectionConverters$.MODULE$.SetHasAsScala(task.getWatchers()).asScala().toSet();
            watchers.foreach((Function1 & Serializable)x$4 -> {
                parsed.elem = (Set)((Set)parsed.elem).$plus((Object)this.replaceVariable(x$4, task.getRelease().getAllStringVariableValues()));
                return BoxedUnit.UNIT;
            });
        }
        return (Set)parsed.elem;
    }

    private Set<String> parseReleaseRoles(Release release, List<String> roles, List<Role> assignments, DecoratorsCache cache) {
        Set parsed;
        block0: {
            parsed = Predef$.MODULE$.Set().empty();
            if (!roles.contains((Object)RecipientSettings.RELEASE_ADMIN_ROLE_NAME)) break block0;
            parsed = (Set)parsed.$plus$plus((IterableOnce)this.getReleaseMembers(release, assignments, cache).getOrElse((Function0 & Serializable)() -> package$.MODULE$.Nil()));
        }
        return parsed;
    }

    private Option<Set<String>> getReleaseMembers(Release release, List<Role> assignments, DecoratorsCache cache) {
        Option effectiveTeams = CollectionConverters$.MODULE$.ListHasAsScala(this.teamService.getEffectiveTeams(release, cache)).asScala().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$getReleaseMembers$1(x$5)));
        return effectiveTeams.map((Function1 & Serializable)x$6 -> this.getAllMembers((Team)x$6, assignments));
    }

    private List<String> parseGlobalRoles(List<Role> assignments, List<String> globalRoles) {
        List<String> list = globalRoles;
        Nil$ nil$ = package$.MODULE$.Nil();
        List<String> list2 = list;
        List list3 = !(nil$ != null ? !nil$.equals(list2) : list2 != null) ? (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$) : assignments.filter((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)globalRoles.contains((Object)r.getName()))).flatMap((Function1 & Serializable)x$7 -> CollectionConverters$.MODULE$.ListHasAsScala(x$7.getPrincipals()).asScala().toList());
        return list3;
    }

    private Set<String> parseFolderTeams(List<Role> assignments, List<String> roles, PlanItem planItem, DecoratorsCache cache) {
        ObjectRef parsed;
        block0: {
            parsed = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
            List folderTeams = (List)roles.diff((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{RecipientSettings.RELEASE_ADMIN_ROLE_NAME, "Task Owner", "Task Team", "Watcher"})));
            String folderId = Ids.findFolderId((String)planItem.getId());
            if (!Strings.isNotEmpty((String)folderId) || Ids.isRoot((String)folderId)) break block0;
            this.teamService.findTeamsByNames(folderId, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)folderTeams).asJava(), cache).forEach(x$8 -> {
                parsed$2.elem = (Set)((Set)parsed$2.elem).$plus$plus(this.getAllMembers((Team)x$8, assignments));
            });
        }
        return (Set)parsed.elem;
    }

    private Set<String> getAllMembers(Team team, List<Role> assignments) {
        Set teamMembers = CollectionConverters$.MODULE$.ListHasAsScala(team.getMembers()).asScala().toSet();
        List roleMembers = CollectionConverters$.MODULE$.ListHasAsScala(team.getRoles()).asScala().toList().flatMap((Function1 & Serializable)roleName -> assignments.find((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$getAllMembers$2(roleName, x$9))).toList().flatMap((Function1 & Serializable)role -> CollectionConverters$.MODULE$.ListHasAsScala(role.getPrincipals()).asScala().toList().map((Function1 & Serializable)principal -> {
            $this.userProfileService.discover(principal);
            return principal;
        })));
        return (Set)teamMembers.$plus$plus((IterableOnce)roleMembers);
    }

    public static final /* synthetic */ boolean $anonfun$resolveRecipients$3(String x$1) {
        return Option$.MODULE$.apply((Object)x$1).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2.trim()))));
    }

    public static final /* synthetic */ boolean $anonfun$getReleaseMembers$1(Team x$5) {
        String string = x$5.getTeamName();
        String string2 = "Release Admin";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getAllMembers$2(String roleName$1, Role x$9) {
        String string = x$9.getName();
        String string2 = roleName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Autowired
    public EmailRecipientResolver(RoleService roleService, TeamService teamService, UserProfileService userProfileService, PrincipalInfoResolver principalInfoResolver, XlrConfig xlrConfig) {
        this.roleService = roleService;
        this.teamService = teamService;
        this.userProfileService = userProfileService;
        this.principalInfoResolver = principalInfoResolver;
        this.xlrConfig = xlrConfig;
    }
}

