/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.task;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plumbing.scheduler.FutureTaskAdapter;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.FailureReasons;
import com.xebialabs.xlrelease.domain.NotificationTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.tasks.TaskExecutor;
import com.xebialabs.xlrelease.notifications.email.ContextHelper;
import com.xebialabs.xlrelease.notifications.email.Email;
import com.xebialabs.xlrelease.notifications.email.EmailSender;
import com.xebialabs.xlrelease.notifications.email.templates.Templater$;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.script.TaskSoftReference;
import com.xebialabs.xlrelease.script.TaskSoftReferenceFactory;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.utils.MarkdownProcessor;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@ScalaSignature(bytes="\u0006\u0005\u0005ua\u0001\u0002\u0006\f\u0001YA\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005w!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0011!y\u0005A!A!\u0002\u0013\u0001\u0006\"\u0002,\u0001\t\u00039\u0006\"\u00028\u0001\t\u0003z\u0007\"B?\u0001\t\u0003r\bbBA\u0005\u0001\u0011%\u00111\u0002\u0002\u0019\u001d>$\u0018NZ5dCRLwN\u001c+bg.,\u00050Z2vi>\u0014(B\u0001\u0007\u000e\u0003\u0011!\u0018m]6\u000b\u00059y\u0011!\u00048pi&4\u0017nY1uS>t7O\u0003\u0002\u0011#\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003%M\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003Q\t1aY8n\u0007\u0001\u0019B\u0001A\f WA\u0011\u0001$H\u0007\u00023)\u0011!dG\u0001\u0005Y\u0006twMC\u0001\u001d\u0003\u0011Q\u0017M^1\n\u0005yI\"AB(cU\u0016\u001cG\u000fE\u0002!K\u001dj\u0011!\t\u0006\u0003E\r\nQ\u0001^1tWNT!\u0001J\b\u0002\r\u0011|W.Y5o\u0013\t1\u0013E\u0001\u0007UCN\\W\t_3dkR|'\u000f\u0005\u0002)S5\t1%\u0003\u0002+G\t\u0001bj\u001c;jM&\u001c\u0017\r^5p]R\u000b7o\u001b\t\u0003YEj\u0011!\f\u0006\u0003]=\nQa\u001d7gi)T\u0011\u0001M\u0001\tOJL'P\u001f7fI&\u0011!'\f\u0002\b\u0019><w-\u001b8h\u0003M\u0011X\r\\3bg\u0016\f5\r^8s'\u0016\u0014h/[2f!\t)\u0004(D\u00017\u0015\t9t\"\u0001\u0004bGR|'o]\u0005\u0003sY\u00121CU3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016\fQbY8oi\u0016DH\u000fS3ma\u0016\u0014\bC\u0001\u001f@\u001b\u0005i$B\u0001 \u000e\u0003\u0015)W.Y5m\u0013\t\u0001UHA\u0007D_:$X\r\u001f;IK2\u0004XM]\u0001\fK6\f\u0017\u000e\\*f]\u0012,'\u000f\u0005\u0002=\u0007&\u0011A)\u0010\u0002\f\u000b6\f\u0017\u000e\\*f]\u0012,'/A\u0005tG\",G-\u001e7feB\u0011q)T\u0007\u0002\u0011*\u0011Q)\u0013\u0006\u0003\u0015.\u000b\u0001\u0002\u001d7v[\nLgn\u001a\u0006\u0003\u0019F\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003\u001d\"\u0013\u0011bU2iK\u0012,H.\u001a:\u0002\u001dQ\f7o\u001b*fa>\u001c\u0018\u000e^8ssB\u0011\u0011\u000bV\u0007\u0002%*\u00111kD\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA+S\u00059!\u0016m]6SKB|7/\u001b;pef\fa\u0001P5oSRtDC\u0002-[7rkf\f\u0005\u0002Z\u00015\t1\u0002C\u00034\r\u0001\u0007A\u0007C\u0003;\r\u0001\u00071\bC\u0003B\r\u0001\u0007!\tC\u0003F\r\u0001\u0007a\tC\u0003P\r\u0001\u0007\u0001\u000b\u000b\u0002\u0007AB\u0011\u0011\r\\\u0007\u0002E*\u00111\rZ\u0001\u000bC:tw\u000e^1uS>t'BA3g\u0003\u001d1\u0017m\u0019;pefT!a\u001a5\u0002\u000b\t,\u0017M\\:\u000b\u0005%T\u0017aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003-\f1a\u001c:h\u0013\ti'MA\u0005BkR|w/\u001b:fI\u0006aq-\u001a;UCN\\7\t\\1tgR\t\u0001\u000fE\u0002ru\u001er!A\u001d=\u0011\u0005M4X\"\u0001;\u000b\u0005U,\u0012A\u0002\u001fs_>$hHC\u0001x\u0003\u0015\u00198-\u00197b\u0013\tIh/\u0001\u0004Qe\u0016$WMZ\u0005\u0003wr\u0014Qa\u00117bgNT!!\u001f<\u0002\u000f\u0015DXmY;uKR\u0019q0a\u0002\u0011\t\u0005\u0005\u00111A\u0007\u0002m&\u0019\u0011Q\u0001<\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0019!\u0001\raJ\u0001\u0011g\u0016tGMT8uS\u001aL7-\u0019;j_:$2a`A\u0007\u0011\u0015a\u0011\u00021\u0001(Q\r\u0001\u0011\u0011\u0003\t\u0005\u0003'\tI\"\u0004\u0002\u0002\u0016)\u0019\u0011q\u00035\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002\u001c\u0005U!!C\"p[B|g.\u001a8u\u0001")
public class NotificationTaskExecutor
implements TaskExecutor<NotificationTask>,
Logging {
    private final ReleaseActorService releaseActorService;
    private final ContextHelper contextHelper;
    private final EmailSender emailSender;
    private final Scheduler scheduler;
    private final TaskRepository taskRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        NotificationTaskExecutor notificationTaskExecutor = this;
        synchronized (notificationTaskExecutor) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public Class<NotificationTask> getTaskClass() {
        return NotificationTask.class;
    }

    public void execute(NotificationTask task) {
        TaskSoftReference ref = TaskSoftReferenceFactory.taskRef((TaskRepository)this.taskRepository, (Task)task);
        this.scheduler.supplyAsync(FutureTaskAdapter.ofNotificationTask((String)task.getId(), (ReleaseActorService)this.releaseActorService, (String)task.getExecutionId(), () -> {
            this.sendNotification((NotificationTask)ref.get());
            return null;
        }));
    }

    private void sendNotification(NotificationTask task) {
        scala.collection.immutable.Map context = (scala.collection.immutable.Map)this.contextHelper.baseContext().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"body"), MarkdownProcessor.process((String)task.getBody()).orElse(null)));
        String body = Templater$.MODULE$.processTemplate("notification-task-template.mustache", CollectionConverters$.MODULE$.MapHasAsJava((Map)context).asJava());
        Email email = new Email(task.getAddresses(), task.getSubject(), body);
        email.withPriority(task.getPriority()).withReplyTo(task.getReplyTo()).withCc(task.getCc()).withBcc(task.getBcc()).withFrom(task.getFrom()).withSenderUsername(task.getSenderUsername()).withSenderPassword(task.getSenderPassword());
        List list = ((MapOps)((IterableOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"To"), (Object)BoxesRunTime.boxToBoolean((boolean)task.getAddresses().isEmpty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Subject"), (Object)BoxesRunTime.boxToBoolean((boolean)Strings.isNullOrEmpty((String)task.getSubject()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Body"), (Object)BoxesRunTime.boxToBoolean((boolean)Strings.isNullOrEmpty((String)task.getBody())))}))).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1._2$mcZ$sp()))).keys().toList();
        Nil$ nil$ = package$.MODULE$.Nil();
        List list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            Failure failure;
            Throwable e;
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.emailSender.sendEmailSync(email));
            if (try_ instanceof Success) {
                this.releaseActorService.markTaskAsDone(TaskStatus.COMPLETED, task.getId(), null, User.SYSTEM);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (try_ instanceof Failure && (e = (failure = (Failure)try_).exception()) != null) {
                Throwable throwable = e;
                this.releaseActorService.failTaskAsync(task.getId(), FailureReasons.NOTIFICATION_TASK_FAILED.format(new Object[]{throwable.getMessage()}), User.SYSTEM, this.releaseActorService.failTaskAsync$default$4());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)try_);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            String errorMessage = new StringBuilder(33).append("The required fields [").append(list.mkString(", ")).append("] are missed").toString();
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(41).append("Email not sent for notification task '").append(task.getId()).append("'. ").append(errorMessage).toString());
            this.releaseActorService.failTaskAsync(task.getId(), FailureReasons.NOTIFICATION_TASK_FAILED.format(new Object[]{errorMessage}), User.SYSTEM, this.releaseActorService.failTaskAsync$default$4());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Autowired
    public NotificationTaskExecutor(ReleaseActorService releaseActorService, ContextHelper contextHelper, EmailSender emailSender, Scheduler scheduler, TaskRepository taskRepository) {
        this.releaseActorService = releaseActorService;
        this.contextHelper = contextHelper;
        this.emailSender = emailSender;
        this.scheduler = scheduler;
        this.taskRepository = taskRepository;
        Logging.$init$((Logging)this);
    }
}

