/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.email;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache$;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.notifications.configuration.trigger.RecipientSettings;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.PrincipalInfoResolver;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.service.UserProfileService;
import com.xebialabs.xlrelease.user.User;
import java.io.Serializable;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.SetOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005]f\u0001B\t\u0013\u0001uA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\t[\u0001\u0011\t\u0011)A\u0005]!AA\u0007\u0001B\u0001B\u0003%Q\u0007\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u0011\u0015a\u0004\u0001\"\u0001>\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0011%\t9\u0001AI\u0001\n\u0003\tI\u0001C\u0004\u0002\u001e\u0001!I!a\b\t\u000f\u0005\u0015\u0002\u0001\"\u0003\u0002(!9\u0011Q\n\u0001\u0005\n\u0005=\u0003bBA1\u0001\u0011%\u00111\r\u0005\b\u0003k\u0002A\u0011BA<\u0011\u001d\t)\t\u0001C\u0005\u0003\u000fCq!!$\u0001\t\u0013\ty\tC\u0004\u0002\u001a\u0002!I!a'\u0003-\u0015k\u0017-\u001b7SK\u000eL\u0007/[3oiJ+7o\u001c7wKJT!a\u0005\u000b\u0002\u000b\u0015l\u0017-\u001b7\u000b\u0005U1\u0012!\u00048pi&4\u0017nY1uS>t7O\u0003\u0002\u00181\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u00033i\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003m\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\u0010\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\r\u0005s\u0017PU3g\u0003-\u0011x\u000e\\3TKJ4\u0018nY3\u0011\u0005\u0019ZS\"A\u0014\u000b\u0005!J\u0013\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005)B\u0012\u0001\u00033fa2|\u00170\u001b;\n\u00051:#a\u0003*pY\u0016\u001cVM\u001d<jG\u0016\f1\u0002^3b[N+'O^5dKB\u0011qFM\u0007\u0002a)\u0011\u0011GF\u0001\bg\u0016\u0014h/[2f\u0013\t\u0019\u0004GA\u0006UK\u0006l7+\u001a:wS\u000e,\u0017AE;tKJ\u0004&o\u001c4jY\u0016\u001cVM\u001d<jG\u0016\u0004\"a\f\u001c\n\u0005]\u0002$AE+tKJ\u0004&o\u001c4jY\u0016\u001cVM\u001d<jG\u0016\fQ\u0003\u001d:j]\u000eL\u0007/\u00197J]\u001a|'+Z:pYZ,'\u000f\u0005\u00020u%\u00111\b\r\u0002\u0016!JLgnY5qC2LeNZ8SKN|GN^3s\u0003\u0019a\u0014N\\5u}Q)a\bQ!C\u0007B\u0011q\bA\u0007\u0002%!)A%\u0002a\u0001K!)Q&\u0002a\u0001]!)A'\u0002a\u0001k!)\u0001(\u0002a\u0001s!\u0012Q!\u0012\t\u0003\rFk\u0011a\u0012\u0006\u0003\u0011&\u000b!\"\u00198o_R\fG/[8o\u0015\tQ5*A\u0004gC\u000e$xN]=\u000b\u00051k\u0015!\u00022fC:\u001c(B\u0001(P\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001)\u0002\u0007=\u0014x-\u0003\u0002S\u000f\nI\u0011)\u001e;po&\u0014X\rZ\u0001\u0011e\u0016\u001cx\u000e\u001c<f%\u0016\u001c\u0017\u000e]5f]R$\"!\u00161\u0011\u0005YkfBA,\\!\tA\u0006%D\u0001Z\u0015\tQF$\u0001\u0004=e>|GOP\u0005\u00039\u0002\na\u0001\u0015:fI\u00164\u0017B\u00010`\u0005\u0019\u0019FO]5oO*\u0011A\f\t\u0005\u0006C\u001a\u0001\r!V\u0001\u000eaJLgnY5qC2t\u0015-\\3\u0002#I,7o\u001c7wKJ+7-\u001b9jK:$8\u000f\u0006\u0004eOJ$hO \t\u0004-\u0016,\u0016B\u00014`\u0005\r\u0019V\r\u001e\u0005\u0006Q\u001e\u0001\r![\u0001\u0006e>dWm\u001d\t\u0004U>,fBA6n\u001d\tAF.C\u0001\"\u0013\tq\u0007%A\u0004qC\u000e\\\u0017mZ3\n\u0005A\f(\u0001\u0002'jgRT!A\u001c\u0011\t\u000bM<\u0001\u0019A5\u0002\u0017\u001ddwNY1m%>dWm\u001d\u0005\u0006k\u001e\u0001\r![\u0001\u0006kN,'o\u001d\u0005\u0006o\u001e\u0001\r\u0001_\u0001\ta2\fg.\u0013;f[B\u0011\u0011\u0010`\u0007\u0002u*\u00111PF\u0001\u0007I>l\u0017-\u001b8\n\u0005uT(\u0001\u0003)mC:LE/Z7\t\u0011}<\u0001\u0013!a\u0001\u0003\u0003\tQ\"\u001a=dYV$W-Q;uQ>\u0014\bcA\u0010\u0002\u0004%\u0019\u0011Q\u0001\u0011\u0003\u000f\t{w\u000e\\3b]\u0006Y\"/Z:pYZ,'+Z2ja&,g\u000e^:%I\u00164\u0017-\u001e7uIU*\"!a\u0003+\t\u0005\u0005\u0011QB\u0016\u0003\u0003\u001f\u0001B!!\u0005\u0002\u001a5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"A\u0005v]\u000eDWmY6fI*\u0011\u0001\nI\u0005\u0005\u00037\t\u0019BA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\"[:Vg\u0016\u0014XI\\1cY\u0016$G\u0003BA\u0001\u0003CAa!a\t\n\u0001\u0004)\u0016\u0001C;tKJt\u0017-\\3\u0002\u0015A\f'o]3S_2,7\u000fF\u0005e\u0003S\t)$a\u000e\u0002:!9\u00111\u0006\u0006A\u0002\u00055\u0012aC1tg&<g.\\3oiN\u0004BA[8\u00020A\u0019a%!\r\n\u0007\u0005MrE\u0001\u0003S_2,\u0007\"\u00025\u000b\u0001\u0004I\u0007\"B<\u000b\u0001\u0004A\bbBA\u001e\u0015\u0001\u0007\u0011QH\u0001\u0006G\u0006\u001c\u0007.\u001a\t\u0005\u0003\u007f\tI%\u0004\u0002\u0002B)!\u00111IA#\u0003!Ig\u000e^3s]\u0006d'bAA$-\u0005\u0019\u0011\r]5\n\t\u0005-\u0013\u0011\t\u0002\u0010\t\u0016\u001cwN]1u_J\u001c8)Y2iK\u0006q\u0001/\u0019:tKR\u000b7o\u001b*pY\u0016\u001cH#\u00033\u0002R\u0005m\u0013QLA0\u0011\u001d\t\u0019f\u0003a\u0001\u0003+\nA\u0001^1tWB\u0019\u00110a\u0016\n\u0007\u0005e#P\u0001\u0003UCN\\\u0007\"\u00025\f\u0001\u0004I\u0007bBA\u0016\u0017\u0001\u0007\u0011Q\u0006\u0005\b\u0003wY\u0001\u0019AA\u001f\u0003E\u0001\u0018M]:f%\u0016dW-Y:f%>dWm\u001d\u000b\nI\u0006\u0015\u0014qNA9\u0003gBq!a\u001a\r\u0001\u0004\tI'A\u0004sK2,\u0017m]3\u0011\u0007e\fY'C\u0002\u0002ni\u0014qAU3mK\u0006\u001cX\rC\u0003i\u0019\u0001\u0007\u0011\u000eC\u0004\u0002,1\u0001\r!!\f\t\u000f\u0005mB\u00021\u0001\u0002>\u0005\tr-\u001a;SK2,\u0017m]3NK6\u0014WM]:\u0015\u0011\u0005e\u0014qPAA\u0003\u0007\u0003BaHA>I&\u0019\u0011Q\u0010\u0011\u0003\r=\u0003H/[8o\u0011\u001d\t9'\u0004a\u0001\u0003SBq!a\u000b\u000e\u0001\u0004\ti\u0003C\u0004\u0002<5\u0001\r!!\u0010\u0002!A\f'o]3HY>\u0014\u0017\r\u001c*pY\u0016\u001cH#B5\u0002\n\u0006-\u0005bBA\u0016\u001d\u0001\u0007\u0011Q\u0006\u0005\u0006g:\u0001\r![\u0001\u0011a\u0006\u00148/\u001a$pY\u0012,'\u000fV3b[N$\u0012\u0002ZAI\u0003'\u000b)*a&\t\u000f\u0005-r\u00021\u0001\u0002.!)\u0001n\u0004a\u0001S\")qo\u0004a\u0001q\"9\u00111H\bA\u0002\u0005u\u0012!D4fi\u0006cG.T3nE\u0016\u00148\u000fF\u0003e\u0003;\u000b9\u000bC\u0004\u0002 B\u0001\r!!)\u0002\tQ,\u0017-\u001c\t\u0004s\u0006\r\u0016bAASu\n!A+Z1n\u0011\u001d\tY\u0003\u0005a\u0001\u0003[A3\u0001AAV!\u0011\ti+a-\u000e\u0005\u0005=&bAAY\u001b\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005U\u0016q\u0016\u0002\b'\u0016\u0014h/[2f\u0001")
public class EmailRecipientResolver {
    private final RoleService roleService;
    private final TeamService teamService;
    private final UserProfileService userProfileService;
    private final PrincipalInfoResolver principalInfoResolver;

    public String resolveRecipient(String principalName) {
        return this.principalInfoResolver.getNotificationEmailOf(principalName);
    }

    public Set<String> resolveRecipients(List<String> roles, List<String> globalRoles, List<String> users, PlanItem planItem, boolean excludeAuthor) {
        List assignments = CollectionConverters$.MODULE$.ListHasAsScala(this.roleService.readRoleAssignments()).asScala().toList();
        DecoratorsCache cache = new DecoratorsCache(DecoratorsCache$.MODULE$.$lessinit$greater$default$1());
        Set allPrincipals = (Set)((SetOps)this.parseRoles((List<Role>)assignments, roles, planItem, cache).$plus$plus(this.parseGlobalRoles((List<Role>)assignments, globalRoles)).$plus$plus(this.parseFolderTeams((List<Role>)assignments, roles, planItem, cache)).$plus$plus(users)).$minus$minus((IterableOnce)(excludeAuthor ? (IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{User.AUTHENTICATED_USER.getName()})) : package$.MODULE$.Nil()));
        return (Set)((IterableOps)((IterableOps)allPrincipals.filter((Function1 & Serializable)username -> BoxesRunTime.boxToBoolean((boolean)this.isUserEnabled(username)))).map((Function1 & Serializable)x$1 -> $this.principalInfoResolver.getNotificationEmailOf(x$1))).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$resolveRecipients$3(x$1)));
    }

    public boolean resolveRecipients$default$5() {
        return false;
    }

    private boolean isUserEnabled(String username) {
        UserProfile profile = this.userProfileService.findByUsername(username);
        return profile != null ? profile.isLoginAllowed() : true;
    }

    private Set<String> parseRoles(List<Role> assignments, List<String> roles, PlanItem planItem, DecoratorsCache cache) {
        Set<String> set;
        PlanItem planItem2 = planItem;
        if (planItem2 instanceof Task) {
            Task task = (Task)planItem2;
            set = this.parseTaskRoles(task, roles, assignments, cache);
        } else if (planItem2 instanceof Release) {
            Release release = (Release)planItem2;
            set = this.parseReleaseRoles(release, roles, assignments, cache);
        } else {
            throw new MatchError((Object)planItem2);
        }
        return set;
    }

    private Set<String> parseTaskRoles(Task task, List<String> roles, List<Role> assignments, DecoratorsCache cache) {
        ObjectRef parsed;
        block3: {
            parsed = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
            boolean shouldSendToTaskOwner = roles.contains((Object)"Task Owner");
            Option taskOwner = Option$.MODULE$.apply((Object)task.getOwner());
            if (shouldSendToTaskOwner && taskOwner.isDefined()) {
                parsed.elem = (Set)((Set)parsed.elem).$plus(taskOwner.get());
            }
            if (roles.contains((Object)"Task Team") || shouldSendToTaskOwner && taskOwner.isEmpty()) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.teamService.findTeamByName(Ids.releaseIdFrom((String)task.getId()), task.getTeam()))).foreach((Function1 & Serializable)x$3 -> {
                    parsed.elem = (Set)((Set)parsed.elem).$plus$plus(this.getAllMembers(x$3, (List<Role>)assignments));
                    return BoxedUnit.UNIT;
                });
            }
            if (roles.contains((Object)RecipientSettings.RELEASE_ADMIN_ROLE_NAME)) {
                parsed.elem = (Set)((Set)parsed.elem).$plus$plus((IterableOnce)this.getReleaseMembers(task.getRelease(), assignments, cache).getOrElse((Function0 & Serializable)() -> package$.MODULE$.Nil()));
            }
            if (!roles.contains((Object)"Watcher")) break block3;
            Set watchers = CollectionConverters$.MODULE$.SetHasAsScala(task.getWatchers()).asScala().toSet();
            watchers.foreach((Function1 & Serializable)x$4 -> {
                parsed.elem = (Set)((Set)parsed.elem).$plus((Object)x$4);
                return BoxedUnit.UNIT;
            });
        }
        return (Set)parsed.elem;
    }

    private Set<String> parseReleaseRoles(Release release, List<String> roles, List<Role> assignments, DecoratorsCache cache) {
        Set parsed;
        block0: {
            parsed = Predef$.MODULE$.Set().empty();
            if (!roles.contains((Object)RecipientSettings.RELEASE_ADMIN_ROLE_NAME)) break block0;
            parsed = (Set)parsed.$plus$plus((IterableOnce)this.getReleaseMembers(release, assignments, cache).getOrElse((Function0 & Serializable)() -> package$.MODULE$.Nil()));
        }
        return parsed;
    }

    private Option<Set<String>> getReleaseMembers(Release release, List<Role> assignments, DecoratorsCache cache) {
        Option effectiveTeams = CollectionConverters$.MODULE$.ListHasAsScala(this.teamService.getEffectiveTeams(release, cache)).asScala().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$getReleaseMembers$1(x$5)));
        return effectiveTeams.map((Function1 & Serializable)x$6 -> this.getAllMembers((Team)x$6, assignments));
    }

    private List<String> parseGlobalRoles(List<Role> assignments, List<String> globalRoles) {
        List<String> list = globalRoles;
        Nil$ nil$ = package$.MODULE$.Nil();
        List<String> list2 = list;
        List list3 = !(nil$ != null ? !nil$.equals(list2) : list2 != null) ? (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$) : assignments.filter((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)globalRoles.contains((Object)r.getName()))).flatMap((Function1 & Serializable)x$7 -> CollectionConverters$.MODULE$.ListHasAsScala(x$7.getPrincipals()).asScala().toList());
        return list3;
    }

    private Set<String> parseFolderTeams(List<Role> assignments, List<String> roles, PlanItem planItem, DecoratorsCache cache) {
        ObjectRef parsed;
        block0: {
            parsed = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
            List folderTeams = (List)roles.diff((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{RecipientSettings.RELEASE_ADMIN_ROLE_NAME, "Task Owner", "Task Team", "Watcher"})));
            String folderId = Ids.findFolderId((String)planItem.getId());
            if (!Strings.isNotEmpty((String)folderId) || Ids.isRoot((String)folderId)) break block0;
            this.teamService.findTeamsByNames(folderId, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)folderTeams).asJava(), cache).forEach(x$8 -> {
                parsed$2.elem = (Set)((Set)parsed$2.elem).$plus$plus(this.getAllMembers((Team)x$8, assignments));
            });
        }
        return (Set)parsed.elem;
    }

    private Set<String> getAllMembers(Team team, List<Role> assignments) {
        Set teamMembers = CollectionConverters$.MODULE$.ListHasAsScala(team.getMembers()).asScala().toSet();
        List roleMembers = CollectionConverters$.MODULE$.ListHasAsScala(team.getRoles()).asScala().toList().flatMap((Function1 & Serializable)roleName -> assignments.find((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$getAllMembers$2(roleName, x$9))).toList().flatMap((Function1 & Serializable)role -> CollectionConverters$.MODULE$.ListHasAsScala(role.getPrincipals()).asScala().toList().map((Function1 & Serializable)principal -> {
            $this.userProfileService.discover(principal);
            return principal;
        })));
        return (Set)teamMembers.$plus$plus((IterableOnce)roleMembers);
    }

    public static final /* synthetic */ boolean $anonfun$resolveRecipients$3(String x$1) {
        return Option$.MODULE$.apply((Object)x$1).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2.trim()))));
    }

    public static final /* synthetic */ boolean $anonfun$getReleaseMembers$1(Team x$5) {
        String string = x$5.getTeamName();
        String string2 = "Release Admin";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getAllMembers$2(String roleName$1, Role x$9) {
        String string = x$9.getName();
        String string2 = roleName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Autowired
    public EmailRecipientResolver(RoleService roleService, TeamService teamService, UserProfileService userProfileService, PrincipalInfoResolver principalInfoResolver) {
        this.roleService = roleService;
        this.teamService = teamService;
        this.userProfileService = userProfileService;
        this.principalInfoResolver = principalInfoResolver;
    }
}

