/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.email;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.notifications.configuration.trigger.RecipientSettings;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.PrincipalInfoResolver;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.service.UserProfileService;
import com.xebialabs.xlrelease.user.User;
import java.io.Serializable;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005me\u0001B\t\u0013\u0001uA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\t[\u0001\u0011\t\u0011)A\u0005]!AA\u0007\u0001B\u0001B\u0003%Q\u0007\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u0011\u0015a\u0004\u0001\"\u0001>\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0011%\t9\u0001AI\u0001\n\u0003\tI\u0001C\u0004\u0002\u001e\u0001!I!a\b\t\u000f\u0005\u0015\u0002\u0001\"\u0003\u0002(!9\u0011\u0011\b\u0001\u0005\n\u0005m\u0002bBA&\u0001\u0011%\u0011Q\n\u0005\b\u0003;\u0002A\u0011BA0\u0011\u001d\tY\u0007\u0001C\u0005\u0003[Bq!a\u001d\u0001\t\u0013\t)\bC\u0004\u0002~\u0001!I!a \u0003-\u0015k\u0017-\u001b7SK\u000eL\u0007/[3oiJ+7o\u001c7wKJT!a\u0005\u000b\u0002\u000b\u0015l\u0017-\u001b7\u000b\u0005U1\u0012!\u00048pi&4\u0017nY1uS>t7O\u0003\u0002\u00181\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u00033i\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003m\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\u0010\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\r\u0005s\u0017PU3g\u0003-\u0011x\u000e\\3TKJ4\u0018nY3\u0011\u0005\u0019ZS\"A\u0014\u000b\u0005!J\u0013\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005)B\u0012\u0001\u00033fa2|\u00170\u001b;\n\u00051:#a\u0003*pY\u0016\u001cVM\u001d<jG\u0016\f1\u0002^3b[N+'O^5dKB\u0011qFM\u0007\u0002a)\u0011\u0011GF\u0001\bg\u0016\u0014h/[2f\u0013\t\u0019\u0004GA\u0006UK\u0006l7+\u001a:wS\u000e,\u0017AE;tKJ\u0004&o\u001c4jY\u0016\u001cVM\u001d<jG\u0016\u0004\"a\f\u001c\n\u0005]\u0002$AE+tKJ\u0004&o\u001c4jY\u0016\u001cVM\u001d<jG\u0016\fQ\u0003\u001d:j]\u000eL\u0007/\u00197J]\u001a|'+Z:pYZ,'\u000f\u0005\u00020u%\u00111\b\r\u0002\u0016!JLgnY5qC2LeNZ8SKN|GN^3s\u0003\u0019a\u0014N\\5u}Q)a\bQ!C\u0007B\u0011q\bA\u0007\u0002%!)A%\u0002a\u0001K!)Q&\u0002a\u0001]!)A'\u0002a\u0001k!)\u0001(\u0002a\u0001s!\u0012Q!\u0012\t\u0003\rFk\u0011a\u0012\u0006\u0003\u0011&\u000b!\"\u00198o_R\fG/[8o\u0015\tQ5*A\u0004gC\u000e$xN]=\u000b\u00051k\u0015!\u00022fC:\u001c(B\u0001(P\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001)\u0002\u0007=\u0014x-\u0003\u0002S\u000f\nI\u0011)\u001e;po&\u0014X\rZ\u0001\u0011e\u0016\u001cx\u000e\u001c<f%\u0016\u001c\u0017\u000e]5f]R$\"!\u00161\u0011\u0005YkfBA,\\!\tA\u0006%D\u0001Z\u0015\tQF$\u0001\u0004=e>|GOP\u0005\u00039\u0002\na\u0001\u0015:fI\u00164\u0017B\u00010`\u0005\u0019\u0019FO]5oO*\u0011A\f\t\u0005\u0006C\u001a\u0001\r!V\u0001\u000eaJLgnY5qC2t\u0015-\\3\u0002#I,7o\u001c7wKJ+7-\u001b9jK:$8\u000f\u0006\u0004eOJ$hO \t\u0004-\u0016,\u0016B\u00014`\u0005\r\u0019V\r\u001e\u0005\u0006Q\u001e\u0001\r![\u0001\u0006e>dWm\u001d\t\u0004U>,fBA6n\u001d\tAF.C\u0001\"\u0013\tq\u0007%A\u0004qC\u000e\\\u0017mZ3\n\u0005A\f(\u0001\u0002'jgRT!A\u001c\u0011\t\u000bM<\u0001\u0019A5\u0002\u0017\u001ddwNY1m%>dWm\u001d\u0005\u0006k\u001e\u0001\r![\u0001\u0006kN,'o\u001d\u0005\u0006o\u001e\u0001\r\u0001_\u0001\ta2\fg.\u0013;f[B\u0011\u0011\u0010`\u0007\u0002u*\u00111PF\u0001\u0007I>l\u0017-\u001b8\n\u0005uT(\u0001\u0003)mC:LE/Z7\t\u0011}<\u0001\u0013!a\u0001\u0003\u0003\tQ\"\u001a=dYV$W-Q;uQ>\u0014\bcA\u0010\u0002\u0004%\u0019\u0011Q\u0001\u0011\u0003\u000f\t{w\u000e\\3b]\u0006Y\"/Z:pYZ,'+Z2ja&,g\u000e^:%I\u00164\u0017-\u001e7uIU*\"!a\u0003+\t\u0005\u0005\u0011QB\u0016\u0003\u0003\u001f\u0001B!!\u0005\u0002\u001a5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"A\u0005v]\u000eDWmY6fI*\u0011\u0001\nI\u0005\u0005\u00037\t\u0019BA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\"[:Vg\u0016\u0014XI\\1cY\u0016$G\u0003BA\u0001\u0003CAa!a\t\n\u0001\u0004)\u0016\u0001C;tKJt\u0017-\\3\u0002\u0015A\f'o]3S_2,7\u000fF\u0004e\u0003S\t)$a\u000e\t\u000f\u0005-\"\u00021\u0001\u0002.\u0005Y\u0011m]:jO:lWM\u001c;t!\u0011Qw.a\f\u0011\u0007\u0019\n\t$C\u0002\u00024\u001d\u0012AAU8mK\")\u0001N\u0003a\u0001S\")qO\u0003a\u0001q\u0006q\u0001/\u0019:tKR\u000b7o\u001b*pY\u0016\u001cHc\u00023\u0002>\u0005\u001d\u0013\u0011\n\u0005\b\u0003\u007fY\u0001\u0019AA!\u0003\u0011!\u0018m]6\u0011\u0007e\f\u0019%C\u0002\u0002Fi\u0014A\u0001V1tW\")\u0001n\u0003a\u0001S\"9\u00111F\u0006A\u0002\u00055\u0012!\u00059beN,'+\u001a7fCN,'k\u001c7fgR9A-a\u0014\u0002Z\u0005m\u0003bBA)\u0019\u0001\u0007\u00111K\u0001\be\u0016dW-Y:f!\rI\u0018QK\u0005\u0004\u0003/R(a\u0002*fY\u0016\f7/\u001a\u0005\u0006Q2\u0001\r!\u001b\u0005\b\u0003Wa\u0001\u0019AA\u0017\u0003E9W\r\u001e*fY\u0016\f7/Z'f[\n,'o\u001d\u000b\u0007\u0003C\n9'!\u001b\u0011\t}\t\u0019\u0007Z\u0005\u0004\u0003K\u0002#AB(qi&|g\u000eC\u0004\u0002R5\u0001\r!a\u0015\t\u000f\u0005-R\u00021\u0001\u0002.\u0005\u0001\u0002/\u0019:tK\u001ecwNY1m%>dWm\u001d\u000b\u0006S\u0006=\u0014\u0011\u000f\u0005\b\u0003Wq\u0001\u0019AA\u0017\u0011\u0015\u0019h\u00021\u0001j\u0003A\u0001\u0018M]:f\r>dG-\u001a:UK\u0006l7\u000fF\u0004e\u0003o\nI(a\u001f\t\u000f\u0005-r\u00021\u0001\u0002.!)\u0001n\u0004a\u0001S\")qo\u0004a\u0001q\u0006iq-\u001a;BY2lU-\u001c2feN$R\u0001ZAA\u0003\u0017Cq!a!\u0011\u0001\u0004\t))\u0001\u0003uK\u0006l\u0007cA=\u0002\b&\u0019\u0011\u0011\u0012>\u0003\tQ+\u0017-\u001c\u0005\b\u0003W\u0001\u0002\u0019AA\u0017Q\r\u0001\u0011q\u0012\t\u0005\u0003#\u000b9*\u0004\u0002\u0002\u0014*\u0019\u0011QS'\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002\u001a\u0006M%aB*feZL7-\u001a")
public class EmailRecipientResolver {
    private final RoleService roleService;
    private final TeamService teamService;
    private final UserProfileService userProfileService;
    private final PrincipalInfoResolver principalInfoResolver;

    public String resolveRecipient(String principalName) {
        return this.principalInfoResolver.getNotificationEmailOf(principalName);
    }

    public Set<String> resolveRecipients(List<String> roles, List<String> globalRoles, List<String> users, PlanItem planItem, boolean excludeAuthor) {
        List assignments = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService.readRoleAssignments()).asScala()).toList();
        Set allPrincipals = (Set)this.parseRoles((List<Role>)assignments, roles, planItem).$plus$plus(this.parseGlobalRoles((List<Role>)assignments, globalRoles)).$plus$plus(this.parseFolderTeams((List<Role>)assignments, roles, planItem)).$plus$plus(users).$minus$minus((GenTraversableOnce)(excludeAuthor ? Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{User.AUTHENTICATED_USER.getName()})) : Nil$.MODULE$));
        return (Set)((TraversableLike)((SetLike)allPrincipals.filter((Function1 & Serializable & scala.Serializable)username -> BoxesRunTime.boxToBoolean((boolean)this.isUserEnabled(username)))).map((Function1 & Serializable & scala.Serializable)x$1 -> $this.principalInfoResolver.getNotificationEmailOf(x$1), Set$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$resolveRecipients$3(x$1)));
    }

    public boolean resolveRecipients$default$5() {
        return false;
    }

    private boolean isUserEnabled(String username) {
        UserProfile profile = this.userProfileService.findByUsername(username);
        return profile != null ? profile.isLoginAllowed() : true;
    }

    private Set<String> parseRoles(List<Role> assignments, List<String> roles, PlanItem planItem) {
        Set<String> set;
        PlanItem planItem2 = planItem;
        if (planItem2 instanceof Task) {
            Task task = (Task)planItem2;
            set = this.parseTaskRoles(task, roles, assignments);
        } else if (planItem2 instanceof Release) {
            Release release = (Release)planItem2;
            set = this.parseReleaseRoles(release, roles, assignments);
        } else {
            throw new MatchError((Object)planItem2);
        }
        return set;
    }

    private Set<String> parseTaskRoles(Task task, List<String> roles, List<Role> assignments) {
        ObjectRef parsed;
        block3: {
            parsed = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
            boolean shouldSendToTaskOwner = roles.contains((Object)"Task Owner");
            Option taskOwner = Option$.MODULE$.apply((Object)task.getOwner());
            if (shouldSendToTaskOwner && taskOwner.isDefined()) {
                parsed.elem = (Set)((Set)parsed.elem).$plus(taskOwner.get());
            }
            if (roles.contains((Object)"Task Team") || shouldSendToTaskOwner && taskOwner.isEmpty()) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.teamService.findTeamByName(Ids.releaseIdFrom((String)task.getId()), task.getTeam()))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    parsed.elem = (Set)((Set)parsed.elem).$plus$plus(this.getAllMembers(x$3, (List<Role>)assignments));
                    return BoxedUnit.UNIT;
                });
            }
            if (roles.contains((Object)RecipientSettings.RELEASE_ADMIN_ROLE_NAME)) {
                parsed.elem = (Set)((Set)parsed.elem).$plus$plus((GenTraversableOnce)this.getReleaseMembers(task.getRelease(), assignments).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
            }
            if (!roles.contains((Object)"Watcher")) break block3;
            Set watchers = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(task.getWatchers()).asScala()).toSet();
            watchers.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                parsed.elem = (Set)((Set)parsed.elem).$plus((Object)x$4);
                return BoxedUnit.UNIT;
            });
        }
        return (Set)parsed.elem;
    }

    private Set<String> parseReleaseRoles(Release release, List<String> roles, List<Role> assignments) {
        Set parsed;
        block0: {
            parsed = Predef$.MODULE$.Set().empty();
            if (!roles.contains((Object)RecipientSettings.RELEASE_ADMIN_ROLE_NAME)) break block0;
            parsed = (Set)parsed.$plus$plus((GenTraversableOnce)this.getReleaseMembers(release, assignments).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
        }
        return parsed;
    }

    private Option<Set<String>> getReleaseMembers(Release release, List<Role> assignments) {
        Option effectiveTeams = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.teamService.getEffectiveTeams(release)).asScala()).find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$getReleaseMembers$1(x$5)));
        return effectiveTeams.map((Function1 & Serializable & scala.Serializable)x$6 -> this.getAllMembers((Team)x$6, assignments));
    }

    private List<String> parseGlobalRoles(List<Role> assignments, List<String> globalRoles) {
        List<String> list = globalRoles;
        Object object = Nil$.MODULE$.equals(list) ? Nil$.MODULE$ : (List)((List)assignments.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)globalRoles.contains((Object)r.getName())))).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(x$7.getPrincipals()).asScala()).toList(), List$.MODULE$.canBuildFrom());
        return object;
    }

    private Set<String> parseFolderTeams(List<Role> assignments, List<String> roles, PlanItem planItem) {
        ObjectRef parsed;
        block0: {
            parsed = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
            List folderTeams = (List)roles.diff((GenSeq)new .colon.colon((Object)RecipientSettings.RELEASE_ADMIN_ROLE_NAME, (List)new .colon.colon((Object)"Task Owner", (List)new .colon.colon((Object)"Task Team", (List)new .colon.colon((Object)"Watcher", (List)Nil$.MODULE$)))));
            String folderId = Ids.findFolderId((String)planItem.getId());
            if (!Strings.isNotEmpty((String)folderId) || Ids.isRoot((String)folderId)) break block0;
            this.teamService.findTeamsByNames(folderId, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)folderTeams).asJava()).forEach(x$8 -> {
                parsed$2.elem = (Set)((Set)parsed$2.elem).$plus$plus(this.getAllMembers((Team)x$8, assignments));
            });
        }
        return (Set)parsed.elem;
    }

    private Set<String> getAllMembers(Team team, List<Role> assignments) {
        Set teamMembers = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(team.getMembers()).asScala()).toSet();
        List roleMembers = (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(team.getRoles()).asScala()).toList().flatMap((Function1 & Serializable & scala.Serializable)roleName -> (List)assignments.find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$getAllMembers$2(roleName, x$9))).toList().flatMap((Function1 & Serializable & scala.Serializable)role -> (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(role.getPrincipals()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)principal -> {
            $this.userProfileService.discover(principal);
            return principal;
        }, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
        return (Set)teamMembers.$plus$plus((GenTraversableOnce)roleMembers);
    }

    public static final /* synthetic */ boolean $anonfun$resolveRecipients$4(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2.trim())).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$resolveRecipients$3(String x$1) {
        return Option$.MODULE$.apply((Object)x$1).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$resolveRecipients$4(x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$getReleaseMembers$1(Team x$5) {
        String string = x$5.getTeamName();
        String string2 = "Release Admin";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getAllMembers$2(String roleName$1, Role x$9) {
        String string = x$9.getName();
        String string2 = roleName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Autowired
    public EmailRecipientResolver(RoleService roleService, TeamService teamService, UserProfileService userProfileService, PrincipalInfoResolver principalInfoResolver) {
        this.roleService = roleService;
        this.teamService = teamService;
        this.userProfileService = userProfileService;
        this.principalInfoResolver = principalInfoResolver;
    }
}

