/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.email;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.notifications.configuration.trigger.RecipientSettings;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.PrincipalInfoResolver;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.service.UserProfileService;
import com.xebialabs.xlrelease.user.User;
import java.io.Serializable;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001B\t\u0013\u0001uA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\t[\u0001\u0011\t\u0011)A\u0005]!AA\u0007\u0001B\u0001B\u0003%Q\u0007\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u0011\u0015a\u0004\u0001\"\u0001>\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u0015I\u0007\u0001\"\u0001k\u0011%\t)\u0002AI\u0001\n\u0003\t9\u0002C\u0004\u0002,\u0001!I!!\f\t\u000f\u0005M\u0002\u0001\"\u0003\u00026!9\u0011q\t\u0001\u0005\n\u0005%\u0003bBA-\u0001\u0011%\u00111\f\u0005\b\u0003W\u0002A\u0011BA7\u0011\u001d\tI\b\u0001C\u0005\u0003wBq!!!\u0001\t\u0013\t\u0019\tC\u0004\u0002\f\u0002!I!!$\u0003-\u0015k\u0017-\u001b7SK\u000eL\u0007/[3oiJ+7o\u001c7wKJT!a\u0005\u000b\u0002\u000b\u0015l\u0017-\u001b7\u000b\u0005U1\u0012!\u00048pi&4\u0017nY1uS>t7O\u0003\u0002\u00181\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u00033i\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003m\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\u0010\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\r\u0005s\u0017PU3g\u0003-\u0011x\u000e\\3TKJ4\u0018nY3\u0011\u0005\u0019ZS\"A\u0014\u000b\u0005!J\u0013\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005)B\u0012\u0001\u00033fa2|\u00170\u001b;\n\u00051:#a\u0003*pY\u0016\u001cVM\u001d<jG\u0016\f1\u0002^3b[N+'O^5dKB\u0011qFM\u0007\u0002a)\u0011\u0011GF\u0001\bg\u0016\u0014h/[2f\u0013\t\u0019\u0004GA\u0006UK\u0006l7+\u001a:wS\u000e,\u0017AE;tKJ\u0004&o\u001c4jY\u0016\u001cVM\u001d<jG\u0016\u0004\"a\f\u001c\n\u0005]\u0002$AE+tKJ\u0004&o\u001c4jY\u0016\u001cVM\u001d<jG\u0016\fQ\u0003\u001d:j]\u000eL\u0007/\u00197J]\u001a|'+Z:pYZ,'\u000f\u0005\u00020u%\u00111\b\r\u0002\u0016!JLgnY5qC2LeNZ8SKN|GN^3s\u0003\u0019a\u0014N\\5u}Q)a\bQ!C\u0007B\u0011q\bA\u0007\u0002%!)A%\u0002a\u0001K!)Q&\u0002a\u0001]!)A'\u0002a\u0001k!)\u0001(\u0002a\u0001s!\u0012Q!\u0012\t\u0003\rFk\u0011a\u0012\u0006\u0003\u0011&\u000b!\"\u00198o_R\fG/[8o\u0015\tQ5*A\u0004gC\u000e$xN]=\u000b\u00051k\u0015!\u00022fC:\u001c(B\u0001(P\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001)\u0002\u0007=\u0014x-\u0003\u0002S\u000f\nI\u0011)\u001e;po&\u0014X\rZ\u0001\u0011e\u0016\u001cx\u000e\u001c<f%\u0016\u001c\u0017\u000e]5f]R$\"!V/\u0011\u0005Y[V\"A,\u000b\u0005aK\u0016\u0001\u00027b]\u001eT\u0011AW\u0001\u0005U\u00064\u0018-\u0003\u0002]/\n11\u000b\u001e:j]\u001eDQA\u0018\u0004A\u0002}\u000bQ\u0002\u001d:j]\u000eL\u0007/\u00197OC6,\u0007C\u00011h\u001d\t\tW\r\u0005\u0002cA5\t1M\u0003\u0002e9\u00051AH]8pizJ!A\u001a\u0011\u0002\rA\u0013X\rZ3g\u0013\ta\u0006N\u0003\u0002gA\u0005\t\"/Z:pYZ,'+Z2ja&,g\u000e^:\u0015\u000f-t\u0017p_?\u0002\fA\u0019\u0001\r\\0\n\u00055D'aA*fi\")qn\u0002a\u0001a\u0006)!o\u001c7fgB\u0019\u0011O^0\u000f\u0005I$hB\u00012t\u0013\u0005\t\u0013BA;!\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001e=\u0003\t1K7\u000f\u001e\u0006\u0003k\u0002BQA_\u0004A\u0002A\f1b\u001a7pE\u0006d'k\u001c7fg\")Ap\u0002a\u0001a\u0006)Qo]3sg\")ap\u0002a\u0001\u007f\u0006A\u0001\u000f\\1o\u0013R,W\u000e\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)AF\u0001\u0007I>l\u0017-\u001b8\n\t\u0005%\u00111\u0001\u0002\t!2\fg.\u0013;f[\"I\u0011QB\u0004\u0011\u0002\u0003\u0007\u0011qB\u0001\u000eKb\u001cG.\u001e3f\u0003V$\bn\u001c:\u0011\u0007}\t\t\"C\u0002\u0002\u0014\u0001\u0012qAQ8pY\u0016\fg.A\u000esKN|GN^3SK\u000eL\u0007/[3oiN$C-\u001a4bk2$H%N\u000b\u0003\u00033QC!a\u0004\u0002\u001c-\u0012\u0011Q\u0004\t\u0005\u0003?\t9#\u0004\u0002\u0002\")!\u00111EA\u0013\u0003%)hn\u00195fG.,GM\u0003\u0002IA%!\u0011\u0011FA\u0011\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eSN,6/\u001a:F]\u0006\u0014G.\u001a3\u0015\t\u0005=\u0011q\u0006\u0005\u0007\u0003cI\u0001\u0019A0\u0002\u0011U\u001cXM\u001d8b[\u0016\f!\u0002]1sg\u0016\u0014v\u000e\\3t)\u001dY\u0017qGA\"\u0003\u000bBq!!\u000f\u000b\u0001\u0004\tY$A\u0006bgNLwM\\7f]R\u001c\b\u0003B9w\u0003{\u00012AJA \u0013\r\t\te\n\u0002\u0005%>dW\rC\u0003p\u0015\u0001\u0007\u0001\u000fC\u0003\u007f\u0015\u0001\u0007q0\u0001\bqCJ\u001cX\rV1tWJ{G.Z:\u0015\u000f-\fY%!\u0016\u0002X!9\u0011QJ\u0006A\u0002\u0005=\u0013\u0001\u0002;bg.\u0004B!!\u0001\u0002R%!\u00111KA\u0002\u0005\u0011!\u0016m]6\t\u000b=\\\u0001\u0019\u00019\t\u000f\u0005e2\u00021\u0001\u0002<\u0005\t\u0002/\u0019:tKJ+G.Z1tKJ{G.Z:\u0015\u000f-\fi&a\u001a\u0002j!9\u0011q\f\u0007A\u0002\u0005\u0005\u0014a\u0002:fY\u0016\f7/\u001a\t\u0005\u0003\u0003\t\u0019'\u0003\u0003\u0002f\u0005\r!a\u0002*fY\u0016\f7/\u001a\u0005\u0006_2\u0001\r\u0001\u001d\u0005\b\u0003sa\u0001\u0019AA\u001e\u0003E9W\r\u001e*fY\u0016\f7/Z'f[\n,'o\u001d\u000b\u0007\u0003_\n)(a\u001e\u0011\t}\t\th[\u0005\u0004\u0003g\u0002#AB(qi&|g\u000eC\u0004\u0002`5\u0001\r!!\u0019\t\u000f\u0005eR\u00021\u0001\u0002<\u0005\u0001\u0002/\u0019:tK\u001ecwNY1m%>dWm\u001d\u000b\u0006a\u0006u\u0014q\u0010\u0005\b\u0003sq\u0001\u0019AA\u001e\u0011\u0015Qh\u00021\u0001q\u0003A\u0001\u0018M]:f\r>dG-\u001a:UK\u0006l7\u000fF\u0004l\u0003\u000b\u000b9)!#\t\u000f\u0005er\u00021\u0001\u0002<!)qn\u0004a\u0001a\")ap\u0004a\u0001\u007f\u0006iq-\u001a;BY2lU-\u001c2feN$Ra[AH\u00033Cq!!%\u0011\u0001\u0004\t\u0019*\u0001\u0003uK\u0006l\u0007\u0003BA\u0001\u0003+KA!a&\u0002\u0004\t!A+Z1n\u0011\u001d\tI\u0004\u0005a\u0001\u0003wA3\u0001AAO!\u0011\ty*!*\u000e\u0005\u0005\u0005&bAAR\u001b\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005\u001d\u0016\u0011\u0015\u0002\b'\u0016\u0014h/[2f\u0001")
public class EmailRecipientResolver {
    private final RoleService roleService;
    private final TeamService teamService;
    private final UserProfileService userProfileService;
    private final PrincipalInfoResolver principalInfoResolver;

    public String resolveRecipient(String principalName) {
        return this.principalInfoResolver.getNotificationEmailOf(principalName);
    }

    public Set<String> resolveRecipients(List<String> roles, List<String> globalRoles, List<String> users, PlanItem planItem, boolean excludeAuthor) {
        List assignments = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService.readRoleAssignments()).asScala()).toList();
        Set allPrincipals = (Set)this.parseRoles((List<Role>)assignments, roles, planItem).$plus$plus(this.parseGlobalRoles((List<Role>)assignments, globalRoles)).$plus$plus(this.parseFolderTeams((List<Role>)assignments, roles, planItem)).$plus$plus(users).$minus$minus((GenTraversableOnce)(excludeAuthor ? Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{User.AUTHENTICATED_USER.getName()})) : Nil$.MODULE$));
        return (Set)((TraversableLike)((SetLike)allPrincipals.filter((Function1 & Serializable & scala.Serializable)username -> BoxesRunTime.boxToBoolean((boolean)this.isUserEnabled(username)))).map((Function1 & Serializable & scala.Serializable)x$1 -> $this.principalInfoResolver.getNotificationEmailOf(x$1), Set$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$resolveRecipients$3(x$1)));
    }

    public boolean resolveRecipients$default$5() {
        return false;
    }

    private boolean isUserEnabled(String username) {
        UserProfile profile = this.userProfileService.findByUsername(username);
        return profile != null ? profile.isLoginAllowed() : false;
    }

    private Set<String> parseRoles(List<Role> assignments, List<String> roles, PlanItem planItem) {
        Set<String> set;
        PlanItem planItem2 = planItem;
        if (planItem2 instanceof Task) {
            Task task = (Task)planItem2;
            set = this.parseTaskRoles(task, roles, assignments);
        } else if (planItem2 instanceof Release) {
            Release release = (Release)planItem2;
            set = this.parseReleaseRoles(release, roles, assignments);
        } else {
            throw new MatchError((Object)planItem2);
        }
        return set;
    }

    private Set<String> parseTaskRoles(Task task, List<String> roles, List<Role> assignments) {
        ObjectRef parsed;
        block3: {
            parsed = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
            boolean shouldSendToTaskOwner = roles.contains((Object)"Task Owner");
            Option taskOwner = Option$.MODULE$.apply((Object)task.getOwner());
            if (shouldSendToTaskOwner && taskOwner.isDefined()) {
                parsed.elem = (Set)((Set)parsed.elem).$plus(taskOwner.get());
            }
            if (roles.contains((Object)"Task Team") || shouldSendToTaskOwner && taskOwner.isEmpty()) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.teamService.findTeamByName(Ids.releaseIdFrom((String)task.getId()), task.getTeam()))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    parsed.elem = (Set)((Set)parsed.elem).$plus$plus(this.getAllMembers(x$3, (List<Role>)assignments));
                    return BoxedUnit.UNIT;
                });
            }
            if (roles.contains((Object)RecipientSettings.RELEASE_ADMIN_ROLE_NAME)) {
                parsed.elem = (Set)((Set)parsed.elem).$plus$plus((GenTraversableOnce)this.getReleaseMembers(task.getRelease(), assignments).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
            }
            if (!roles.contains((Object)"Watcher")) break block3;
            Set watchers = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(task.getWatchers()).asScala()).toSet();
            watchers.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                parsed.elem = (Set)((Set)parsed.elem).$plus((Object)x$4);
                return BoxedUnit.UNIT;
            });
        }
        return (Set)parsed.elem;
    }

    private Set<String> parseReleaseRoles(Release release, List<String> roles, List<Role> assignments) {
        Set parsed;
        block0: {
            parsed = Predef$.MODULE$.Set().empty();
            if (!roles.contains((Object)RecipientSettings.RELEASE_ADMIN_ROLE_NAME)) break block0;
            parsed = (Set)parsed.$plus$plus((GenTraversableOnce)this.getReleaseMembers(release, assignments).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
        }
        return parsed;
    }

    private Option<Set<String>> getReleaseMembers(Release release, List<Role> assignments) {
        Option effectiveTeams = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.teamService.getEffectiveTeams(release)).asScala()).find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$getReleaseMembers$1(x$5)));
        return effectiveTeams.map((Function1 & Serializable & scala.Serializable)x$6 -> this.getAllMembers((Team)x$6, assignments));
    }

    private List<String> parseGlobalRoles(List<Role> assignments, List<String> globalRoles) {
        List<String> list = globalRoles;
        Object object = Nil$.MODULE$.equals(list) ? Nil$.MODULE$ : (List)((List)assignments.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)globalRoles.contains((Object)r.getName())))).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(x$7.getPrincipals()).asScala()).toList(), List$.MODULE$.canBuildFrom());
        return object;
    }

    private Set<String> parseFolderTeams(List<Role> assignments, List<String> roles, PlanItem planItem) {
        ObjectRef parsed;
        block0: {
            parsed = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
            List folderTeams = (List)roles.diff((GenSeq)new .colon.colon((Object)RecipientSettings.RELEASE_ADMIN_ROLE_NAME, (List)new .colon.colon((Object)"Task Owner", (List)new .colon.colon((Object)"Task Team", (List)new .colon.colon((Object)"Watcher", (List)Nil$.MODULE$)))));
            String folderId = Ids.findFolderId((String)planItem.getId());
            if (!Strings.isNotEmpty((String)folderId) || Ids.isRoot((String)folderId)) break block0;
            this.teamService.findTeamsByNames(folderId, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)folderTeams).asJava()).forEach(x$8 -> {
                parsed$2.elem = (Set)((Set)parsed$2.elem).$plus$plus(this.getAllMembers((Team)x$8, assignments));
            });
        }
        return (Set)parsed.elem;
    }

    private Set<String> getAllMembers(Team team, List<Role> assignments) {
        Set teamMembers = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(team.getMembers()).asScala()).toSet();
        List roleMembers = (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(team.getRoles()).asScala()).toList().flatMap((Function1 & Serializable & scala.Serializable)roleName -> (List)assignments.find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$getAllMembers$2(roleName, x$9))).toList().flatMap((Function1 & Serializable & scala.Serializable)role -> (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(role.getPrincipals()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)principal -> {
            $this.userProfileService.discover(principal);
            return principal;
        }, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
        return (Set)teamMembers.$plus$plus((GenTraversableOnce)roleMembers);
    }

    public static final /* synthetic */ boolean $anonfun$resolveRecipients$4(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2.trim())).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$resolveRecipients$3(String x$1) {
        return Option$.MODULE$.apply((Object)x$1).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$resolveRecipients$4(x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$getReleaseMembers$1(Team x$5) {
        String string = x$5.getTeamName();
        String string2 = "Release Admin";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getAllMembers$2(String roleName$1, Role x$9) {
        String string = x$9.getName();
        String string2 = roleName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Autowired
    public EmailRecipientResolver(RoleService roleService, TeamService teamService, UserProfileService userProfileService, PrincipalInfoResolver principalInfoResolver) {
        this.roleService = roleService;
        this.teamService = teamService;
        this.userProfileService = userProfileService;
        this.principalInfoResolver = principalInfoResolver;
    }
}

