/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.api.internal;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.notifications.TriggerType$;
import com.xebialabs.xlrelease.notifications.configuration.EmailNotificationSettings;
import com.xebialabs.xlrelease.notifications.configuration.trigger.NotificationTriggerSettings;
import com.xebialabs.xlrelease.notifications.email.EmailNotificationsService;
import com.xebialabs.xlrelease.notifications.views.EmailNotificationSettingsView;
import com.xebialabs.xlrelease.notifications.views.EmailPreviewView;
import com.xebialabs.xlrelease.notifications.views.converters.EmailNotificationSettingsConverter;
import com.xebialabs.xlrelease.security.PermissionChecker;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.reflect.ScalaSignature;

@Path(value="/settings/notifications")
@Produces(value={"application/json"})
@Controller
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d\u0001B\u0006\r\u0001eA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!\t\u0005\tO\u0001\u0011\t\u0011)A\u0005Q!Aa\u0006\u0001B\u0001B\u0003%q\u0006C\u00036\u0001\u0011\u0005a\u0007C\u0004L\u0001\t\u0007I\u0011\u0002'\t\rU\u0003\u0001\u0015!\u0003N\u0011\u00151\u0006\u0001\"\u0001X\u0011\u0015\u0001\b\u0001\"\u0001r\u0011\u0015I\b\u0001\"\u0001{\u0011\u001d\tI\u0002\u0001C\u0001\u00037\u0011QCT8uS\u001aL7-\u0019;j_:\u001c(+Z:pkJ\u001cWM\u0003\u0002\u000e\u001d\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u0010!\u0005\u0019\u0011\r]5\u000b\u0005E\u0011\u0012!\u00048pi&4\u0017nY1uS>t7O\u0003\u0002\u0014)\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003+Y\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003]\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\u000e\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\r\u0005s\u0017PU3g\u0003I)W.Y5m\u001d>$\u0018NZ5dCRLwN\\:\u0011\u0005\t*S\"A\u0012\u000b\u0005\u0011\u0002\u0012!B3nC&d\u0017B\u0001\u0014$\u0005e)U.Y5m\u001d>$\u0018NZ5dCRLwN\\:TKJ4\u0018nY3\u0002\u0017A,'/\\5tg&|gn\u001d\t\u0003S1j\u0011A\u000b\u0006\u0003WI\t\u0001b]3dkJLG/_\u0005\u0003[)\u0012\u0011\u0003U3s[&\u001c8/[8o\u0007\",7m[3s\u0003M\u0019XM\u001d<fe\u000e{gNZ5hkJ\fG/[8o!\t\u00014'D\u00012\u0015\t\u0011D#\u0001\u0005eKBdw._5u\u0013\t!\u0014GA\nTKJ4XM]\"p]\u001aLw-\u001e:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0005oeR4\b\u0005\u00029\u00015\tA\u0002C\u0003!\t\u0001\u0007\u0011\u0005C\u0003(\t\u0001\u0007\u0001\u0006C\u0003/\t\u0001\u0007q\u0006\u000b\u0002\u0005{A\u0011a(S\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u000bC:tw\u000e^1uS>t'B\u0001\"D\u0003\u001d1\u0017m\u0019;pefT!\u0001R#\u0002\u000b\t,\u0017M\\:\u000b\u0005\u0019;\u0015aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003!\u000b1a\u001c:h\u0013\tQuHA\u0005BkR|w/\u001b:fI\u0006I1/\u001a:wKJ,&\u000f\\\u000b\u0002\u001bB\u0011ajU\u0007\u0002\u001f*\u0011\u0001+U\u0001\u0005Y\u0006twMC\u0001S\u0003\u0011Q\u0017M^1\n\u0005Q{%AB*ue&tw-\u0001\u0006tKJ4XM]+sY\u0002\nAdZ3u\u000b6\f\u0017\u000e\u001c(pi&4\u0017nY1uS>t7+\u001a;uS:<7/F\u0001Y!\tIF,D\u0001[\u0015\tY\u0006#A\u0003wS\u0016<8/\u0003\u0002^5\niR)\\1jY:{G/\u001b4jG\u0006$\u0018n\u001c8TKR$\u0018N\\4t-&,w\u000f\u000b\u0003\b?&T\u0007C\u00011h\u001b\u0005\t'B\u00012d\u0003\t\u00118O\u0003\u0002eK\u0006\u0011qo\u001d\u0006\u0002M\u0006)!.\u0019<bq&\u0011\u0001.\u0019\u0002\u0005!\u0006$\b.A\u0003wC2,X-I\u0001l\u0003\u0019)W.Y5mg\"\u0012q!\u001c\t\u0003A:L!a\\1\u0003\u0007\u001d+E+A\u0010va\u0012\fG/Z#nC&dgj\u001c;jM&\u001c\u0017\r^5p]N+G\u000f^5oON$\"\u0001\u0017:\t\u000bMD\u0001\u0019\u0001-\u0002;\u0015l\u0017-\u001b7O_RLg-[2bi&|gnU3ui&twm\u001d,jK^DC\u0001C0jU\"\u0012\u0001B\u001e\t\u0003A^L!\u0001_1\u0003\tA{5\u000bV\u0001\u001ckB$\u0017\r^3F[\u0006LG\u000eV3na2\fG/Z*fiRLgnZ:\u0015\u0005mt\bCA\u000e}\u0013\tiHD\u0001\u0003V]&$\bBB@\n\u0001\u0004\t\t!A\u000eo_RLg-[2bi&|g\u000e\u0016:jO\u001e,'oU3ui&twm\u001d\t\u0005\u0003\u0007\ti!\u0004\u0002\u0002\u0006)!\u0011qAA\u0005\u0003\u001d!(/[4hKJT1!a\u0003\u0011\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&!\u0011qBA\u0003\u0005mqu\u000e^5gS\u000e\fG/[8o)JLwmZ3s'\u0016$H/\u001b8hg\"*\u0011bX5\u0002\u0014\u0005\u0012\u0011QC\u0001\u0017K6\f\u0017\u000e\\:0iJLwmZ3s'\u0016$H/\u001b8hg\"\u0012\u0011B^\u0001\baJ,g/[3x)\u0011\ti\"!\r\u0011\t\u0005}\u0011Q\u0006\b\u0005\u0003C\tI\u0003E\u0002\u0002$qi!!!\n\u000b\u0007\u0005\u001d\u0002$\u0001\u0004=e>|GOP\u0005\u0004\u0003Wa\u0012A\u0002)sK\u0012,g-C\u0002U\u0003_Q1!a\u000b\u001d\u0011\u001d\t\u0019D\u0003a\u0001\u0003k\tAA^5foB\u0019\u0011,a\u000e\n\u0007\u0005e\"L\u0001\tF[\u0006LG\u000e\u0015:fm&,wOV5fo\"*!bX5\u0002>\u0005\u0012\u0011qH\u0001\u000fK6\f\u0017\u000e\\:0aJ,g/[3xQ\tQa\u000fK\u0002\u0001\u0003\u000b\u0002B!a\u0012\u0002N5\u0011\u0011\u0011\n\u0006\u0004\u0003\u0017*\u0015AC:uKJ,w\u000e^=qK&!\u0011qJA%\u0005)\u0019uN\u001c;s_2dWM\u001d\u0015\u0007\u0001\u0005M\u0013.!\u0017\u0011\u0007\u0001\f)&C\u0002\u0002X\u0005\u0014\u0001\u0002\u0015:pIV\u001cWm\u001d\u0017\u0003\u00037\n#!!\u0018\u0002!\u0005\u0004\b\u000f\\5dCRLwN\\\u0018kg>t\u0007&\u0002\u0001`S\u0006\u0005\u0014EAA2\u0003]y3/\u001a;uS:<7o\f8pi&4\u0017nY1uS>t7\u000f")
public class NotificationsResource {
    private final EmailNotificationsService emailNotifications;
    private final PermissionChecker permissions;
    private final String serverUrl;

    private String serverUrl() {
        return this.serverUrl;
    }

    @GET
    @Path(value="emails")
    public EmailNotificationSettingsView getEmailNotificationSettings() {
        this.permissions.check(PlatformPermissions.ADMIN);
        return EmailNotificationSettingsConverter.toView(this.emailNotifications.getSettings());
    }

    @POST
    @Path(value="emails")
    public EmailNotificationSettingsView updateEmailNotificationSettings(EmailNotificationSettingsView emailNotificationSettingsView) {
        this.permissions.check(PlatformPermissions.ADMIN);
        return EmailNotificationSettingsConverter.toView(this.emailNotifications.updateSettings(EmailNotificationSettingsConverter.fromView(emailNotificationSettingsView)));
    }

    @POST
    @Path(value="emails/triggerSettings")
    public void updateEmailTemplateSettings(NotificationTriggerSettings notificationTriggerSettings) {
        this.permissions.check(PlatformPermissions.ADMIN);
        EmailNotificationSettings settings = this.emailNotifications.getSettings();
        settings.setNotificationTriggerSettings(notificationTriggerSettings);
        this.emailNotifications.updateSettings(settings);
    }

    @POST
    @Path(value="emails/preview")
    public String preview(EmailPreviewView view) {
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.emailNotifications.createPreview(TriggerType$.MODULE$.withName(view.triggerType()), view.body(), this.serverUrl());
    }

    @Autowired
    public NotificationsResource(EmailNotificationsService emailNotifications, PermissionChecker permissions, ServerConfiguration serverConfiguration) {
        this.emailNotifications = emailNotifications;
        this.permissions = permissions;
        this.serverUrl = serverConfiguration.getServerUrl();
    }
}

